/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LaneManager {
    public static final int ORDER_INDEPENDENT = 1000;
    public static final int NOT_DEFINED = 0;
    private Hashtable majorLanes = new Hashtable();
    private Hashtable minorLanes = new Hashtable();
    private Hashtable detailedLanes = new Hashtable();
    private Hashtable majorPixels = new Hashtable();
    private Hashtable minorPixels = new Hashtable();
    private Hashtable detailedPixels = new Hashtable();
    private Hashtable laneOrders = new Hashtable();
    private Hashtable aboveHeight = new Hashtable();
    private Hashtable belowHeight = new Hashtable();
    private Hashtable targetLaneHeight;
    private Hashtable nonOverlapFeatures;
    private Vector listeners = new Vector();
    private int currentLOD = 80;
    private static Logger logger = Logger.getLogger(LaneManager.class);

    public LaneManager() {
        this.targetLaneHeight = new Hashtable();
        this.nonOverlapFeatures = new Hashtable();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removeElement(propertyChangeListener);
    }

    protected void notify(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
        }
    }

    protected Hashtable getLanes(int n) throws IllegalArgumentException {
        switch (n) {
            case 60: {
                return this.majorLanes;
            }
            case 70: {
                return this.minorLanes;
            }
            case 80: {
                return this.detailedLanes;
            }
        }
        throw new IllegalArgumentException("Level of Detail must be one of AbstractLinearGraphics .MAJOR_FEATURES .MINOR_FEATURES or .DETAILED_FEATURES");
    }

    protected Hashtable getPixels(int n) throws IllegalArgumentException {
        switch (n) {
            case 60: {
                return this.majorPixels;
            }
            case 70: {
                return this.minorPixels;
            }
            case 80: {
                return this.detailedPixels;
            }
        }
        throw new IllegalArgumentException("Level of Detail must be one of AbstractLinearGraphics .MAJOR_FEATURES .MINOR_FEATURES or .DETAILED_FEATURES");
    }

    public int getTotalHeight(int n) throws Exception {
        return this.getAboveHeight(n) + this.getBelowHeight(n) + 1;
    }

    public double getPixelToALGUnitScale(double d, int n) throws Exception {
        if (d < 0.0) {
            return 1.0f / (float)this.getBelowHeight(n);
        }
        logger.debug("return 1.0f/" + this.getAboveHeight(n));
        return 1.0f / (float)this.getAboveHeight(n);
    }

    public int getAboveHeight(int n) throws Exception {
        Integer n2 = (Integer)this.aboveHeight.get("" + n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    protected void setAboveHeight(int n, int n2) {
        this.aboveHeight.put("" + n, new Integer(n2));
    }

    public int getBelowHeight(int n) throws Exception {
        Integer n2 = (Integer)this.belowHeight.get("" + n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    protected void setBelowHeight(int n, int n2) {
        this.belowHeight.put("" + n, new Integer(n2));
    }

    public void removeLane(String string, int n) throws IllegalArgumentException {
        Hashtable hashtable = this.getLanes(n);
        if (!hashtable.containsKey(string)) {
            throw new IllegalArgumentException("Attempted to remove non-existent lane for feature " + string);
        }
        hashtable.remove(string);
    }

    public void clear() throws IllegalArgumentException {
        this.currentLOD = 80;
        this.majorLanes = new Hashtable();
        this.minorLanes = new Hashtable();
        this.detailedLanes = new Hashtable();
        this.majorPixels = new Hashtable();
        this.minorPixels = new Hashtable();
        this.detailedPixels = new Hashtable();
        this.laneOrders = new Hashtable();
        this.aboveHeight = new Hashtable();
        this.belowHeight = new Hashtable();
        this.listeners = new Vector();
        this.targetLaneHeight = new Hashtable();
        this.nonOverlapFeatures = new Hashtable();
    }

    public void addLane(String string, int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6;
        if (this.getLane(string, n) == null) {
            this.addLane(string, n, n2, n3);
            int[] nArray = new int[]{0, n4, n5};
            Vector<int[]> vector = new Vector<int[]>();
            vector.add(nArray);
            this.nonOverlapFeatures.put(string, vector);
            return;
        }
        Vector vector = (Vector)this.nonOverlapFeatures.get(string);
        Enumeration enumeration = vector.elements();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n7 = 0;
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            if (nArray[0] > n7) {
                n7 = nArray[0];
            }
            if (nArray[1] <= nArray[2]) {
                if (nArray[1] > n5 || nArray[2] < n4) continue;
                hashtable.put(new Integer(nArray[0]), "");
                continue;
            }
            if (nArray[1] > n4 || nArray[2] < n5) continue;
            hashtable.put(new Integer(nArray[0]), "");
        }
        for (n6 = 0; n6 <= n7; ++n6) {
            if (hashtable.containsKey(new Integer(n6))) continue;
            int[] nArray = new int[]{n6, n4, n5};
            vector.add(nArray);
            return;
        }
        this.addLane(string + "#" + n6, n, n2, n3);
        int[] nArray = new int[]{n6, n4, n5};
        vector.add(nArray);
    }

    public void addLane(String string, int n, int n2, int n3) throws Exception {
        Object[] objectArray;
        Object object;
        Hashtable hashtable = this.getLanes(n);
        Hashtable hashtable2 = this.getPixels(n);
        if (hashtable.containsKey(string)) {
            throw new IllegalArgumentException("Attempted to add lane for existing feature " + string);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Requested less than one pixel of lane space allocation: " + n3);
        }
        int n4 = 0;
        int n5 = this.getAboveHeight(n);
        int n6 = this.getBelowHeight(n);
        if (n2 > 0) {
            n4 = n5;
            this.setAboveHeight(n, n5 += n3);
        } else if (n2 < 0) {
            n4 = -n6;
            this.setBelowHeight(n, n6 += n3);
        } else {
            n5 = n6 = n3 / 2;
            this.setAboveHeight(n, n5);
            this.setBelowHeight(n, n6);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            objectArray = (int[])hashtable2.get(object);
            double[] dArray = new double[2];
            int n7 = (Integer)this.laneOrders.get(object);
            if (n7 == 0) {
                int n8 = this.getTargetLane(n);
                logger.debug("Adjusting backbone's pixels: " + n8);
                dArray[0] = (double)n8 / (2.0 * (double)n5);
                dArray[1] = (double)(-n8) / (2.0 * (double)n6);
            } else if (n2 < 0) {
                if (n7 >= 0) continue;
                if (n2 > n7) {
                    if (n4 < objectArray[0]) {
                        n4 = (int)objectArray[0];
                    }
                    objectArray[0] = objectArray[0] - n3;
                    objectArray[1] = objectArray[1] - n3;
                }
                dArray[0] = (double)objectArray[0] / (double)n6;
                dArray[1] = (double)objectArray[1] / (double)n6;
            } else if (n2 > 0) {
                if (n7 <= 0) continue;
                if (n2 < n7) {
                    if (n4 > objectArray[1]) {
                        n4 = (int)objectArray[1];
                    }
                    objectArray[0] = objectArray[0] + n3;
                    objectArray[1] = objectArray[1] + n3;
                }
                dArray[0] = (double)objectArray[0] / (double)n5;
                dArray[1] = (double)objectArray[1] / (double)n5;
            }
            hashtable2.put(object, objectArray);
            hashtable.put(object, dArray);
        }
        object = new int[2];
        objectArray = new double[2];
        if (n2 == 0) {
            object[0] = n3 / 2;
            object[1] = -n3 / 2;
            objectArray[0] = (double)object[0] / (double)n5;
            objectArray[1] = (double)object[1] / (double)n6;
        } else if (n2 > 0) {
            object[0] = n4 + n3;
            object[1] = n4;
            objectArray[0] = (double)object[0] / (double)n5;
            objectArray[1] = (double)object[1] / (double)n5;
        } else {
            object[0] = n4;
            object[1] = n4 - n3;
            objectArray[0] = (double)object[0] / (double)n6;
            objectArray[1] = (double)object[1] / (double)n6;
        }
        hashtable2.put(string, object);
        hashtable.put(string, objectArray);
        this.laneOrders.put(string, new Integer(n2));
        this.notify(string, objectArray, null);
    }

    public void addLane(String string, int n, int[] nArray, int n2, int n3) throws Exception {
        this.addLane(string, n, nArray[0], nArray[1], n2, n3);
    }

    public void addLane(String string, int n, int[] nArray) throws Exception {
        try {
            this.addLane(string, n, nArray[0], nArray[1]);
        }
        catch (Exception exception) {
            logger.warn("Unable to add lane " + string + "; possibly because its name, priority" + " and/or size have not been specified" + " in the related painter class of the markup. \n" + exception.getMessage());
            System.err.println("Unable to add lane " + string + "; possibly because its name, priority" + " and/or size have not been specified" + " in the related painter class of the markup.");
            throw exception;
        }
    }

    public double[] getLane(String string, int n) throws Exception {
        return (double[])this.getLanes(n).get(string);
    }

    public double[] getLane(String string, int n, int n2, int n3) throws Exception {
        Vector vector = (Vector)this.nonOverlapFeatures.get(string);
        if (vector == null) {
            System.err.println("Warning (developer error): asked for non-overlapping lane info for " + string + ", but its lane was not allocated using the overlap-" + "senstive LaneManager.addLane() method, returning the default lane.");
            this.getLane(string, n);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            if (nArray[1] != n2 || nArray[2] != n3) continue;
            String string2 = string;
            if (nArray[0] != 0) {
                string2 = string2 + "#" + nArray[0];
            }
            return this.getLane(string2, n);
        }
        System.err.println("Warning (developer error): asked for lane for " + string + " spanning [" + n2 + ", " + n3 + "], but non-overlap addLane()" + " was not called for this feature, returning the default lane.");
        return this.getLane(string, n);
    }

    public double[] getLane(String string) {
        try {
            double[] dArray = this.getLane(string, this.currentLOD);
            if (dArray == null) {
                logger.warn("Lane " + string + " does not exist: returning null");
            }
            return dArray;
        }
        catch (Exception exception) {
            logger.warn("getLane returning null " + exception.getMessage());
            return null;
        }
    }

    public int getTargetLane(int n) {
        try {
            return (Integer)this.targetLaneHeight.get("" + n);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            return 0;
        }
    }

    public void setTargetLane(String string, int n, int n2) throws Exception {
        this.addLane(string, n, 0, n2);
        this.targetLaneHeight.put("" + n, new Integer(n2));
    }

    public void setLOD(int n) throws IllegalArgumentException {
        if (n == this.currentLOD) {
            return;
        }
        switch (n) {
            case 60: {
                break;
            }
            case 70: {
                break;
            }
            case 80: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Level of Detail must be one of AbstractLinearGraphics .MAJOR_FEATURES .MINOR_FEATURES or .DETAILED_FEATURES");
            }
        }
    }
}

