/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.BioseqSetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ReadSeqFitemPainter
extends BioseqSetPainter {
    private static final Color colorNoType = Color.gray;
    private static final Color darkerGreen = new Color(102, 102, 0);
    private static final Color darkGreen = new Color(0, 102, 0);
    private static final Color green = new Color(0, 204, 0);
    private static final Color lightGreen = new Color(102, 255, 102);
    private static final Color lighterGreen = new Color(204, 255, 204);
    private static final Color darkerRed = new Color(102, 0, 0);
    private static final Color darkRed = new Color(204, 0, 0);
    private static final Color red = new Color(255, 51, 51);
    private static final Color orange = new Color(255, 153, 0);
    private static final Color lighterRed = new Color(255, 204, 204);
    private static final Color darkerPurple = new Color(102, 0, 102);
    private static final Color darkPurple = new Color(204, 0, 204);
    private static final Color purple = new Color(255, 122, 255);
    private static final Color brown = new Color(102, 51, 0);
    private static final Color darkerBlue = new Color(0, 0, 102);
    private static final Color darkBlue = new Color(0, 0, 204);
    private static final Color blue = new Color(51, 51, 255);
    private static final Color lightBlue = new Color(0, 204, 204);
    private static final Color lighterBlue = new Color(204, 255, 255);
    private static final Color khaki = new Color(240, 230, 110);
    private static final Color fuchsia = new Color(255, 0, 255);
    private static final int EXON_UPPER_BOUNDARY_PIXELS = 20;
    private static final int EXON_LOWER_BOUNDARY_PIXELS = 5;
    private static final int EXON_START_LABEL_PIXELS = 25;
    private LaneManager laneMgr;

    public ReadSeqFitemPainter(LaneManager laneManager) {
        this.laneMgr = laneManager;
    }

    public int getPriority() {
        return 60;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        int n = dTDElementInstance.getTarget();
        if (n == -1) {
            System.err.println("Ooops.  parent of " + dTDElementInstance.getLocalName() + " was not a target");
            return;
        }
        String string = "";
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            Vector vector;
            boolean bl = false;
            if (node instanceof Text) {
                string = string + ((Text)node).getData();
                continue;
            }
            if (!(node instanceof DTDElementInstance) || (vector = this.getLocationRanges((DTDElementInstance)node)).isEmpty() || string.startsWith("source")) continue;
            Vector vector2 = ReadSeqFitemPainter.setFeaturePars(string);
            System.err.println("Calling draw for " + dTDElementInstance);
            ReadSeqFitemPainter.draw(abstractLinearGraphics, dTDElementInstance, vector2, n, vector, bl);
        }
    }

    public int[] getFeatureRange(DTDElementInstance dTDElementInstance) {
        String string = "";
        for (Node node = dTDElementInstance.getFirstChild(); node != null; node = node.getNextSibling()) {
            int n;
            Vector vector;
            boolean bl = false;
            if (node instanceof Text) {
                string = string + ((Text)node).getData().trim();
                continue;
            }
            if (!(node instanceof DTDElementInstance) || (vector = this.getLocationRanges((DTDElementInstance)node)).isEmpty() || string.startsWith("source")) continue;
            int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
            while (!vector.isEmpty()) {
                n = (Integer)vector.firstElement();
                vector.removeElementAt(0);
                if (n < nArray[0]) {
                    nArray[0] = n;
                }
                if (n <= nArray[1]) continue;
                nArray[1] = n;
            }
            if (bl) {
                n = nArray[0];
                nArray[0] = nArray[1];
                nArray[1] = n;
            }
            System.err.println("Feature range for fitem is (" + nArray[0] + "," + nArray[1] + ")");
            return nArray;
        }
        return super.getFeatureRange(dTDElementInstance);
    }

    private Vector getLocationRanges(DTDElementInstance dTDElementInstance) {
        Vector<Integer> vector = new Vector<Integer>();
        if (dTDElementInstance == null || !dTDElementInstance.getLocalName().equals("floc")) {
            return vector;
        }
        dTDElementInstance.normalize();
        String string = ((Text)dTDElementInstance.getFirstChild()).getData().trim();
        System.err.println("Checking contents of floc (" + string + ")");
        int n = string.indexOf("..");
        int n2 = string.indexOf("(");
        int n3 = string.indexOf(")");
        int n4 = string.indexOf(",");
        if (n > 0) {
            if (string.startsWith("complement") || string.startsWith("(complement")) {
                if (n4 > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf("complement") + 11, string.length() - 1), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "..");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string3 = stringTokenizer2.nextToken();
                            vector.insertElementAt(new Integer(string3.trim()), 0);
                        }
                    }
                } else {
                    vector.addElement(new Integer(string.substring(n + 2, n3).trim()));
                    vector.addElement(new Integer(string.substring(n2 + 1, n).trim()));
                }
            } else if (string.startsWith("join")) {
                if (n4 > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string.substring(string.indexOf("join") + 5, string.length() - 1), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer3 = new StringTokenizer(string4, "..");
                        while (stringTokenizer3.hasMoreTokens()) {
                            String string5 = stringTokenizer3.nextToken();
                            vector.addElement(new Integer(string5.trim()));
                        }
                    }
                }
            } else {
                vector.addElement(new Integer(string.substring(0, n).trim()));
                vector.addElement(new Integer(string.substring(n + 2).trim()));
            }
        } else {
            vector.addElement(new Integer(string.trim()));
            vector.addElement(new Integer(string.trim()));
        }
        return vector;
    }

    static Vector setFeaturePars(String string) {
        Vector<Object> vector = new Vector<Object>();
        Color color = null;
        String string2 = "";
        String string3 = "";
        if (string.startsWith("rRNA")) {
            color = orange;
            string2 = "rRNA";
            string3 = "//readseq:rRNA";
        } else if (string.startsWith("misc_RNA")) {
            color = brown;
            string2 = "misc_RNA";
            string3 = "//readseq:misc_RNA";
        } else if (string.startsWith("gene")) {
            color = purple;
            string2 = "gene";
            string3 = "//readseq:gene";
        } else if (string.startsWith("CDS")) {
            color = fuchsia;
            string2 = "CDS";
            string3 = "//readseq:CDS";
        } else if (string.startsWith("sig_peptide")) {
            color = khaki;
            string2 = "sig_peptide";
            string3 = "//readseq:sig_peptide";
        } else if (string.startsWith("proprotein")) {
            color = darkPurple;
            string2 = "proprotein";
            string3 = "//readseq:proprotein";
        } else if (string.startsWith("mat_peptide")) {
            color = darkerPurple;
            string2 = "mat_peptide";
            string3 = "//readseq:mat_peptide";
        } else if (string.startsWith("repeat_region")) {
            color = green;
            string2 = "repeat_region";
            string3 = "//readseq:repeat_region";
        } else if (string.startsWith("misc_feature")) {
            color = lightGreen;
            string2 = "misc_feature";
            string3 = "//readseq:misc_feature";
        } else if (string.startsWith("variation")) {
            color = darkerGreen;
            string2 = "variation";
            string3 = "//readseq:variation";
        } else if (string.startsWith("misc_recomb")) {
            color = lighterGreen;
            string2 = "misc_recomb";
            string3 = "//readseq:misc_recomb";
        } else if (string.startsWith("polyA_signal")) {
            color = darkerBlue;
            string2 = "polyA_signal";
            string3 = "//readseq:polyA_signal";
        } else if (string.startsWith("polyA_site")) {
            color = blue;
            string2 = "polyA_site";
            string3 = "//readseq:polyA_site";
        } else if (string.startsWith("tRNA")) {
            color = lighterRed;
            string2 = "tRNA";
            string3 = "//readseq:tRNA";
        }
        vector.addElement(color);
        vector.addElement(string2);
        vector.addElement(string3);
        return vector;
    }

    static void draw(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, Vector vector, int n, Vector vector2, boolean bl) {
        Integer n2 = null;
        Integer n3 = null;
        while (!vector2.isEmpty()) {
            n2 = (Integer)vector2.firstElement();
            vector2.removeElementAt(0);
            n3 = (Integer)vector2.firstElement();
            vector2.removeElementAt(0);
            ReadSeqFitemPainter.draw(abstractLinearGraphics, dTDElementInstance, vector, n, n2, n3, bl);
        }
    }

    static void draw(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance, Vector vector, int n, int n2, int n3, boolean bl) {
        double d;
        double d2;
        double d3;
        Color color = abstractLinearGraphics.getColor();
        Color color2 = (Color)vector.firstElement();
        String string = vector.elementAt(1).toString();
        String string2 = vector.lastElement().toString();
        boolean bl2 = bl;
        double d4 = abstractLinearGraphics.getFeatureFactor();
        double d5 = d3 = dTDElementInstance.getOnCircularTarget() ? 0.05 : 0.05;
        if (!bl2) {
            d2 = 0.18 / d4;
            d = 0.02 / d4;
            double d6 = abstractLinearGraphics.isSixFrameMode() ? 0.63 : 0.18;
            double d7 = (d6 + d3) / d4;
        } else {
            d2 = -0.02 / d4;
            d = -0.18 / d4;
            double d8 = abstractLinearGraphics.isSixFrameMode() ? -0.63 : -0.18;
            double d9 = (d8 - d3) / d4;
        }
        if (Debug.legend && abstractLinearGraphics.getLegend().isAddingItems()) {
            Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            Graphics graphics = image.getGraphics();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
            abstractLinearGraphics.getLegend().addItem(image, string, string2, dTDElementInstance.getXPointer(), color2);
        }
        abstractLinearGraphics.startHyperlink(dTDElementInstance, true);
        abstractLinearGraphics.setColor(color2);
        abstractLinearGraphics.fillRect(n, n2, n3, d2, d);
        abstractLinearGraphics.updateHyperlink(abstractLinearGraphics.getPoint(n, n2, d2 > 0.0 ? d2 : d));
        abstractLinearGraphics.endHyperlink();
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        if (!dTDElementInstance.isModelVisible()) {
            return;
        }
        String string = "";
        String string2 = new String();
        String string3 = new String();
        Vector vector = new Vector();
        Color color = null;
        String string4 = "";
        String string5 = "";
        for (object = dTDElementInstance.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object instanceof Text) {
                string = string + ((Text)object).getData();
                continue;
            }
            if (!(object instanceof DTDElementInstance) || !((DTDElementInstance)object).getLocalName().equals("floc") || string.startsWith("source")) continue;
            vector = ReadSeqFitemPainter.setFeaturePars(string);
        }
        if (!vector.isEmpty()) {
            color = (Color)vector.firstElement();
            string4 = vector.elementAt(1).toString();
            string5 = vector.lastElement().toString();
            if (Debug.legend) {
                object = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                Graphics graphics = ((Image)object).getGraphics();
                graphics.setColor(color);
                graphics.fillRect(0, 0, Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
                abstractLinearGraphics.getLegend().addItem((Image)object, string4, string5, dTDElementInstance.getXPointer(), color);
            }
        }
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return dTDElementInstance.getLocalName();
    }

    public String getToolTip(DTDElementInstance dTDElementInstance) {
        return null;
    }
}

