/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.painter;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.Legend;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.TIGRPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import org.apache.log4j.Logger;

public class TIGRModelPainter
extends TIGRPainter {
    private LaneManager lm;
    private boolean posLaneDrawn;
    private boolean negLaneDrawn;
    private static Logger logger = Logger.getLogger(TIGRModelPainter.class);

    public TIGRModelPainter(LaneManager laneManager) {
        this.lm = laneManager;
        this.posLaneDrawn = false;
        this.negLaneDrawn = false;
    }

    public void paint(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        int n = abstractLinearGraphics.getLOD();
        if (!dTDElementInstance.isModelVisible() || n == 60) {
            return;
        }
        boolean bl = false;
        int[] nArray = this.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            System.err.println("No coords for model available yet");
            return;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        Color color = abstractLinearGraphics.getColor();
        int n4 = 0;
        for (object = dTDElementInstance.getParentNode().getFirstChild(); object != null; object = object.getNextSibling()) {
            if (!(object instanceof DTDElementInstance) || !object.getNodeName().equals("MODEL")) continue;
            ++n4;
            int[] nArray2 = this.getFeatureRange((DTDElementInstance)object);
            int n5 = nArray2[0];
            int n6 = nArray2[1];
            if (n2 == n5 && n3 == n6) break;
        }
        if (n4 > 1) {
            bl = true;
        }
        object = null;
        int n7 = dTDElementInstance.getTarget();
        if (bl) {
            switch (n4) {
                case 2: {
                    System.err.println(n4 + " MODELs OVERLAP!--case 2");
                    object = this.lm.getLane(n2 > n3 ? TIGRPainter.ModelNegLocation_2 : TIGRPainter.ModelPosLocation_2, n);
                    break;
                }
                case 3: {
                    System.err.println(n4 + " MODELs OVERLAP!--case 3");
                    object = this.lm.getLane(n2 > n3 ? TIGRPainter.ModelNegLocation_3 : TIGRPainter.ModelPosLocation_3, n);
                    break;
                }
                case 4: {
                    System.err.println(n4 + " MODELs OVERLAP!--case 4");
                    object = this.lm.getLane(n2 > n3 ? TIGRPainter.ModelNegLocation_4 : TIGRPainter.ModelPosLocation_4, n);
                    break;
                }
                case 5: {
                    System.err.println(n4 + " MODELs OVERLAP!--case 5");
                    object = this.lm.getLane(n2 > n3 ? TIGRPainter.ModelNegLocation_5 : TIGRPainter.ModelPosLocation_5, n);
                }
            }
            if (object == null) {
                System.out.println("Whoa!!!!!!! No lane for model " + n4 + "!");
                return;
            }
        } else {
            object = this.lm.getLane(n2 > n3 ? TIGRPainter.ModelNegLocation : TIGRPainter.ModelPosLocation, n);
            abstractLinearGraphics.setColor(Color.gray);
            if (object == null) {
                System.err.println("Whoa!!!!!!! No lane for model!");
            } else if (n2 > n3) {
                if (!this.negLaneDrawn) {
                    this.drawLaneLine(abstractLinearGraphics, n7, (double)object[0]);
                    this.negLaneDrawn = true;
                }
            } else if (!this.posLaneDrawn) {
                this.drawLaneLine(abstractLinearGraphics, n7, (double)object[1]);
                this.posLaneDrawn = true;
            }
        }
        abstractLinearGraphics.setColor(Color.gray);
        if (n2 > n3) {
            abstractLinearGraphics.fillRect(n7, n3, n2, (double)object[0], (double)object[1]);
        } else {
            abstractLinearGraphics.fillRect(n7, n2, n3, (double)object[0], (double)object[1]);
        }
        abstractLinearGraphics.setColor(color);
    }

    public void updateLegendItem(AbstractLinearGraphics abstractLinearGraphics, DTDElementInstance dTDElementInstance) throws Exception {
        Object object;
        this.posLaneDrawn = false;
        this.negLaneDrawn = false;
        int n = abstractLinearGraphics.getLOD();
        if (n != 60) {
            object = this.lm.getLane(TIGRPainter.ModelPosLocation, n);
            if (object == null) {
                System.out.println("allocate ModelPosLocation");
                this.lm.addLane(TIGRPainter.ModelPosLocation, n, TIGRPainter.getLane(n, TIGRPainter.ModelPosLocation));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelNegLocation, n)) == null) {
                System.out.println("allocate ModelNegLocation");
                this.lm.addLane(TIGRPainter.ModelNegLocation, n, TIGRPainter.getLane(n, TIGRPainter.ModelNegLocation));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelPosLocation_2, n)) == null) {
                System.out.println("allocate ModelPosLocation_2");
                this.lm.addLane(TIGRPainter.ModelPosLocation_2, n, TIGRPainter.getLane(n, TIGRPainter.ModelPosLocation_2));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelNegLocation_2, n)) == null) {
                System.out.println("allocate ModelNegLocation_2");
                this.lm.addLane(TIGRPainter.ModelNegLocation_2, n, TIGRPainter.getLane(n, TIGRPainter.ModelNegLocation_2));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelPosLocation_3, n)) == null) {
                System.out.println("allocate ModelPosLocation_3");
                this.lm.addLane(TIGRPainter.ModelPosLocation_3, n, TIGRPainter.getLane(n, TIGRPainter.ModelPosLocation_3));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelNegLocation_3, n)) == null) {
                System.out.println("allocate ModelNegLocation_3");
                this.lm.addLane(TIGRPainter.ModelNegLocation_3, n, TIGRPainter.getLane(n, TIGRPainter.ModelNegLocation_3));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelPosLocation_4, n)) == null) {
                System.out.println("allocate ModelPosLocation_4");
                this.lm.addLane(TIGRPainter.ModelPosLocation_4, n, TIGRPainter.getLane(n, TIGRPainter.ModelPosLocation_4));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelNegLocation_4, n)) == null) {
                System.out.println("allocate ModelNegLocation_4");
                this.lm.addLane(TIGRPainter.ModelNegLocation_4, n, TIGRPainter.getLane(n, TIGRPainter.ModelNegLocation_4));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelPosLocation_5, n)) == null) {
                System.out.println("allocate ModelPosLocation_5");
                this.lm.addLane(TIGRPainter.ModelPosLocation_5, n, TIGRPainter.getLane(n, TIGRPainter.ModelPosLocation_5));
            }
            if ((object = (Object)this.lm.getLane(TIGRPainter.ModelNegLocation_5, n)) == null) {
                System.out.println("allocate ModelNegLocation_5");
                this.lm.addLane(TIGRPainter.ModelNegLocation_5, n, TIGRPainter.getLane(n, TIGRPainter.ModelNegLocation_5));
            }
        }
        object = "MODEL";
        String string = "//tigr:MODEL";
        Color color = Color.gray;
        Image image = abstractLinearGraphics.getLegend().createImage(Legend.SWATCH_WIDTH, Legend.SWATCH_HEIGHT);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, Legend.SWATCH_WIDTH - 1, Legend.SWATCH_HEIGHT - 1);
        abstractLinearGraphics.getLegend().addItem(image, (String)object, string, dTDElementInstance.getXPointer(), color);
    }

    public String getLegendLabel(DTDElementInstance dTDElementInstance) {
        return "Transcriptional model";
    }
}

