/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import java.awt.Color;
import java.util.Hashtable;

public class Conversion {
    public static final int STANDARD_CODE = 1;
    public static final int VERTEBRATE_MITO_CODE = 2;
    public static final int YEAST_MITO_CODE = 3;
    public static final int MOLD_PROTOZOAN_COELENTERATE_MITO_CODE = 41;
    public static final int MYCOPLASMA_SPIROPLASMA_CODE = 42;
    public static final int INVERTEBRATE_MITO_CODE = 5;
    public static final int CILIATE_DASYCLADACEAN_HEXAMITA_NUCLEAR_CODE = 6;
    public static final int ECHINODERM_FLATWORM_MITO_CODE = 9;
    public static final int EUPLOTID_NUCLEAR_CODE = 10;
    public static final int BACTERIAL_PLANT_PLASTID_CODE = 11;
    public static final int ALTERNATIVE_YEAST_NUCLEAR_CODE = 12;
    public static final int ASCIDIAN_MITO_CODE = 13;
    public static final int ALTERNATIVE_FLATWORM_MITO_CODE = 14;
    public static final int BLEPHARISMA_NUCLEAR_CODE = 15;
    public static final int CHLOROPHYCEAN_MITO_CODE = 16;
    public static final int TREMATODE_MITO_CODE = 21;
    public static final int SCENEDESMUS_OBLIQUUS_MITO_CODE = 22;
    public static final int THRAUSTOCHYTRIUM_MITO_CODE = 23;
    public static final String STANDARD_CODE_STR = "The Standard Code";
    public static final String VERTEBRATE_MITO_CODE_STR = "The Vertebrate Mitochondrial Code";
    public static final String YEAST_MITO_CODE_STR = "The Yeast Mitochondrial Code";
    public static final String MOLD_PROTOZOAN_COELENTERATE_MITO_CODE_STR = "The Mold, Protozoan, and Coelenterate Mitochondrial Code";
    public static final String MYCOPLASMA_SPIROPLASMA_CODE_STR = "The Mycoplasma/Spiroplasma Code";
    public static final String INVERTEBRATE_MITO_CODE_STR = "The Invertebrate Mitochondrial Code";
    public static final String CILIATE_DASYCLADACEAN_HEXAMITA_NUCLEAR_CODE_STR = "The Ciliate, Dasycladacean and Hexamita Nuclear Code";
    public static final String ECHINODERM_FLATWORM_MITO_CODE_STR = "The Echinoderm and Flatworm Mitochondrial Code";
    public static final String EUPLOTID_NUCLEAR_CODE_STR = "The Euplotid Nuclear Code";
    public static final String BACTERIAL_PLANT_PLASTID_CODE_STR = "The Bacterial and Plant Plastid Code";
    public static final String ALTERNATIVE_YEAST_NUCLEAR_CODE_STR = "The Alternative Yeast Nuclear Code";
    public static final String ASCIDIAN_MITO_CODE_STR = "The Ascidian Mitochondrial Code";
    public static final String ALTERNATIVE_FLATWORM_MITO_CODE_STR = "The Alternative Flatworm Mitochondrial Code";
    public static final String BLEPHARISMA_NUCLEAR_CODE_STR = "Blepharisma Nuclear Code";
    public static final String CHLOROPHYCEAN_MITO_CODE_STR = "Chlorophycean Mitochondrial Code";
    public static final String TREMATODE_MITO_CODE_STR = "Trematode Mitochondrial Code";
    public static final String SCENEDESMUS_OBLIQUUS_MITO_CODE_STR = "Scenedesmus Obliquus Mitochondrial Code";
    public static final String THRAUSTOCHYTRIUM_MITO_CODE_STR = "Thraustochytrium Mitochondrial Code";
    public static final Color ALA = new Color(100, 100, 100);
    public static final Color ARG = new Color(20, 90, 255);
    public static final Color ASN = new Color(0, 70, 140);
    public static final Color ASP = new Color(230, 10, 10);
    public static final Color CYS = new Color(200, 50, 100);
    public static final Color GLN = new Color(0, 140, 70);
    public static final Color GLU = new Color(150, 10, 150);
    public static final Color GLY = new Color(10, 150, 150);
    public static final Color HIS = new Color(100, 100, 200);
    public static final Color ILE = new Color(15, 130, 15);
    public static final Color LEU = new Color(130, 15, 15);
    public static final Color LYS = new Color(120, 30, 200);
    public static final Color MET = new Color(160, 80, 0);
    public static final Color PHE = new Color(50, 50, 170);
    public static final Color PRO = new Color(220, 150, 130);
    public static final Color SER = new Color(250, 150, 0);
    public static final Color THR = new Color(130, 150, 0);
    public static final Color TRP = new Color(180, 90, 180);
    public static final Color TYR = new Color(50, 180, 20);
    public static final Color VAL = new Color(15, 15, 130);
    public static final Color ASX = new Color(255, 105, 180);
    public static final Color GLX = new Color(255, 105, 180);
    public static final Color OTHER = new Color(190, 160, 110);
    private Hashtable<String, String> translations;
    private Hashtable<String, Color> colors;
    private Hashtable conversions;
    private static int currentTranslationTable = 1;

    public static void setCurrentTranslationTable(int n) {
        currentTranslationTable = n;
    }

    public Conversion() {
        this(currentTranslationTable);
    }

    public Conversion(int n) {
        this.initializeConversionTable();
        this.initializeColorTable();
        switch (n) {
            case 1: {
                this.initializeStandardCodonTable();
                break;
            }
            case 2: {
                this.initializeVertebrateCodonTable();
                break;
            }
            case 3: {
                this.initializeYeastCodonTable();
                break;
            }
            case 41: 
            case 42: {
                this.initializeMoldCodonTable();
                break;
            }
            case 5: {
                this.initializeInvertebrateCodonTable();
                break;
            }
            case 6: {
                this.initializeCiliateCodonTable();
                break;
            }
            case 9: {
                this.initializeEchinodermCodonTable();
                break;
            }
            case 10: {
                this.initializeEuplotidCodonTable();
                break;
            }
            case 11: {
                this.initializeBacterialCodonTable();
                break;
            }
            case 12: {
                this.initializeAltYeastCodonTable();
                break;
            }
            case 13: {
                this.initializeAscidianCodonTable();
                break;
            }
            case 14: {
                this.initializeAltFlatwormCodonTable();
                break;
            }
            case 15: {
                this.initializeBlepharismaCodonTable();
                break;
            }
            case 16: {
                this.initializeChlorophyceanCodonTable();
                break;
            }
            case 21: {
                this.initializeTrematodeCodonTable();
                break;
            }
            case 22: {
                this.initializeScenedesmusCodonTable();
                break;
            }
            case 23: {
                this.initializeThraustochytriumCodonTable();
                break;
            }
            default: {
                System.err.println("Codon table not found. Initializing to standard...");
                this.initializeStandardCodonTable();
            }
        }
    }

    public void testRun() {
        int n;
        String string = "attatttaaatcaatttaattaatgtaattatgattagcgatacacaaatattcgtggctcttatattagcactattttcattcgttttag";
        string = string.toUpperCase();
        String[] stringArray = this.translateToOneThreeFrame(string);
        String string2 = Conversion.convertToNegative(string);
        string2 = this.reverse(string2);
        String[] stringArray2 = this.translateToOneThreeFrame(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = this.reverse(stringArray2[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            int n2;
            stringArray[n] = this.convertOneToThree(stringArray[n]);
            stringArray2[n] = this.convertOneToThree(stringArray2[n]);
            String string3 = new String("");
            for (n2 = n; n2 > 0; --n2) {
                string3 = string3 + " ";
            }
            stringArray[n] = string3 = string3 + stringArray[n];
            for (n2 = n; n2 > 0; --n2) {
                int n3 = n;
                stringArray2[n3] = stringArray2[n3] + " ";
            }
            while (stringArray[n].length() < string.length()) {
                int n4 = n;
                stringArray[n4] = stringArray[n4] + "*";
            }
            n2 = string2.length() - stringArray2[n].length();
            string3 = new String("");
            for (int i = 0; i < n2; ++i) {
                string3 = string3 + "*";
            }
            stringArray2[n] = string3 = string3 + stringArray2[n];
        }
        for (n = stringArray.length - 1; n >= 0; --n) {
            System.err.println(stringArray[n]);
        }
        System.err.println(string);
        System.err.println(string2);
        for (n = 0; n < stringArray2.length; ++n) {
            System.err.println(stringArray2[n]);
        }
    }

    public void initializeStandardCodonTable() {
        String string = "FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "---M---------------M---------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeVertebrateCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSS**VVVVAAAADDEEGGGG";
        String string2 = "--------------------------------MMMM---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeYeastCodonTable() {
        String string = "FFLLSSSSYY**CCWWTTTTPPPPHHQQRRRRIIMMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "----------------------------------MM----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeMoldCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "--MM---------------M------------MMMM---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeInvertebrateCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSSSVVVVAAAADDEEGGGG";
        String string2 = "---M----------------------------MMMM---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeCiliateCodonTable() {
        String string = "FFLLSSSSYYQQCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeEchinodermCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeEuplotidCodonTable() {
        String string = "FFLLSSSSYY**CCCWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeBacterialCodonTable() {
        String string = "FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "---M---------------M------------MMMM---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeAltYeastCodonTable() {
        String string = "FFLLSSSSYY**CC*WLLLSPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-------------------M---------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeAscidianCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSGGVVVVAAAADDEEGGGG";
        String string2 = "---M------------------------------MM---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeAltFlatwormCodonTable() {
        String string = "FFLLSSSSYYY*CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeBlepharismaCodonTable() {
        String string = "FFLLSSSSYY*QCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeChlorophyceanCodonTable() {
        String string = "FFLLSSSSYY*LCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeTrematodeCodonTable() {
        String string = "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNNKSSSSVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeScenedesmusCodonTable() {
        String string = "FFLLSS*SYY*LCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "-----------------------------------M----------------------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeThraustochytriumCodonTable() {
        String string = "FF*LSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG";
        String string2 = "--------------------------------M--M---------------M------------";
        this.initializeCodonTable(string, string2);
    }

    public void initializeCodonTable(String string, String string2) {
        String string3 = "TTTTTTTTTTTTTTTTCCCCCCCCCCCCCCCCAAAAAAAAAAAAAAAAGGGGGGGGGGGGGGGG";
        String string4 = "TTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGG";
        String string5 = "TCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAG";
        this.translations = new Hashtable();
        String string6 = null;
        for (int i = 0; i < string.length(); ++i) {
            string6 = new String("");
            string6 = string6 + string3.charAt(i);
            string6 = string6 + string4.charAt(i);
            string6 = string6 + string5.charAt(i);
            this.translations.put(string6, string.substring(i, i + 1));
        }
    }

    public void initializeConversionTable() {
        String string = "GLFKEPIYRDAMWQSVCHNT*";
        String string2 = "GlyLeuPheLysGluProIleTyrArgAspAlaMetTrpGlnSerValCysHisAsnThrSTP";
        this.conversions = new Hashtable();
        for (int i = 0; i < string.length(); ++i) {
            String string3 = string.substring(i, i + 1);
            String string4 = string2.substring(i * 3, i * 3 + 3);
            this.conversions.put(string3, string4);
        }
    }

    public void initializeColorTable() {
        this.colors = new Hashtable();
        this.colors.put("Ala", ALA);
        this.colors.put("Arg", ARG);
        this.colors.put("Asn", ASN);
        this.colors.put("Asp", ASP);
        this.colors.put("Cys", CYS);
        this.colors.put("Gln", GLN);
        this.colors.put("Glu", GLU);
        this.colors.put("Gly", GLY);
        this.colors.put("His", HIS);
        this.colors.put("Ile", ILE);
        this.colors.put("Leu", LEU);
        this.colors.put("Lys", LYS);
        this.colors.put("Met", MET);
        this.colors.put("Phe", PHE);
        this.colors.put("Pro", PRO);
        this.colors.put("Ser", SER);
        this.colors.put("Thr", THR);
        this.colors.put("Trp", TRP);
        this.colors.put("Tyr", TYR);
        this.colors.put("Val", VAL);
        this.colors.put("Asx", ASX);
        this.colors.put("Glx", GLX);
        this.colors.put("Xxx", OTHER);
    }

    public static String convertToNegative(String string) {
        string = string.toUpperCase();
        String string2 = new String("");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == 'A') {
                string2 = string2 + 'T';
                continue;
            }
            if (string.charAt(i) == 'T') {
                string2 = string2 + 'A';
                continue;
            }
            if (string.charAt(i) == 'G') {
                string2 = string2 + 'C';
                continue;
            }
            if (string.charAt(i) != 'C') continue;
            string2 = string2 + 'G';
        }
        return string2;
    }

    public String[] translateToOneThreeFrame(String string) {
        Object var2_2 = null;
        String[] stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = this.translateToOne(string, i);
        }
        return stringArray;
    }

    public String[] translateToThreeThreeFrame(String string) {
        Object var2_2 = null;
        String[] stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = this.translateToThree(string, i);
        }
        return stringArray;
    }

    public String translateToOne(String string, int n) {
        String string2 = new String("");
        String string3 = null;
        int n2 = n;
        while (n2 + 3 < string.length()) {
            string3 = string.substring(n2, n2 + 3);
            String string4 = this.translations.get(string3);
            if (string4 == null) {
                string4 = "X";
            }
            string2 = string2 + " " + string4 + " ";
            n2 += 3;
        }
        return string2;
    }

    public String translateToThree(String string, int n) {
        String string2 = new String("");
        String string3 = null;
        int n2 = n;
        while (n2 + 3 < string.length()) {
            string3 = string.substring(n2, n2 + 3);
            String string4 = this.translations.get(string3);
            string4 = this.convertOneToThree(string4);
            string2 = string2 + string4;
            n2 += 3;
        }
        return string2;
    }

    public String toOne(String string) {
        String string2 = null;
        String string3 = null;
        if (string.length() == 3) {
            string2 = string.substring(0, 3);
            string3 = this.translations.get(string2);
        }
        if (string3 == null) {
            string3 = "X";
        }
        return string3;
    }

    public String toThree(String string) {
        String string2 = null;
        string2 = string.substring(0, 3);
        String string3 = this.translations.get(string2);
        if ((string3 = this.convertOneToThree(string3)) == null) {
            string3 = "Xxx";
        }
        return string3;
    }

    public String reverse(String string) {
        String string2 = new String("");
        for (int i = string.length() - 1; i >= 0; --i) {
            string2 = string2 + string.charAt(i);
        }
        string = string2;
        return string;
    }

    public String convertOneToThree(String string) {
        String string2 = null;
        string = string.replaceAll(" ", "").trim();
        String string3 = new String("");
        for (int i = 0; i < string.length(); ++i) {
            string2 = string.substring(i, i + 1);
            Object object = this.conversions.get(string2);
            if (object == null) {
                System.err.println("Substring \"" + string2 + "\" does not exist");
                object = "Xxx";
            }
            string3 = string3 + object.toString();
        }
        return string3;
    }

    public Color getColor(String string) {
        Color color = this.colors.get(string);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }
}

