/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class REBASEParser {
    public static final int ALL_ENZYMES = 278;
    public static final int COMMERCIAL_ENZYMES = 46487;
    public static final int COMMON_ENZYMES = 1705;
    public static final int COMMON_THRESHOLD = 10;
    public static final String REBASE_PATH = "docs/allenz.txt";
    private static Hashtable enzymes;
    private static Hashtable enzymeCompanies;

    private static InputStream getREBASEData() throws IOException {
        URL uRL = new REBASEParser().getClass().getClassLoader().getResource(REBASE_PATH);
        if (uRL == null) {
            throw new IOException("Could not find docs/allenz.txt using ClassLoader.getResource(), your Bluejay install seems to be incomplete.");
        }
        return uRL.openStream();
    }

    private static void parseREBASE(InputStream inputStream) throws IOException, ParseException {
        int n;
        enzymes = new Hashtable(4000);
        enzymeCompanies = new Hashtable(4000);
        byte[] byArray = new byte[4096];
        String string = "";
        while ((n = inputStream.read(byArray)) > 0) {
            string = string + new String(byArray, 0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", false);
        String string2 = "N/A";
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer.nextToken();
                if ("1".equals(string4)) {
                    string2 = REBASEParser.restOfLine(stringTokenizer, string2);
                    continue;
                }
                if ("5".equals(string4)) {
                    enzymes.put(string2, REBASEParser.restOfLine(stringTokenizer, string2));
                    continue;
                }
                if (!"7".equals(string4) || (string3 = REBASEParser.restOfLine(stringTokenizer, string2)) == null || string3.length() == 0) continue;
                enzymeCompanies.put(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ParseException("Unexpected end of file", string.length());
        }
    }

    public static Hashtable getCommonEnzymes(int n) throws Exception {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = REBASEParser.getEnzymes();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)enzymeCompanies.get(string);
            if (string2 == null || string2.length() < n) continue;
            hashtable.put(string, hashtable2.get(string));
        }
        return hashtable;
    }

    private static String restOfLine(StringTokenizer stringTokenizer, String string) throws NoSuchElementException, ParseException {
        String string2 = stringTokenizer.nextToken();
        if (string2.indexOf("\n") == -1) {
            throw new ParseException("Unexpected end of file while parsing enzyme record " + string, 0);
        }
        return string2.substring(0, string2.indexOf("\n")).replaceAll("^", "");
    }

    public static Hashtable getEnzymes() throws IOException, ParseException {
        if (enzymes == null) {
            REBASEParser.parseREBASE(REBASEParser.getREBASEData());
        }
        return enzymes;
    }
}

