/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.session;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ConnectionPool {
    private Hashtable connections = new Hashtable();
    private String dbURL;
    private String user;
    private String password;
    private int noc;
    private int max;
    private int current;

    public ConnectionPool() {
        Object var1_1 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ca.ucalgary.bluejay.session.data.dbProperties");
            this.dbURL = resourceBundle.getString("dbURL");
            this.user = resourceBundle.getString("user");
            this.password = resourceBundle.getString("password");
            this.noc = Integer.parseInt(resourceBundle.getString("initial"));
            this.max = Integer.parseInt(resourceBundle.getString("max"));
            this.current = 0;
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("cPool-dbProperties.dat" + missingResourceException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("cPool--numberFormatException" + numberFormatException.getMessage());
        }
        this.initializePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        Connection connection = null;
        while (true) {
            Object object;
            Enumeration enumeration = this.connections.keys();
            while (enumeration.hasMoreElements()) {
                connection = (Connection)enumeration.nextElement();
                object = this.connections;
                synchronized (object) {
                    Boolean bl = (Boolean)this.connections.get(connection);
                    if (bl == Boolean.FALSE) {
                        try {
                            connection.setAutoCommit(true);
                            this.connections.put(connection, Boolean.TRUE);
                            return connection;
                        }
                        catch (SQLException sQLException) {
                            this.connections.remove(connection);
                            --this.current;
                        }
                    }
                }
            }
            if (this.current < this.max) {
                object = this.connections;
                synchronized (object) {
                    connection = this.getNewConnection();
                    this.connections.put(connection, Boolean.TRUE);
                    return connection;
                }
            }
            object = Thread.currentThread();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.err.println("connectionPool" + interruptedException.getMessage());
                continue;
            }
            break;
        }
    }

    private void initializePool() {
        for (int i = 0; i < this.noc; ++i) {
            Connection connection = this.getNewConnection();
            this.connections.put(connection, Boolean.FALSE);
        }
    }

    private Connection getNewConnection() {
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("cPool- driver: " + classNotFoundException.getMessage());
        }
        try {
            connection = DriverManager.getConnection(this.dbURL, this.user, this.password);
        }
        catch (SQLException sQLException) {
            System.err.println("Couldn't create connection in connectionPool" + sQLException.getMessage());
        }
        ++this.current;
        return connection;
    }

    public void releaseConnection(Connection connection) {
        this.connections.put(connection, Boolean.FALSE);
    }

    public void closeConnections() {
        Enumeration enumeration = this.connections.keys();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                System.err.println("connection close: " + sQLException.getMessage());
            }
        }
    }
}

