/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.ResultSetIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.RDF;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetReifIterator
extends ResultSetIterator {
    protected IDBID m_graphID;
    protected IPSet m_pset;
    protected Node m_subjNode;
    protected Node m_predNode;
    protected Node m_objNode;
    protected Node m_stmtURI;
    protected boolean m_hasType;
    protected boolean m_getTriples;
    protected int m_propCol;
    protected Node m_matchObj;
    protected int m_fragCount;
    protected int m_fragRem;
    protected int m_nextFrag;
    protected static Log logger = LogFactory.getLog(ResultSetReifIterator.class);

    public ResultSetReifIterator(IPSet p, boolean getTriples, IDBID graphID) {
        this.m_pset = p;
        this.setGraphID(graphID);
        this.m_getTriples = getTriples;
        this.m_matchObj = null;
        this.m_propCol = 0;
    }

    public ResultSetReifIterator(IPSet p, char getProp, IDBID graphID) {
        this.m_pset = p;
        this.setGraphID(graphID);
        this.m_getTriples = true;
        this.m_matchObj = null;
        if (getProp == 'S') {
            this.m_propCol = 1;
        } else if (getProp == 'P') {
            this.m_propCol = 2;
        } else if (getProp == 'O') {
            this.m_propCol = 3;
        } else if (getProp == 'T') {
            this.m_propCol = 4;
        }
    }

    public ResultSetReifIterator(IPSet p, Node getObj, IDBID graphID) {
        this.m_pset = p;
        this.setGraphID(graphID);
        this.m_getTriples = true;
        this.m_matchObj = getObj;
        this.m_propCol = 0;
    }

    public void setGraphID(IDBID gid) {
        this.m_graphID = gid;
    }

    public void reset(ResultSet resultSet, PreparedStatement sourceStatement, SQLCache cache, String opname) {
        super.reset(resultSet, sourceStatement, cache, opname);
    }

    protected void extractRow() throws SQLException {
        boolean rx = true;
        ResultSet rs = this.m_resultSet;
        String subj = rs.getString(1);
        String pred = rs.getString(2);
        String obj = rs.getString(3);
        this.m_stmtURI = this.m_pset.driver().RDBStringToNode(rs.getString(4));
        this.m_hasType = rs.getString(5).equals("T");
        this.m_fragRem = 0;
        if (this.m_hasType && (this.m_matchObj == null || this.m_matchObj.equals(RDF.Nodes.Statement))) {
            ++this.m_fragRem;
        }
        if (subj == null) {
            this.m_subjNode = Node.NULL;
        } else {
            this.m_subjNode = this.m_pset.driver().RDBStringToNode(subj);
            if (this.m_matchObj == null || this.m_matchObj.equals(this.m_subjNode)) {
                ++this.m_fragRem;
            }
        }
        if (pred == null) {
            this.m_predNode = Node.NULL;
        } else {
            this.m_predNode = this.m_pset.driver().RDBStringToNode(pred);
            if (this.m_matchObj == null || this.m_matchObj.equals(this.m_predNode)) {
                ++this.m_fragRem;
            }
        }
        if (obj == null) {
            this.m_objNode = Node.NULL;
        } else {
            this.m_objNode = this.m_pset.driver().RDBStringToNode(obj);
            if (this.m_matchObj == null || this.m_matchObj.equals(this.m_objNode)) {
                ++this.m_fragRem;
            }
        }
        if (this.m_propCol > 0) {
            this.m_nextFrag = this.m_propCol - 1;
            this.m_fragRem = 1;
            this.m_fragCount = 1;
        } else {
            this.m_nextFrag = 0;
            this.m_fragCount = this.m_fragRem;
        }
    }

    protected Object getRow() {
        Triple t = null;
        if (this.m_getTriples) {
            if (this.m_nextFrag == 0) {
                if (!this.m_subjNode.equals(Node.NULL) && (this.m_matchObj == null || this.m_matchObj.equals(this.m_subjNode))) {
                    t = Triple.create(this.m_stmtURI, RDF.Nodes.subject, this.m_subjNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag == 1) {
                if (!this.m_predNode.equals(Node.NULL) && (this.m_matchObj == null || this.m_matchObj.equals(this.m_predNode))) {
                    t = Triple.create(this.m_stmtURI, RDF.Nodes.predicate, this.m_predNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag == 2) {
                if (!this.m_objNode.equals(Node.NULL) && (this.m_matchObj == null || this.m_matchObj.equals(this.m_objNode))) {
                    t = Triple.create(this.m_stmtURI, RDF.Nodes.object, this.m_objNode);
                    --this.m_fragRem;
                } else {
                    ++this.m_nextFrag;
                }
            }
            if (this.m_nextFrag >= 3) {
                if (this.m_hasType && (this.m_matchObj == null || this.m_matchObj.equals(RDF.Nodes.Statement))) {
                    t = Triple.create(this.m_stmtURI, RDF.Nodes.type, RDF.Nodes.Statement);
                    --this.m_fragRem;
                } else {
                    throw new JenaException("Reified triple not found");
                }
            }
            ++this.m_nextFrag;
            if (this.m_fragRem > 0) {
                this.m_prefetched = true;
            }
        } else {
            t = Triple.create(this.m_subjNode, this.m_predNode, this.m_objNode);
        }
        return t;
    }

    protected boolean hasSubj() {
        return this.m_subjNode != Node.NULL;
    }

    protected boolean hasPred() {
        return this.m_predNode != Node.NULL;
    }

    protected boolean hasObj() {
        return this.m_objNode != Node.NULL;
    }

    protected boolean hasType() {
        return this.m_hasType;
    }

    protected int getFragCount() {
        return this.m_fragCount;
    }

    protected Node getStmtURI() {
        return this.m_stmtURI;
    }

    protected boolean getHasType() {
        return this.m_hasType;
    }

    protected void deleteRow() {
        try {
            this.m_resultSet.deleteRow();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Internal sql error", e);
        }
    }
}

