/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFListImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntResourceImpl
extends ResourceImpl
implements OntResource {
    public static final String[] KNOWN_LANGUAGES = new String[]{"http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), "http://www.daml.org/2001/03/daml+oil#", "http://www.w3.org/2001/XMLSchema"};
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntResourceImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to OntResource");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            return node.isURI() || node.isBlank();
        }
    };
    private static final Log log = LogFactory.getLog(OntResourceImpl.class);

    public OntResourceImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public OntModel getOntModel() {
        Model m = this.getModel();
        return m instanceof OntModel ? (OntModel)m : null;
    }

    public Profile getProfile() {
        try {
            return ((OntModel)this.getModel()).getProfile();
        }
        catch (ClassCastException e) {
            throw new JenaException("Resource " + this.toString() + " is not attached to an OntModel, so cannot access its language profile");
        }
    }

    public boolean isOntLanguageTerm() {
        if (!this.isAnon()) {
            for (int i = 0; i < KNOWN_LANGUAGES.length; ++i) {
                if (!this.getURI().startsWith(KNOWN_LANGUAGES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setSameAs(Resource res) {
        this.setPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    public void addSameAs(Resource res) {
        this.addPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    public OntResource getSameAs() {
        return this.objectAsResource(this.getProfile().SAME_AS(), "SAME_AS");
    }

    public ExtendedIterator listSameAs() {
        return this.listAs(this.getProfile().SAME_AS(), "SAME_AS", OntResource.class);
    }

    public boolean isSameAs(Resource res) {
        return this.hasPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    public void removeSameAs(Resource res) {
        this.removePropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    public void setDifferentFrom(Resource res) {
        this.setPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    public void addDifferentFrom(Resource res) {
        this.addPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    public OntResource getDifferentFrom() {
        return this.objectAsResource(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM");
    }

    public ExtendedIterator listDifferentFrom() {
        return this.listAs(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", OntResource.class);
    }

    public boolean isDifferentFrom(Resource res) {
        return this.hasPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    public void removeDifferentFrom(Resource res) {
        this.removePropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    public void setSeeAlso(Resource res) {
        this.setPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    public void addSeeAlso(Resource res) {
        this.addPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    public Resource getSeeAlso() {
        return this.objectAsResource(this.getProfile().SEE_ALSO(), "SEE_ALSO");
    }

    public ExtendedIterator listSeeAlso() {
        this.checkProfile(this.getProfile().SEE_ALSO(), "SEE_ALSO");
        return WrappedIterator.create(this.listProperties(this.getProfile().SEE_ALSO())).mapWith(new ObjectMapper());
    }

    public boolean hasSeeAlso(Resource res) {
        return this.hasPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    public void removeSeeAlso(Resource res) {
        this.removePropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    public void setIsDefinedBy(Resource res) {
        this.setPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    public void addIsDefinedBy(Resource res) {
        this.addPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    public Resource getIsDefinedBy() {
        return this.objectAsResource(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
    }

    public ExtendedIterator listIsDefinedBy() {
        this.checkProfile(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
        return WrappedIterator.create(this.listProperties(this.getProfile().IS_DEFINED_BY())).mapWith(new ObjectMapper());
    }

    public boolean isDefinedBy(Resource res) {
        return this.hasPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    public void removeDefinedBy(Resource res) {
        this.removePropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    public void setVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.removeAll(this.getProfile().VERSION_INFO());
        this.addVersionInfo(info);
    }

    public void addVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.addProperty(this.getProfile().VERSION_INFO(), this.getModel().createLiteral(info));
    }

    public String getVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        try {
            return this.getRequiredProperty(this.getProfile().VERSION_INFO()).getString();
        }
        catch (PropertyNotFoundException ignore) {
            return null;
        }
    }

    public ExtendedIterator listVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return WrappedIterator.create(this.listProperties(this.getProfile().VERSION_INFO())).mapWith(new ObjectAsStringMapper());
    }

    public boolean hasVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return this.hasProperty(this.getProfile().VERSION_INFO(), info);
    }

    public void removeVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        StmtIterator i = this.getModel().listStatements((Resource)this, this.getProfile().VERSION_INFO(), info);
        if (i.hasNext()) {
            i.nextStatement().remove();
        }
        i.close();
    }

    public void setLabel(String label, String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        this.removeAll(this.getProfile().LABEL());
        this.addLabel(label, lang);
    }

    public void addLabel(String label, String lang) {
        this.addLabel(this.getModel().createLiteral(label, lang));
    }

    public void addLabel(Literal label) {
        this.addPropertyValue(this.getProfile().LABEL(), "LABEL", label);
    }

    public String getLabel(String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        if (lang == null || lang.length() == 0) {
            try {
                return this.getRequiredProperty(this.getProfile().LABEL()).getString();
            }
            catch (PropertyNotFoundException ignore) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().LABEL()), lang);
    }

    public ExtendedIterator listLabels(String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        return WrappedIterator.create(this.listProperties(this.getProfile().LABEL())).filterKeep(new LangTagFilter(lang)).mapWith(new ObjectMapper());
    }

    public boolean hasLabel(String label, String lang) {
        return this.hasLabel(this.getModel().createLiteral(label, lang));
    }

    public boolean hasLabel(Literal label) {
        boolean found = false;
        ExtendedIterator i = this.listLabels(label.getLanguage());
        while (!found && i.hasNext()) {
            found = ((Object)label).equals(i.next());
        }
        i.close();
        return found;
    }

    public void removeLabel(String label, String lang) {
        this.removeLabel(this.getModel().createLiteral(label, lang));
    }

    public void removeLabel(Literal label) {
        this.removePropertyValue(this.getProfile().LABEL(), "LABEL", label);
    }

    public void setComment(String comment, String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.removeAll(this.getProfile().COMMENT());
        this.addComment(comment, lang);
    }

    public void addComment(String comment, String lang) {
        this.addComment(this.getModel().createLiteral(comment, lang));
    }

    public void addComment(Literal comment) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.addProperty(this.getProfile().COMMENT(), comment);
    }

    public String getComment(String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        if (lang == null) {
            try {
                return this.getRequiredProperty(this.getProfile().COMMENT()).getString();
            }
            catch (PropertyNotFoundException ignore) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().COMMENT()), lang);
    }

    public ExtendedIterator listComments(String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        return WrappedIterator.create(this.listProperties(this.getProfile().COMMENT())).filterKeep(new LangTagFilter(lang)).mapWith(new ObjectMapper());
    }

    public boolean hasComment(String comment, String lang) {
        return this.hasComment(this.getModel().createLiteral(comment, lang));
    }

    public boolean hasComment(Literal comment) {
        boolean found = false;
        ExtendedIterator i = this.listComments(comment.getLanguage());
        while (!found && i.hasNext()) {
            found = ((Object)comment).equals(i.next());
        }
        i.close();
        return found;
    }

    public void removeComment(String comment, String lang) {
        this.removeComment(this.getModel().createLiteral(comment, lang));
    }

    public void removeComment(Literal comment) {
        this.removePropertyValue(this.getProfile().COMMENT(), "COMMENT", comment);
    }

    public void setRDFType(Resource cls) {
        this.setPropertyValue(RDF.type, "rdf:type", cls);
    }

    public void addRDFType(Resource cls) {
        this.addPropertyValue(RDF.type, "rdf:type", cls);
    }

    public Resource getRDFType() {
        return this.getRDFType(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getRDFType(boolean direct) {
        ExtendedIterator i = null;
        try {
            i = this.listRDFTypes(direct);
            Resource resource = i.hasNext() ? (Resource)i.next() : null;
            return resource;
        }
        finally {
            i.close();
        }
    }

    public ExtendedIterator listRDFTypes(boolean direct) {
        ExtendedIterator i = this.listDirectPropertyValues(RDF.type, "rdf:type", null, this.getProfile().SUB_CLASS_OF(), direct, false);
        ExtendedIterator j = WrappedIterator.create(i);
        return UniqueExtendedIterator.create(j);
    }

    public boolean hasRDFType(String uri) {
        return this.hasRDFType(this.getModel().getResource(uri));
    }

    public boolean hasRDFType(Resource ontClass) {
        return this.hasRDFType(ontClass, "unknown", false);
    }

    public boolean hasRDFType(Resource ontClass, boolean direct) {
        return this.hasRDFType(ontClass, "unknown", direct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasRDFType(Resource ontClass, String name, boolean direct) {
        this.checkProfile(ontClass, name);
        if (!direct) {
            return this.hasPropertyValue(RDF.type, "rdf:type", ontClass);
        }
        ExtendedIterator i = null;
        try {
            i = this.listRDFTypes(true);
            while (i.hasNext()) {
                if (!((Object)ontClass).equals(i.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            i.close();
        }
    }

    public void removeRDFType(Resource cls) {
        this.removePropertyValue(RDF.type, "rdf:type", cls);
    }

    public int getCardinality(Property p) {
        int n = 0;
        ExtendedIterator i = UniqueExtendedIterator.create(this.listPropertyValues(p));
        while (i.hasNext()) {
            i.next();
            ++n;
        }
        return n;
    }

    public void setPropertyValue(Property property, RDFNode value) {
        this.removeAll(property);
        if (value != null) {
            this.addProperty(property, value);
        }
    }

    public RDFNode getPropertyValue(Property property) {
        try {
            return this.getRequiredProperty(property).getObject();
        }
        catch (PropertyNotFoundException ignore) {
            return null;
        }
    }

    public NodeIterator listPropertyValues(Property property) {
        return new NodeIteratorImpl((Iterator)this.listProperties(property).mapWith(new ObjectMapper()), null);
    }

    public void remove() {
        HashSet stmts = new HashSet();
        ArrayList<Resource> lists = new ArrayList<Resource>();
        ArrayList<Statement> skip = new ArrayList<Statement>();
        Property first = this.getProfile().FIRST();
        Iterator i = this.listProperties();
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = this.getModel().listStatements(null, null, this);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = stmts.iterator();
        while (i.hasNext()) {
            Resource obj;
            Statement s = (Statement)i.next();
            if (s.getPredicate().equals(first) && s.getObject().equals(this)) {
                log.debug(this.toString() + " is referened from an RDFList, so will not be fully removed");
                skip.add(s);
                continue;
            }
            if (!(s.getObject() instanceof Resource) || !(obj = s.getResource()).canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? OntResourceImpl.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)) continue;
            lists.add(obj);
        }
        i = lists.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            stmts.addAll(((RDFListImpl)r.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? OntResourceImpl.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)).collectStatements());
        }
        stmts.removeAll(skip);
        i = stmts.iterator();
        while (i.hasNext()) {
            ((Statement)i.next()).remove();
        }
    }

    public void removeProperty(Property property, RDFNode value) {
        HashSet<Statement> s = new HashSet<Statement>();
        Iterator i = this.getModel().listStatements((Resource)this, property, value);
        while (i.hasNext()) {
            s.add(i.nextStatement());
        }
        i = s.iterator();
        while (i.hasNext()) {
            ((Statement)i.next()).remove();
        }
    }

    public AnnotationProperty asAnnotationProperty() {
        return (AnnotationProperty)this.as(AnnotationProperty.class);
    }

    public OntProperty asProperty() {
        return (OntProperty)this.as(OntProperty.class);
    }

    public ObjectProperty asObjectProperty() {
        return (ObjectProperty)this.as(ObjectProperty.class);
    }

    public DatatypeProperty asDatatypeProperty() {
        return (DatatypeProperty)this.as(DatatypeProperty.class);
    }

    public Individual asIndividual() {
        return (Individual)this.as(Individual.class);
    }

    public OntClass asClass() {
        return (OntClass)this.as(OntClass.class);
    }

    public Ontology asOntology() {
        return (Ontology)this.as(Ontology.class);
    }

    public AllDifferent asAllDifferent() {
        return (AllDifferent)this.as(AllDifferent.class);
    }

    public DataRange asDataRange() {
        return (DataRange)this.as(DataRange.class);
    }

    public boolean isAnnotationProperty() {
        return this.getProfile().ANNOTATION_PROPERTY() != null && this.canAs(AnnotationProperty.class);
    }

    public boolean isProperty() {
        return this.canAs(OntProperty.class);
    }

    public boolean isObjectProperty() {
        return this.getProfile().OBJECT_PROPERTY() != null && this.canAs(ObjectProperty.class);
    }

    public boolean isDatatypeProperty() {
        return this.getProfile().DATATYPE_PROPERTY() != null && this.canAs(DatatypeProperty.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndividual() {
        OntModel m = this.getModel() instanceof OntModel ? (OntModel)this.getModel() : null;
        ClosableIterator i = null;
        ClosableIterator j = null;
        try {
            if (m != null) {
                if (!(m.getGraph() instanceof BasicForwardRuleInfGraph) || m.getProfile().THING() == null) {
                    i = this.listProperties(RDF.type);
                    while (i.hasNext()) {
                        Resource rType = i.nextStatement().getResource();
                        if (((Object)rType).equals(m.getProfile().THING())) {
                            boolean bl = true;
                            return bl;
                        }
                        j = rType.listProperties(RDF.type);
                        while (j.hasNext()) {
                            if (!((Object)j.nextStatement().getResource()).equals(this.getProfile().CLASS())) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.hasProperty(RDF.type, this.getProfile().THING());
                return bl;
            }
        }
        finally {
            if (i != null) {
                i.close();
            }
            if (j != null) {
                j.close();
            }
        }
        return this.canAs(Individual.class);
    }

    public boolean isClass() {
        return this.canAs(OntClass.class);
    }

    public boolean isOntology() {
        return this.getProfile().ONTOLOGY() != null && this.canAs(Ontology.class);
    }

    public boolean isDataRange() {
        return this.getProfile().DATARANGE() != null && this.canAs(DataRange.class);
    }

    public boolean isAllDifferent() {
        return this.getProfile().ALL_DIFFERENT() != null && this.canAs(AllDifferent.class);
    }

    protected static boolean hasType(Node n, EnhGraph g, Resource type) {
        boolean hasType = false;
        ExtendedIterator i = g.asGraph().find(n, RDF.type.asNode(), type.asNode());
        hasType = i.hasNext();
        i.close();
        return hasType;
    }

    protected void checkProfile(Object term, String name) {
        if (term == null) {
            throw new ProfileException(name, this.getProfile());
        }
    }

    protected String selectLang(StmtIterator stmts, String lang) {
        String found = null;
        while (stmts.hasNext()) {
            RDFNode n = stmts.nextStatement().getObject();
            if (!(n instanceof Literal)) continue;
            Literal l = (Literal)n;
            String lLang = l.getLanguage();
            if (lang.equalsIgnoreCase(lLang)) {
                found = l.getString();
                break;
            }
            if (lLang != null && lLang.length() > 1 && lang.equalsIgnoreCase(lLang.substring(0, 2))) {
                found = l.getString();
                continue;
            }
            if (found != null || lLang != null) continue;
            found = l.getString();
        }
        stmts.close();
        return found;
    }

    protected boolean langTagMatch(String desired, String target) {
        return desired == null || desired.equalsIgnoreCase(target) || target.length() > desired.length() && desired.equalsIgnoreCase(target.substring(desired.length()));
    }

    protected Object objectAs(Property p, String name, Class asClass) {
        this.checkProfile(p, name);
        try {
            return this.getRequiredProperty(p).getObject().as(asClass);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    protected OntResource objectAsResource(Property p, String name) {
        return (OntResource)this.objectAs(p, name, OntResource.class);
    }

    protected OntProperty objectAsProperty(Property p, String name) {
        return (OntProperty)this.objectAs(p, name, OntProperty.class);
    }

    protected int objectAsInt(Property p, String name) {
        this.checkProfile(p, name);
        return this.getRequiredProperty(p).getInt();
    }

    protected ExtendedIterator listAs(Property p, String name, Class cls) {
        this.checkProfile(p, name);
        return WrappedIterator.create(this.listProperties(p)).mapWith(new ObjectAsMapper(cls));
    }

    protected void addPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        this.addProperty(p, value);
    }

    protected void setPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        this.removeAll(p);
        this.addProperty(p, value);
    }

    protected boolean hasPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        return this.hasProperty(p, value);
    }

    protected void addListPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        if (this.hasProperty(p)) {
            RDFList newValues;
            RDFNode cur = this.getRequiredProperty(p).getObject();
            if (!cur.canAs(RDFList.class)) {
                throw new OntologyException("Tried to add a value to a list-valued property " + p + " but the current value is not a list: " + cur);
            }
            RDFList values = (RDFList)cur.as(RDFList.class);
            if (!values.contains(value) && (newValues = values.with(value)) != values) {
                this.removeAll(p);
                this.addProperty(p, newValues);
            }
        } else {
            this.addProperty(p, ((OntModel)this.getModel()).createList(new RDFNode[]{value}));
        }
    }

    protected RDFNode convertToType(Resource type, String name, Class cls) {
        this.checkProfile(type, name);
        if (this.canAs(cls)) {
            return this.as(cls);
        }
        this.addProperty(RDF.type, type);
        return this.as(cls);
    }

    protected ExtendedIterator listDirectPropertyValues(Property p, String name, Class cls, Property orderRel, boolean direct, boolean inverse) {
        Iterator i = null;
        this.checkProfile(p, name);
        Property sc = p;
        if (direct) {
            sc = this.getModel().getProperty(ReasonerRegistry.makeDirect(sc.asNode()).getURI());
        }
        OntResourceImpl subject = inverse ? null : this;
        OntResourceImpl object = inverse ? this : null;
        Map1 mapper = inverse ? new SubjectAsMapper(cls) : new ObjectAsMapper(cls);
        OntModel m = (OntModel)((Object)this.getGraph());
        InfGraph ig = null;
        if (m.getGraph() instanceof InfGraph) {
            ig = (InfGraph)m.getGraph();
        }
        i = !direct || ig != null && ig.getReasoner().supportsProperty(sc) ? this.getModel().listStatements((Resource)subject, sc, object).mapWith(mapper) : this.computeDirectValues(p, orderRel, inverse, subject, object, mapper);
        return UniqueExtendedIterator.create(i);
    }

    private Iterator computeDirectValues(Property p, Property orderRel, boolean inverse, Resource subject, Resource object, Map1 mapper) {
        Resource r;
        ExtendedIterator j = this.getModel().listStatements(subject, p, object).mapWith(mapper);
        List<Resource> s = new ArrayList();
        while (j.hasNext()) {
            s.add((Resource)j.next());
        }
        ResourceUtils.removeEquiv(s, orderRel, this);
        boolean withheld = s.remove(this);
        List partition = ResourceUtils.partition(s, orderRel);
        HashMap<Resource, List> equivSets = new HashMap<Resource, List>();
        s.clear();
        Iterator i = partition.iterator();
        while (i.hasNext()) {
            List part = (List)i.next();
            if (part.size() == 1) {
                s.add((Resource)part.get(0));
                continue;
            }
            r = (Resource)part.remove(0);
            equivSets.put(r, part);
            s.add(r);
        }
        s = ResourceUtils.maximalLowerElements(s, orderRel, inverse);
        ArrayList<Resource> s2 = new ArrayList<Resource>();
        Iterator i2 = s.iterator();
        while (i2.hasNext()) {
            r = (Resource)i2.next();
            s2.add(r);
            if (!equivSets.containsKey(r)) continue;
            s2.addAll((List)equivSets.get(r));
        }
        if (withheld) {
            s2.add(this);
        }
        return s2.iterator();
    }

    protected void removePropertyValue(Property prop, String name, RDFNode value) {
        this.checkProfile(prop, name);
        StmtIterator i = this.getModel().listStatements((Resource)this, prop, value);
        if (i.hasNext()) {
            i.nextStatement().remove();
        }
        i.close();
    }

    protected class SingleEqualityFilter
    extends Filter {
        private Object m_obj;

        public SingleEqualityFilter(Object x) {
            this.m_obj = x;
        }

        public boolean accept(Object x) {
            return this.m_obj.equals(x);
        }
    }

    protected class LangTagFilter
    extends Filter {
        protected String m_lang;

        public LangTagFilter(String lang) {
            this.m_lang = lang;
        }

        public boolean accept(Object x) {
            if (x instanceof Literal) {
                return OntResourceImpl.this.langTagMatch(this.m_lang, ((Literal)x).getLanguage());
            }
            if (x instanceof Statement) {
                return this.accept(((Statement)x).getObject());
            }
            return false;
        }
    }

    protected static class ObjectMapper
    implements Map1 {
        public Object map1(Object x) {
            return x instanceof Statement ? ((Statement)x).getObject() : x;
        }
    }

    protected class ObjectAsStringMapper
    implements Map1 {
        protected ObjectAsStringMapper() {
        }

        public Object map1(Object x) {
            return x instanceof Statement ? ((Statement)x).getString() : x;
        }
    }

    protected static class ObjectAsMapper
    implements Map1 {
        private Class m_as;

        public ObjectAsMapper(Class as) {
            this.m_as = as;
        }

        public Object map1(Object x) {
            if (x instanceof Statement) {
                RDFNode obj = ((Statement)x).getObject();
                return this.m_as == null ? obj : obj.as(this.m_as);
            }
            return x;
        }
    }

    protected static class SubjectMapper
    implements Map1 {
        protected SubjectMapper() {
        }

        public Object map1(Object x) {
            return x instanceof Statement ? ((Statement)x).getSubject() : x;
        }
    }

    protected static class SubjectAsMapper
    implements Map1 {
        private Class m_as;

        public SubjectAsMapper(Class as) {
            this.m_as = as;
        }

        public Object map1(Object x) {
            if (x instanceof Statement) {
                Resource subj = ((Statement)x).getSubject();
                return this.m_as == null ? subj : subj.as(this.m_as);
            }
            return x;
        }
    }

    protected static class AsMapper
    implements Map1 {
        private Class m_as;

        public AsMapper(Class as) {
            this.m_as = as;
        }

        public Object map1(Object x) {
            return x instanceof Resource ? ((Resource)x).as(this.m_as) : x;
        }
    }
}

