/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryInstancesTranslator
extends DIGQueryTranslator {
    public DIGQueryInstancesTranslator(String predicate) {
        super("*", predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query, "instances");
        da.addClassDescription(instances, pattern.getObject());
        return query;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        DIGConnection dc = da.getConnection();
        Document query = dc.createDigVerb("asks", da.getProfile());
        Element instances = da.createQueryElement(query, "instances");
        if (pattern.getObject().isBlank()) {
            da.addClassDescription(instances, pattern.getObject(), premises);
        } else {
            da.addClassDescription(instances, pattern.getObject());
        }
        return query;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query, DIGAdapter da) {
        return this.translateIndividualSetResponse(response, query, false);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return da.isConcept(object, premises);
    }
}

