/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Alt;
import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.SeqIndexBoundsException;
import com.hp.hpl.jena.regression.NewRegressionBase;
import com.hp.hpl.jena.regression.Regression;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class NewRegressionSeq
extends NewRegressionBase {
    protected Model m;

    public NewRegressionSeq(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NewRegressionSeq.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
    }

    public void tearDown() {
        this.m = null;
    }

    public void testSeqAdd() {
        Seq seq = this.m.createSeq();
        NewRegressionSeq.assertEquals((int)0, (int)seq.size());
        NewRegressionSeq.assertTrue((boolean)this.m.contains((Resource)seq, RDF.type, RDF.Seq));
        seq.add(true);
        NewRegressionSeq.assertTrue((boolean)seq.contains(true));
        NewRegressionSeq.assertFalse((boolean)seq.contains(false));
        seq.add(1L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(1L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(101L));
        seq.add(2L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(2L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(102L));
        seq.add(-1L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-1L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-101L));
        seq.add(-2L);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-2L));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-102L));
        seq.add('!');
        NewRegressionSeq.assertTrue((boolean)seq.contains('!'));
        NewRegressionSeq.assertFalse((boolean)seq.contains('?'));
        seq.add(123.456f);
        NewRegressionSeq.assertTrue((boolean)seq.contains(123.456f));
        NewRegressionSeq.assertFalse((boolean)seq.contains(456.123f));
        seq.add(-123.456);
        NewRegressionSeq.assertTrue((boolean)seq.contains(-123.456));
        NewRegressionSeq.assertFalse((boolean)seq.contains(-456.123));
        seq.add("a string");
        NewRegressionSeq.assertTrue((boolean)seq.contains("a string"));
        NewRegressionSeq.assertFalse((boolean)seq.contains("a necklace"));
        seq.add(this.m.createLiteral("another string"));
        NewRegressionSeq.assertTrue((boolean)seq.contains("another string"));
        NewRegressionSeq.assertFalse((boolean)seq.contains("another necklace"));
        seq.add(new Regression.LitTestObj(12345L));
        NewRegressionSeq.assertTrue((boolean)seq.contains(new Regression.LitTestObj(12345L)));
        NewRegressionSeq.assertFalse((boolean)seq.contains(new Regression.LitTestObj(54321L)));
        Resource present = this.m.createResource(new Regression.ResTestObjF());
        Resource absent = this.m.createResource(new Regression.ResTestObjF());
        seq.add(present);
        NewRegressionSeq.assertTrue((boolean)seq.contains(present));
        NewRegressionSeq.assertFalse((boolean)seq.contains(absent));
        NewRegressionSeq.assertEquals((int)12, (int)seq.size());
    }

    public void testSeqAddInts() {
        int num = 10;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq.add(i);
        }
        NewRegressionSeq.assertEquals((int)10, (int)seq.size());
        List L = NewRegressionSeq.iteratorToList((Iterator)seq.iterator());
        NewRegressionSeq.assertEquals((int)10, (int)L.size());
        for (int i = 0; i < 10; ++i) {
            NewRegressionSeq.assertEquals((int)i, (int)((Literal)L.get(i)).getInt());
        }
    }

    public void testRemoveA() {
        this.testRemove(this.bools("tttffffftt"));
    }

    public void testRemoveB() {
        this.testRemove(this.bools("ftftttttft"));
    }

    public void testRemoveC() {
        this.testRemove(this.bools("ffffffffff"));
    }

    protected boolean[] bools(String s) {
        boolean[] result = new boolean[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            result[i] = s.charAt(i) == 't';
        }
        return result;
    }

    protected void testRemove(boolean[] retain) {
        int num = retain.length;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq.add(i);
        }
        ArrayList<RDFNode> retained = new ArrayList<RDFNode>();
        NodeIterator nIter = seq.iterator();
        for (int i = 0; i < num; ++i) {
            RDFNode x = nIter.nextNode();
            if (retain[i]) {
                retained.add(x);
                continue;
            }
            nIter.remove();
        }
        NewRegressionSeq.assertFalse((boolean)nIter.hasNext());
        NewRegressionSeq.assertEquals(retained, (Object)NewRegressionSeq.iteratorToList((Iterator)seq.iterator()));
    }

    public void testSeqAccessByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq = this.m.createSeq();
        seq.add(true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(1));
        seq.add(1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(2));
        seq.add(2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(3));
        seq.add(-1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(4));
        seq.add(-2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(5));
        seq.add('!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq.getChar(6));
        seq.add(123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(7), (double)5.0E-5);
        seq.add(12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq.getDouble(8), (double)5.0E-8);
        seq.add("some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq.getString(9));
        seq.add(tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq.getObject(10, new Regression.LitTestObjF()));
        seq.add(tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(11));
        seq.add(tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq.getResource(12, new Regression.ResTestObjF()));
        seq.add(tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(13));
        seq.add(tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq.getBag(14));
        seq.add(tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq.getAlt(15));
        seq.add(tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq.getSeq(16));
        try {
            seq.getInt(17);
            NewRegressionSeq.fail((String)"there is no element 17");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        try {
            seq.getInt(0);
            NewRegressionSeq.fail((String)"there is no element 0");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
    }

    public void testSeqInsertByIndexing() {
        Regression.LitTestObj tvObject = new Regression.LitTestObj(12345L);
        Literal tvLiteral = this.m.createLiteral("test 12 string 2");
        Resource tvResource = this.m.createResource();
        Resource tvResObj = this.m.createResource(new Regression.ResTestObjF());
        Regression.LitTestObj tvLitObj = new Regression.LitTestObj(1234L);
        Bag tvBag = this.m.createBag();
        Alt tvAlt = this.m.createAlt();
        Seq tvSeq = this.m.createSeq();
        Seq seq = this.m.createSeq();
        seq.add(this.m.createResource());
        seq.add(1, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(1));
        seq.add(1, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(1));
        seq.add(1, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(1));
        seq.add(1, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(1));
        seq.add(1, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(1));
        seq.add(1, '!');
        NewRegressionSeq.assertEquals((char)'!', (char)seq.getChar(1));
        seq.add(1, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(1), (double)5.0E-5);
        seq.add(1, 12345.6789);
        NewRegressionSeq.assertEquals((double)12345.6789, (double)seq.getDouble(1), (double)5.0E-8);
        seq.add(1, "some string");
        NewRegressionSeq.assertEquals((String)"some string", (String)seq.getString(1));
        seq.add(1, tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq.getObject(1, new Regression.LitTestObjF()));
        seq.add(1, tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(1));
        seq.add(1, tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq.getResource(1, new Regression.ResTestObjF()));
        seq.add(1, tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(1));
        seq.add(1, tvBag);
        NewRegressionSeq.assertEquals((Object)tvBag, (Object)seq.getBag(1));
        seq.add(1, tvAlt);
        NewRegressionSeq.assertEquals((Object)tvAlt, (Object)seq.getAlt(1));
        seq.add(1, tvSeq);
        NewRegressionSeq.assertEquals((Object)tvSeq, (Object)seq.getSeq(1));
        NewRegressionSeq.assertEquals((int)0, (int)seq.indexOf(1234543L));
        NewRegressionSeq.assertEquals((int)1, (int)seq.indexOf(tvSeq));
        NewRegressionSeq.assertEquals((int)2, (int)seq.indexOf(tvAlt));
        NewRegressionSeq.assertEquals((int)3, (int)seq.indexOf(tvBag));
        NewRegressionSeq.assertEquals((int)4, (int)seq.indexOf(tvLiteral));
        NewRegressionSeq.assertEquals((int)6, (int)seq.indexOf(tvResource));
        NewRegressionSeq.assertEquals((int)7, (int)seq.indexOf(tvLitObj));
        NewRegressionSeq.assertEquals((int)8, (int)seq.indexOf("some string"));
        NewRegressionSeq.assertEquals((int)9, (int)seq.indexOf(12345.6789));
        NewRegressionSeq.assertEquals((int)10, (int)seq.indexOf(123.456f));
        NewRegressionSeq.assertEquals((int)11, (int)seq.indexOf('!'));
        NewRegressionSeq.assertEquals((int)12, (int)seq.indexOf(-2L));
        NewRegressionSeq.assertEquals((int)13, (int)seq.indexOf(-1L));
        NewRegressionSeq.assertEquals((int)14, (int)seq.indexOf(2L));
        NewRegressionSeq.assertEquals((int)15, (int)seq.indexOf(1L));
        NewRegressionSeq.assertEquals((int)16, (int)seq.indexOf(true));
    }

    public void testMoreIndexing() {
        int num = 10;
        Seq seq = this.m.createSeq();
        for (int i = 0; i < 10; ++i) {
            seq.add(i);
        }
        try {
            seq.add(0, false);
            NewRegressionSeq.fail((String)"cannot at at position 0");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        seq.add(11, false);
        NewRegressionSeq.assertEquals((int)11, (int)seq.size());
        seq.remove(11);
        try {
            seq.add(12, false);
            NewRegressionSeq.fail((String)"cannot add past the end");
        }
        catch (SeqIndexBoundsException e) {
            NewRegressionSeq.pass();
        }
        int size = seq.size();
        for (int i = 1; i <= 9; ++i) {
            seq.add(i, 1000 + i);
            NewRegressionSeq.assertEquals((int)(1000 + i), (int)seq.getInt(i));
            NewRegressionSeq.assertEquals((int)0, (int)seq.getInt(i + 1));
            NewRegressionSeq.assertEquals((int)(size + i), (int)seq.size());
            NewRegressionSeq.assertEquals((int)(10 - i - 1), (int)seq.getInt(size));
        }
    }

    public void testSet() {
        Model m = this.getModel();
        String test3 = "Test16";
        boolean n = false;
        Literal tvLiteral = m.createLiteral("test 12 string 2");
        Resource tvResource = m.createResource();
        Resource tvResObj = m.createResource(new Regression.ResTestObjF());
        Bag tvBag = m.createBag();
        Alt tvAlt = m.createAlt();
        Seq tvSeq = m.createSeq();
        int num = 10;
        Seq seq = m.createSeq();
        for (int i = 0; i < num; ++i) {
            seq.add(i);
        }
        seq.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 1L);
        NewRegressionSeq.assertEquals((byte)1, (byte)seq.getByte(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 2L);
        NewRegressionSeq.assertEquals((short)2, (short)seq.getShort(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -1L);
        NewRegressionSeq.assertEquals((int)-1, (int)seq.getInt(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -2L);
        NewRegressionSeq.assertEquals((long)-2L, (long)seq.getLong(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, "test 12 string");
        NewRegressionSeq.assertEquals((String)"test 12 string", (String)seq.getString(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, true);
        NewRegressionSeq.assertEquals((boolean)true, (boolean)seq.getBoolean(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, 123.456f);
        NewRegressionSeq.assertEquals((double)123.456f, (double)seq.getFloat(5), (double)5.0E-5);
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, -123.456);
        NewRegressionSeq.assertEquals((double)-123.456, (double)seq.getDouble(5), (double)5.0E-9);
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, tvLiteral);
        NewRegressionSeq.assertEquals((Object)tvLiteral, (Object)seq.getLiteral(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, tvResource);
        NewRegressionSeq.assertEquals((Object)tvResource, (Object)seq.getResource(5));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, tvLitObj);
        NewRegressionSeq.assertEquals((Object)tvLitObj, (Object)seq.getObject(5, new Regression.LitTestObjF()));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
        seq.set(5, tvResObj);
        NewRegressionSeq.assertEquals((Object)tvResObj, (Object)seq.getResource(5, new Regression.ResTestObjF()));
        NewRegressionSeq.assertEquals((int)3, (int)seq.getInt(4));
        NewRegressionSeq.assertEquals((int)5, (int)seq.getInt(6));
        NewRegressionSeq.assertEquals((int)num, (int)seq.size());
    }
}

