/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LocatorZip
implements Locator {
    static Log log = LogFactory.getLog(LocatorZip.class);
    String zipFileName = null;
    ZipFile zipFile = null;

    public LocatorZip(String zfn) {
        try {
            this.zipFileName = zfn;
            this.zipFile = new ZipFile(this.zipFileName);
        }
        catch (IOException ex) {
            throw new JenaException("Problems accessing " + this.zipFileName, ex);
        }
    }

    public InputStream open(String filenameOrURI) {
        ZipEntry entry = this.zipFile.getEntry(filenameOrURI);
        if (entry == null) {
            if (FileManager.logAllLookups && log.isDebugEnabled()) {
                log.debug("Not found: " + this.zipFileName + " : " + filenameOrURI);
            }
            return null;
        }
        try {
            InputStream in = this.zipFile.getInputStream(entry);
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI);
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI);
            }
            return in;
        }
        catch (IOException ex) {
            log.warn("IO Exception opening zip entry: " + filenameOrURI);
            return null;
        }
    }

    public String getName() {
        return "LocatorZip(" + this.zipFileName + ")";
    }
}

