/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public class MessageFormat
extends UFormat {
    static final long serialVersionUID = 7136212545847378651L;
    private Locale locale;
    private ULocale ulocale;
    private String pattern = "";
    private static final int INITIAL_FORMATS = 10;
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "number", "date", "time", "choice", "spellout", "ordinal", "duration"};
    private static final int TYPE_EMPTY = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_DATE = 2;
    private static final int TYPE_TIME = 3;
    private static final int TYPE_CHOICE = 4;
    private static final int TYPE_SPELLOUT = 5;
    private static final int TYPE_ORDINAL = 6;
    private static final int TYPE_DURATION = 7;
    private static final String[] modifierList = new String[]{"", "currency", "percent", "integer"};
    private static final int MODIFIER_EMPTY = 0;
    private static final int MODIFIER_CURRENCY = 1;
    private static final int MODIFIER_PERCENT = 2;
    private static final int MODIFIER_INTEGER = 3;
    private static final String[] dateModifierList = new String[]{"", "short", "medium", "long", "full"};
    private static final int DATE_MODIFIER_EMPTY = 0;
    private static final int DATE_MODIFIER_SHORT = 1;
    private static final int DATE_MODIFIER_MEDIUM = 2;
    private static final int DATE_MODIFIER_LONG = 3;
    private static final int DATE_MODIFIER_FULL = 4;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_IN_QUOTE = 2;
    private static final int STATE_MSG_ELEMENT = 3;

    public MessageFormat(String pattern) {
        this.ulocale = ULocale.getDefault();
        this.applyPattern(pattern);
    }

    public MessageFormat(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale(locale));
    }

    public MessageFormat(String pattern, ULocale locale) {
        this.ulocale = locale;
        this.applyPattern(pattern);
    }

    public void setLocale(Locale locale) {
        this.setLocale(ULocale.forLocale(locale));
    }

    public void setLocale(ULocale locale) {
        String existingPattern = this.toPattern();
        this.ulocale = locale;
        this.applyPattern(existingPattern);
    }

    public Locale getLocale() {
        return this.ulocale.toLocale();
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public void applyPattern(String pattern) {
        StringBuffer[] segments = new StringBuffer[4];
        int i = 0;
        while (i < segments.length) {
            segments[i] = new StringBuffer();
            ++i;
        }
        int part = 0;
        int formatNumber = 0;
        boolean inQuote = false;
        int braceStack = 0;
        this.maxOffset = -1;
        int i2 = 0;
        while (i2 < pattern.length()) {
            char ch = pattern.charAt(i2);
            if (part == 0) {
                if (ch == '\'') {
                    if (i2 + 1 < pattern.length() && pattern.charAt(i2 + 1) == '\'') {
                        segments[part].append(ch);
                        ++i2;
                    } else {
                        inQuote = !inQuote;
                    }
                } else if (ch == '{' && !inQuote) {
                    part = 1;
                } else {
                    segments[part].append(ch);
                }
            } else if (inQuote) {
                segments[part].append(ch);
                if (ch == '\'') {
                    inQuote = false;
                }
            } else {
                switch (ch) {
                    case ',': {
                        if (part < 3) {
                            ++part;
                            break;
                        }
                        segments[part].append(ch);
                        break;
                    }
                    case '{': {
                        ++braceStack;
                        segments[part].append(ch);
                        break;
                    }
                    case '}': {
                        if (braceStack == 0) {
                            part = 0;
                            this.makeFormat(i2, formatNumber, segments);
                            ++formatNumber;
                            break;
                        }
                        --braceStack;
                        segments[part].append(ch);
                        break;
                    }
                    case '\'': {
                        inQuote = true;
                    }
                    default: {
                        segments[part].append(ch);
                    }
                }
            }
            ++i2;
        }
        if (braceStack == 0 && part != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = segments[0].toString();
    }

    public String toPattern() {
        int lastOffset = 0;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i <= this.maxOffset) {
            MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.offsets[i], result);
            lastOffset = this.offsets[i];
            result.append('{');
            result.append(this.argumentNumbers[i]);
            if (this.formats[i] != null) {
                if (this.formats[i] instanceof DecimalFormat) {
                    if (this.formats[i].equals(NumberFormat.getInstance(this.ulocale))) {
                        result.append(",number");
                    } else if (this.formats[i].equals(NumberFormat.getCurrencyInstance(this.ulocale))) {
                        result.append(",number,currency");
                    } else if (this.formats[i].equals(NumberFormat.getPercentInstance(this.ulocale))) {
                        result.append(",number,percent");
                    } else if (this.formats[i].equals(NumberFormat.getIntegerInstance(this.ulocale))) {
                        result.append(",number,integer");
                    } else {
                        result.append(",number," + ((DecimalFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof SimpleDateFormat) {
                    if (this.formats[i].equals(DateFormat.getDateInstance(2, this.ulocale))) {
                        result.append(",date");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(3, this.ulocale))) {
                        result.append(",date,short");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(1, this.ulocale))) {
                        result.append(",date,long");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(0, this.ulocale))) {
                        result.append(",date,full");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(2, this.ulocale))) {
                        result.append(",time");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(3, this.ulocale))) {
                        result.append(",time,short");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(1, this.ulocale))) {
                        result.append(",time,long");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(0, this.ulocale))) {
                        result.append(",time,full");
                    } else {
                        result.append(",date," + ((SimpleDateFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof ChoiceFormat) {
                    result.append(",choice," + ((ChoiceFormat)this.formats[i]).toPattern());
                }
            }
            result.append('}');
            ++i;
        }
        MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.pattern.length(), result);
        return result.toString();
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        int i = 0;
        while (i <= this.maxOffset) {
            int j = this.argumentNumbers[i];
            if (j < newFormats.length) {
                this.formats[i] = newFormats[j];
            }
            ++i;
        }
    }

    public void setFormats(Format[] newFormats) {
        int runsToCopy = newFormats.length;
        if (runsToCopy > this.maxOffset + 1) {
            runsToCopy = this.maxOffset + 1;
        }
        int i = 0;
        while (i < runsToCopy) {
            this.formats[i] = newFormats[i];
            ++i;
        }
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        int j = 0;
        while (j <= this.maxOffset) {
            if (this.argumentNumbers[j] == argumentIndex) {
                this.formats[j] = newFormat;
            }
            ++j;
        }
    }

    public void setFormat(int formatElementIndex, Format newFormat) {
        this.formats[formatElementIndex] = newFormat;
    }

    public Format[] getFormatsByArgumentIndex() {
        int maximumArgumentNumber = -1;
        int i = 0;
        while (i <= this.maxOffset) {
            if (this.argumentNumbers[i] > maximumArgumentNumber) {
                maximumArgumentNumber = this.argumentNumbers[i];
            }
            ++i;
        }
        Format[] resultArray = new Format[maximumArgumentNumber + 1];
        int i2 = 0;
        while (i2 <= this.maxOffset) {
            resultArray[this.argumentNumbers[i2]] = this.formats[i2];
            ++i2;
        }
        return resultArray;
    }

    public Format[] getFormats() {
        Format[] resultArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, resultArray, 0, this.maxOffset + 1);
        return resultArray;
    }

    public final StringBuffer format(Object[] arguments, StringBuffer result, FieldPosition pos) {
        return this.subformat(arguments, result, pos);
    }

    public static String format(String pattern, Object[] arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    public final StringBuffer format(Object arguments, StringBuffer result, FieldPosition pos) {
        return this.subformat((Object[])arguments, result, pos);
    }

    public Object[] parse(String source, ParsePosition pos) {
        if (source == null) {
            Object[] empty = new Object[]{};
            return empty;
        }
        int maximumArgumentNumber = -1;
        int i = 0;
        while (i <= this.maxOffset) {
            if (this.argumentNumbers[i] > maximumArgumentNumber) {
                maximumArgumentNumber = this.argumentNumbers[i];
            }
            ++i;
        }
        Object[] resultArray = new Object[maximumArgumentNumber + 1];
        int patternOffset = 0;
        int sourceOffset = pos.getIndex();
        ParsePosition tempStatus = new ParsePosition(0);
        int i2 = 0;
        while (i2 <= this.maxOffset) {
            int len = this.offsets[i2] - patternOffset;
            if (len == 0 || this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
                sourceOffset += len;
                patternOffset += len;
            } else {
                pos.setErrorIndex(sourceOffset);
                return null;
            }
            if (this.formats[i2] == null) {
                int tempLength = i2 != this.maxOffset ? this.offsets[i2 + 1] : this.pattern.length();
                int next = patternOffset >= tempLength ? source.length() : source.indexOf(this.pattern.substring(patternOffset, tempLength), sourceOffset);
                if (next < 0) {
                    pos.setErrorIndex(sourceOffset);
                    return null;
                }
                String strValue = source.substring(sourceOffset, next);
                if (!strValue.equals("{" + this.argumentNumbers[i2] + "}")) {
                    resultArray[this.argumentNumbers[i2]] = source.substring(sourceOffset, next);
                }
                sourceOffset = next;
            } else {
                tempStatus.setIndex(sourceOffset);
                resultArray[this.argumentNumbers[i2]] = this.formats[i2].parseObject(source, tempStatus);
                if (tempStatus.getIndex() == sourceOffset) {
                    pos.setErrorIndex(sourceOffset);
                    return null;
                }
                sourceOffset = tempStatus.getIndex();
            }
            ++i2;
        }
        int len = this.pattern.length() - patternOffset;
        if (len != 0 && !this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
            pos.setErrorIndex(sourceOffset);
            return null;
        }
        pos.setIndex(sourceOffset + len);
        return resultArray;
    }

    public Object[] parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object[] result = this.parse(source, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", pos.getErrorIndex());
        }
        return result;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public Object clone() {
        MessageFormat other = (MessageFormat)super.clone();
        other.formats = (Format[])this.formats.clone();
        int i = 0;
        while (i < this.formats.length) {
            if (this.formats[i] != null) {
                other.formats[i] = (Format)this.formats[i].clone();
            }
            ++i;
        }
        other.offsets = (int[])this.offsets.clone();
        other.argumentNumbers = (int[])this.argumentNumbers.clone();
        return other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFormat other = (MessageFormat)obj;
        return this.maxOffset == other.maxOffset && this.pattern.equals(other.pattern) && Utility.objectEquals(this.ulocale, other.ulocale) && Utility.arrayEquals(this.offsets, (Object)other.offsets) && Utility.arrayEquals(this.argumentNumbers, (Object)other.argumentNumbers) && Utility.arrayEquals(this.formats, (Object)other.formats);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer subformat(Object[] arguments, StringBuffer result, FieldPosition fp) {
        int lastOffset = 0;
        int last = result.length();
        int i = 0;
        while (i <= this.maxOffset) {
            result.append(this.pattern.substring(lastOffset, this.offsets[i]));
            lastOffset = this.offsets[i];
            int argumentNumber = this.argumentNumbers[i];
            if (arguments == null || argumentNumber >= arguments.length) {
                result.append("{" + argumentNumber + "}");
            } else {
                Object[] obj = arguments[argumentNumber];
                String arg = null;
                Format subFormatter = null;
                if (obj == null) {
                    arg = "null";
                } else if (this.formats[i] != null) {
                    subFormatter = this.formats[i];
                    if (subFormatter instanceof ChoiceFormat && (arg = this.formats[i].format(obj)).indexOf(123) >= 0) {
                        subFormatter = new MessageFormat(arg, this.ulocale);
                        obj = arguments;
                        arg = null;
                    }
                } else if (obj instanceof Number) {
                    subFormatter = NumberFormat.getInstance(this.ulocale);
                } else if (obj instanceof Date) {
                    subFormatter = DateFormat.getDateTimeInstance(3, 3, this.ulocale);
                } else if (obj instanceof String) {
                    arg = (String)obj;
                } else {
                    arg = obj.toString();
                    if (arg == null) {
                        arg = "null";
                    }
                }
                if (subFormatter != null) {
                    arg = subFormatter.format(obj);
                }
                result.append(arg);
                last = result.length();
            }
            ++i;
        }
        result.append(this.pattern.substring(lastOffset, this.pattern.length()));
        return result;
    }

    private void makeFormat(int position, int offsetNumber, StringBuffer[] segments) {
        int argumentNumber;
        try {
            argumentNumber = Integer.parseInt(segments[1].toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("can't parse argument number " + segments[1]);
        }
        if (argumentNumber < 0) {
            throw new IllegalArgumentException("negative argument number " + argumentNumber);
        }
        if (offsetNumber >= this.formats.length) {
            int newLength = this.formats.length * 2;
            Format[] newFormats = new Format[newLength];
            int[] newOffsets = new int[newLength];
            int[] newArgumentNumbers = new int[newLength];
            System.arraycopy(this.formats, 0, newFormats, 0, this.maxOffset + 1);
            System.arraycopy(this.offsets, 0, newOffsets, 0, this.maxOffset + 1);
            System.arraycopy(this.argumentNumbers, 0, newArgumentNumbers, 0, this.maxOffset + 1);
            this.formats = newFormats;
            this.offsets = newOffsets;
            this.argumentNumbers = newArgumentNumbers;
        }
        int oldMaxOffset = this.maxOffset;
        this.maxOffset = offsetNumber;
        this.offsets[offsetNumber] = segments[0].length();
        this.argumentNumbers[offsetNumber] = argumentNumber;
        Format newFormat = null;
        block5 : switch (MessageFormat.findKeyword(segments[2].toString(), typeList)) {
            case 0: {
                break;
            }
            case 1: {
                switch (MessageFormat.findKeyword(segments[3].toString(), modifierList)) {
                    case 0: {
                        newFormat = NumberFormat.getInstance(this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = NumberFormat.getCurrencyInstance(this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = NumberFormat.getPercentInstance(this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = NumberFormat.getIntegerInstance(this.ulocale);
                        break block5;
                    }
                }
                newFormat = new DecimalFormat(segments[3].toString(), new DecimalFormatSymbols(this.ulocale));
                break;
            }
            case 2: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = DateFormat.getDateInstance(3, this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = DateFormat.getDateInstance(1, this.ulocale);
                        break block5;
                    }
                    case 4: {
                        newFormat = DateFormat.getDateInstance(0, this.ulocale);
                        break block5;
                    }
                }
                newFormat = new SimpleDateFormat(segments[3].toString(), this.ulocale);
                break;
            }
            case 3: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block5;
                    }
                    case 1: {
                        newFormat = DateFormat.getTimeInstance(3, this.ulocale);
                        break block5;
                    }
                    case 2: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block5;
                    }
                    case 3: {
                        newFormat = DateFormat.getTimeInstance(1, this.ulocale);
                        break block5;
                    }
                    case 4: {
                        newFormat = DateFormat.getTimeInstance(0, this.ulocale);
                        break block5;
                    }
                }
                newFormat = new SimpleDateFormat(segments[3].toString(), this.ulocale);
                break;
            }
            case 4: {
                try {
                    newFormat = new ChoiceFormat(segments[3].toString());
                    break;
                }
                catch (Exception e) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Choice Pattern incorrect");
                }
            }
            case 5: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 1);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 6: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 2);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 7: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 3);
                String ruleset = segments[3].toString().trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            default: {
                this.maxOffset = oldMaxOffset;
                throw new IllegalArgumentException("unknown format type at ");
            }
        }
        this.formats[offsetNumber] = newFormat;
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    private static final int findKeyword(String s, String[] list) {
        s = s.trim().toLowerCase();
        int i = 0;
        while (i < list.length) {
            if (s.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String source, int start, int end, StringBuffer target) {
        boolean gotLB = false;
        int i = start;
        while (i < end) {
            char ch = source.charAt(i);
            if (ch == '{') {
                target.append("'{'");
                gotLB = true;
            } else if (ch == '}') {
                if (gotLB) {
                    target.append(ch);
                    gotLB = false;
                } else {
                    target.append("'}'");
                }
            } else if (ch == '\'') {
                target.append("''");
            } else {
                target.append(ch);
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isValid;
        in.defaultReadObject();
        boolean bl = isValid = this.maxOffset >= -1 && this.formats.length > this.maxOffset && this.offsets.length > this.maxOffset && this.argumentNumbers.length > this.maxOffset;
        if (isValid) {
            int lastOffset = this.pattern.length() + 1;
            int i = this.maxOffset;
            while (i >= 0) {
                if (this.offsets[i] < 0 || this.offsets[i] > lastOffset) {
                    isValid = false;
                    break;
                }
                lastOffset = this.offsets[i];
                --i;
            }
        }
        if (!isValid) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream.");
        }
        if (this.ulocale == null) {
            this.ulocale = ULocale.forLocale(this.locale);
        }
    }

    public static String autoQuoteApostrophe(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() * 2);
        int state = 0;
        int braceCount = 0;
        int i = 0;
        int j = pattern.length();
        while (i < j) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                            ++braceCount;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '{': {
                            ++braceCount;
                            break;
                        }
                        case '}': {
                            if (--braceCount != 0) break;
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
            ++i;
        }
        if (state == 1 || state == 2) {
            buf.append('\'');
        }
        return new String(buf);
    }
}

