/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.impl.sax;

import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.NoImplementationException;
import com.skaringa.javaxml.ObjectTransformer;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.handler.DocumentInputHandler;
import com.skaringa.javaxml.handler.sax.AbstractXMLReader;
import com.skaringa.javaxml.handler.sax.ObjectInputSource;
import com.skaringa.javaxml.handler.sax.ObjectXMLReader;
import com.skaringa.javaxml.handler.sax.ObjectXSDReader;
import com.skaringa.javaxml.handler.sax.SAXInputHandler;
import com.skaringa.javaxml.impl.PropertyHelper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ObjectTransformerSAXImpl
implements ObjectTransformer {
    private static Category _category = Category.getInstance(class$com$skaringa$javaxml$impl$sax$ObjectTransformerSAXImpl == null ? (class$com$skaringa$javaxml$impl$sax$ObjectTransformerSAXImpl = ObjectTransformerSAXImpl.class$("com.skaringa.javaxml.impl.sax.ObjectTransformerSAXImpl")) : class$com$skaringa$javaxml$impl$sax$ObjectTransformerSAXImpl);
    private SAXTransformerFactory _saxTransFact;
    private Templates _preProcessorTemplate;
    private Templates _postProcessorTemplate;
    private Map _properties = new HashMap();
    static /* synthetic */ Class class$com$skaringa$javaxml$impl$sax$ObjectTransformerSAXImpl;

    public ObjectTransformerSAXImpl() throws NoImplementationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            _category.error("SAXTransformerFactory is not supported.");
            throw new NoImplementationException("SAXTransformerFactory is not supported.");
        }
        this._saxTransFact = (SAXTransformerFactory)transformerFactory;
    }

    public void serialize(Object object, Result result) throws SerializerException {
        _category.info("start " + object.getClass().getName());
        this.transform(this.getTransformerHandler(this._postProcessorTemplate), object, new ObjectXMLReader(), result);
        _category.info("end " + object.getClass().getName());
    }

    public String serializeToString(Object object) throws SerializerException {
        StringWriter stringWriter = new StringWriter();
        this.serialize(object, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public Object deserialize(Source source) throws DeserializerException {
        Object object;
        _category.info("start ...");
        try {
            Transformer transformer = this._preProcessorTemplate != null ? this._preProcessorTemplate.newTransformer() : this._saxTransFact.newTransformer();
            DocumentInputHandler documentInputHandler = new DocumentInputHandler();
            documentInputHandler.setProperties(this._properties);
            transformer.transform(source, this.newObjectResult(documentInputHandler));
            object = documentInputHandler.getObject();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new DeserializerException(transformerConfigurationException.toString());
        }
        catch (TransformerException transformerException) {
            _category.error(transformerException);
            Throwable throwable = transformerException.getException();
            if (throwable instanceof DeserializerException) {
                throw (DeserializerException)throwable;
            }
            throw new DeserializerException(transformerException.getMessage());
        }
        _category.info("end " + object.getClass().getName());
        return object;
    }

    public Object deserializeFromString(String string) throws DeserializerException {
        StringReader stringReader = new StringReader(string);
        Object object = this.deserialize(new StreamSource(stringReader));
        return object;
    }

    public void writeXMLSchema(Class clazz, Result result) throws SerializerException {
        _category.info("start " + clazz.getName());
        this.transform(this.getCopyTransformerHandler(), clazz, new ObjectXSDReader(), result);
        _category.info("end " + clazz.getName());
    }

    public void writeXMLSchema(Class clazz, Collection collection, Result result) throws SerializerException {
        _category.info("start " + clazz.getName());
        ObjectXSDReader objectXSDReader = new ObjectXSDReader();
        objectXSDReader.addUsedClasses(collection);
        this.transform(this.getCopyTransformerHandler(), clazz, objectXSDReader, result);
        _category.info("end " + clazz.getName());
    }

    public Object transform(Object object, Source source) throws SerializerException, DeserializerException {
        _category.info("start " + object.getClass().getName());
        DocumentInputHandler documentInputHandler = new DocumentInputHandler();
        documentInputHandler.setProperties(this._properties);
        this.transform(this.getTransformerHandler(source), object, new ObjectXMLReader(), this.newObjectResult(documentInputHandler));
        _category.info("end " + object.getClass().getName());
        return documentInputHandler.getObject();
    }

    public Object transform(Object object) throws SerializerException, DeserializerException {
        _category.info("start " + object.getClass().getName());
        DocumentInputHandler documentInputHandler = new DocumentInputHandler();
        documentInputHandler.setProperties(this._properties);
        this.transform(this.getTransformerHandler(this._postProcessorTemplate), object, new ObjectXMLReader(), this.newObjectResult(documentInputHandler));
        _category.info("end " + object.getClass().getName());
        return documentInputHandler.getObject();
    }

    public void transform(Object object, Source source, Result result) throws SerializerException {
        this.transform(this.getTransformerHandler(source), object, new ObjectXMLReader(), result);
    }

    public void setProperty(String string, Object object) throws NoImplementationException {
        if (!PropertyHelper.isValidName(string)) {
            throw new NoImplementationException("invalid property name: " + string);
        }
        this._properties.put(string, object);
    }

    private TransformerHandler getTransformerHandler(Source source) throws SerializerException {
        try {
            TransformerHandler transformerHandler = source != null ? this._saxTransFact.newTransformerHandler(source) : this._saxTransFact.newTransformerHandler();
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new SerializerException(transformerConfigurationException.getMessage());
        }
    }

    private TransformerHandler getTransformerHandler(Templates templates) throws SerializerException {
        try {
            TransformerHandler transformerHandler = templates != null ? this._saxTransFact.newTransformerHandler(templates) : this._saxTransFact.newTransformerHandler();
            return transformerHandler;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new SerializerException(transformerConfigurationException.getMessage());
        }
    }

    private TransformerHandler getCopyTransformerHandler() throws SerializerException {
        try {
            return this._saxTransFact.newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new SerializerException(transformerConfigurationException.getMessage());
        }
    }

    private void transform(TransformerHandler transformerHandler, Object object, AbstractXMLReader abstractXMLReader, Result result) throws SerializerException {
        try {
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformerHandler.setResult(result);
            this.setProperties(transformer, abstractXMLReader);
            abstractXMLReader.setContentHandler(transformerHandler);
            abstractXMLReader.parse(new ObjectInputSource(object));
        }
        catch (IOException iOException) {
            _category.error(iOException);
            throw new SerializerException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            _category.error(sAXException);
            Exception exception = sAXException.getException();
            if (exception instanceof SerializerException) {
                throw (SerializerException)exception;
            }
            throw new SerializerException(sAXException.getMessage());
        }
    }

    private void setProperties(Transformer transformer, AbstractXMLReader abstractXMLReader) throws IllegalArgumentException, SAXNotRecognizedException, SAXNotSupportedException {
        Iterator iterator = this._properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (PropertyHelper.isValidNameForXSLTransformer(string)) {
                transformer.setOutputProperty(string, (String)v);
                continue;
            }
            abstractXMLReader.setProperty(string, v);
        }
    }

    private Result newObjectResult(DocumentInputHandler documentInputHandler) {
        SAXInputHandler sAXInputHandler = new SAXInputHandler(documentInputHandler);
        return new SAXResult(sAXInputHandler);
    }

    public void setPreprocessorInstruction(Source source) throws NoImplementationException {
        try {
            this._preProcessorTemplate = this._saxTransFact.newTemplates(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new NoImplementationException(transformerConfigurationException.getMessage());
        }
    }

    public void setPostprocessorInstruction(Source source) throws NoImplementationException {
        try {
            this._postProcessorTemplate = this._saxTransFact.newTemplates(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            _category.error(transformerConfigurationException);
            throw new NoImplementationException(transformerConfigurationException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

