/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.javaxml.serializers;

import com.skaringa.javaxml.DeserializerException;
import com.skaringa.javaxml.SerializerException;
import com.skaringa.javaxml.serializers.ArrayHelper;
import com.skaringa.javaxml.serializers.ArraySerializer;
import com.skaringa.javaxml.serializers.CollectionSerializer;
import com.skaringa.javaxml.serializers.ComponentSerializer;
import com.skaringa.javaxml.serializers.DateSerializer;
import com.skaringa.javaxml.serializers.LocaleSerializer;
import com.skaringa.javaxml.serializers.MapEntrySerializer;
import com.skaringa.javaxml.serializers.MapSerializer;
import com.skaringa.javaxml.serializers.ObjectSerializer;
import com.skaringa.javaxml.serializers.PrimitiveTypeSerializer;
import com.skaringa.javaxml.serializers.SetSerializer;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class SerializerRegistry {
    private static SerializerRegistry _theRegistry = null;
    private Map _serializers = new HashMap();
    private Map _deserializers = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$AbstractSet;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$AbstractCollection;
    static /* synthetic */ Class class$java$util$AbstractList;
    static /* synthetic */ Class class$java$util$AbstractSequentialList;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$AbstractMap;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$WeakHashMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$Map$Entry;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Locale;

    public static synchronized SerializerRegistry getInstance() {
        if (_theRegistry == null) {
            _theRegistry = new SerializerRegistry();
        }
        return _theRegistry;
    }

    private SerializerRegistry() {
        this.addSerializer(Integer.TYPE.getName(), new PrimitiveTypeSerializer("xsd:int", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this.addSerializer(Long.TYPE.getName(), new PrimitiveTypeSerializer("xsd:long", class$java$lang$Long == null ? (class$java$lang$Long = SerializerRegistry.class$("java.lang.Long")) : class$java$lang$Long));
        this.addSerializer(Short.TYPE.getName(), new PrimitiveTypeSerializer("xsd:short", class$java$lang$Short == null ? (class$java$lang$Short = SerializerRegistry.class$("java.lang.Short")) : class$java$lang$Short));
        this.addSerializer(Byte.TYPE.getName(), new PrimitiveTypeSerializer("xsd:byte", class$java$lang$Byte == null ? (class$java$lang$Byte = SerializerRegistry.class$("java.lang.Byte")) : class$java$lang$Byte));
        this.addSerializer(Float.TYPE.getName(), new PrimitiveTypeSerializer("xsd:float", class$java$lang$Float == null ? (class$java$lang$Float = SerializerRegistry.class$("java.lang.Float")) : class$java$lang$Float));
        this.addSerializer(Double.TYPE.getName(), new PrimitiveTypeSerializer("xsd:double", class$java$lang$Double == null ? (class$java$lang$Double = SerializerRegistry.class$("java.lang.Double")) : class$java$lang$Double));
        this.addSerializer(Character.TYPE.getName(), new PrimitiveTypeSerializer("char", class$java$lang$Character == null ? (class$java$lang$Character = SerializerRegistry.class$("java.lang.Character")) : class$java$lang$Character));
        this.addSerializer(Boolean.TYPE.getName(), new PrimitiveTypeSerializer("xsd:boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        this.addSerializer((class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), new PrimitiveTypeSerializer("xsd:int", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this.addSerializer((class$java$lang$Long == null ? (class$java$lang$Long = SerializerRegistry.class$("java.lang.Long")) : class$java$lang$Long).getName(), new PrimitiveTypeSerializer("xsd:long", class$java$lang$Long == null ? (class$java$lang$Long = SerializerRegistry.class$("java.lang.Long")) : class$java$lang$Long));
        this.addSerializer((class$java$lang$Short == null ? (class$java$lang$Short = SerializerRegistry.class$("java.lang.Short")) : class$java$lang$Short).getName(), new PrimitiveTypeSerializer("xsd:short", class$java$lang$Short == null ? (class$java$lang$Short = SerializerRegistry.class$("java.lang.Short")) : class$java$lang$Short));
        this.addSerializer((class$java$lang$Byte == null ? (class$java$lang$Byte = SerializerRegistry.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), new PrimitiveTypeSerializer("xsd:byte", class$java$lang$Byte == null ? (class$java$lang$Byte = SerializerRegistry.class$("java.lang.Byte")) : class$java$lang$Byte));
        this.addSerializer((class$java$lang$Float == null ? (class$java$lang$Float = SerializerRegistry.class$("java.lang.Float")) : class$java$lang$Float).getName(), new PrimitiveTypeSerializer("xsd:float", class$java$lang$Float == null ? (class$java$lang$Float = SerializerRegistry.class$("java.lang.Float")) : class$java$lang$Float));
        this.addSerializer((class$java$lang$Double == null ? (class$java$lang$Double = SerializerRegistry.class$("java.lang.Double")) : class$java$lang$Double).getName(), new PrimitiveTypeSerializer("xsd:double", class$java$lang$Double == null ? (class$java$lang$Double = SerializerRegistry.class$("java.lang.Double")) : class$java$lang$Double));
        this.addSerializer((class$java$lang$Character == null ? (class$java$lang$Character = SerializerRegistry.class$("java.lang.Character")) : class$java$lang$Character).getName(), new PrimitiveTypeSerializer("char", class$java$lang$Character == null ? (class$java$lang$Character = SerializerRegistry.class$("java.lang.Character")) : class$java$lang$Character));
        this.addSerializer((class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), new PrimitiveTypeSerializer("xsd:boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        this.addSerializer((class$java$lang$String == null ? (class$java$lang$String = SerializerRegistry.class$("java.lang.String")) : class$java$lang$String).getName(), new PrimitiveTypeSerializer("xsd:string", class$java$lang$String == null ? (class$java$lang$String = SerializerRegistry.class$("java.lang.String")) : class$java$lang$String));
        this.addSerializer((class$java$util$Date == null ? (class$java$util$Date = SerializerRegistry.class$("java.util.Date")) : class$java$util$Date).getName(), new DateSerializer());
        SetSerializer setSerializer = new SetSerializer();
        this.addSerializer((class$java$util$Set == null ? (class$java$util$Set = SerializerRegistry.class$("java.util.Set")) : class$java$util$Set).getName(), setSerializer);
        this.addSerializer((class$java$util$SortedSet == null ? (class$java$util$SortedSet = SerializerRegistry.class$("java.util.SortedSet")) : class$java$util$SortedSet).getName(), setSerializer);
        this.addSerializer((class$java$util$AbstractSet == null ? (class$java$util$AbstractSet = SerializerRegistry.class$("java.util.AbstractSet")) : class$java$util$AbstractSet).getName(), setSerializer);
        this.addSerializer((class$java$util$BitSet == null ? (class$java$util$BitSet = SerializerRegistry.class$("java.util.BitSet")) : class$java$util$BitSet).getName(), setSerializer);
        this.addSerializer((class$java$util$HashSet == null ? (class$java$util$HashSet = SerializerRegistry.class$("java.util.HashSet")) : class$java$util$HashSet).getName(), setSerializer);
        this.addSerializer((class$java$util$TreeSet == null ? (class$java$util$TreeSet = SerializerRegistry.class$("java.util.TreeSet")) : class$java$util$TreeSet).getName(), setSerializer);
        CollectionSerializer collectionSerializer = new CollectionSerializer();
        this.addSerializer((class$java$util$Collection == null ? (class$java$util$Collection = SerializerRegistry.class$("java.util.Collection")) : class$java$util$Collection).getName(), collectionSerializer);
        this.addSerializer((class$java$util$List == null ? (class$java$util$List = SerializerRegistry.class$("java.util.List")) : class$java$util$List).getName(), collectionSerializer);
        this.addSerializer((class$java$util$AbstractCollection == null ? (class$java$util$AbstractCollection = SerializerRegistry.class$("java.util.AbstractCollection")) : class$java$util$AbstractCollection).getName(), collectionSerializer);
        this.addSerializer((class$java$util$AbstractList == null ? (class$java$util$AbstractList = SerializerRegistry.class$("java.util.AbstractList")) : class$java$util$AbstractList).getName(), collectionSerializer);
        this.addSerializer((class$java$util$AbstractSequentialList == null ? (class$java$util$AbstractSequentialList = SerializerRegistry.class$("java.util.AbstractSequentialList")) : class$java$util$AbstractSequentialList).getName(), collectionSerializer);
        this.addSerializer((class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializerRegistry.class$("java.util.ArrayList")) : class$java$util$ArrayList).getName(), collectionSerializer);
        this.addSerializer((class$java$util$LinkedList == null ? (class$java$util$LinkedList = SerializerRegistry.class$("java.util.LinkedList")) : class$java$util$LinkedList).getName(), collectionSerializer);
        this.addSerializer((class$java$util$Stack == null ? (class$java$util$Stack = SerializerRegistry.class$("java.util.Stack")) : class$java$util$Stack).getName(), collectionSerializer);
        this.addSerializer((class$java$util$Vector == null ? (class$java$util$Vector = SerializerRegistry.class$("java.util.Vector")) : class$java$util$Vector).getName(), collectionSerializer);
        MapSerializer mapSerializer = new MapSerializer();
        this.addSerializer((class$java$util$Map == null ? (class$java$util$Map = SerializerRegistry.class$("java.util.Map")) : class$java$util$Map).getName(), mapSerializer);
        this.addSerializer((class$java$util$SortedMap == null ? (class$java$util$SortedMap = SerializerRegistry.class$("java.util.SortedMap")) : class$java$util$SortedMap).getName(), mapSerializer);
        this.addSerializer((class$java$util$AbstractMap == null ? (class$java$util$AbstractMap = SerializerRegistry.class$("java.util.AbstractMap")) : class$java$util$AbstractMap).getName(), mapSerializer);
        this.addSerializer((class$java$util$HashMap == null ? (class$java$util$HashMap = SerializerRegistry.class$("java.util.HashMap")) : class$java$util$HashMap).getName(), mapSerializer);
        this.addSerializer((class$java$util$Hashtable == null ? (class$java$util$Hashtable = SerializerRegistry.class$("java.util.Hashtable")) : class$java$util$Hashtable).getName(), mapSerializer);
        this.addSerializer((class$java$util$WeakHashMap == null ? (class$java$util$WeakHashMap = SerializerRegistry.class$("java.util.WeakHashMap")) : class$java$util$WeakHashMap).getName(), mapSerializer);
        this.addSerializer((class$java$util$TreeMap == null ? (class$java$util$TreeMap = SerializerRegistry.class$("java.util.TreeMap")) : class$java$util$TreeMap).getName(), mapSerializer);
        this.addSerializer((class$java$util$Properties == null ? (class$java$util$Properties = SerializerRegistry.class$("java.util.Properties")) : class$java$util$Properties).getName(), mapSerializer);
        this.addSerializer((class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = SerializerRegistry.class$("java.util.Map$Entry")) : class$java$util$Map$Entry).getName(), new MapEntrySerializer());
        this.addSerializer("array", new ArraySerializer());
        this.addSerializer((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SerializerRegistry.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), new PrimitiveTypeSerializer("xsd:decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SerializerRegistry.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
        this.addSerializer((class$java$math$BigInteger == null ? (class$java$math$BigInteger = SerializerRegistry.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName(), new PrimitiveTypeSerializer("xsd:integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = SerializerRegistry.class$("java.math.BigInteger")) : class$java$math$BigInteger));
        this.addSerializer((class$java$util$Locale == null ? (class$java$util$Locale = SerializerRegistry.class$("java.util.Locale")) : class$java$util$Locale).getName(), new LocaleSerializer((class$java$util$Locale == null ? (class$java$util$Locale = SerializerRegistry.class$("java.util.Locale")) : class$java$util$Locale).getName()));
        this._deserializers.put("xsd:nonPositiveInteger", new PrimitiveTypeSerializer("xsd:nonPositiveInteger", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this._deserializers.put("xsd:nonNegativeInteger", new PrimitiveTypeSerializer("xsd:nonNegativeInteger", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this._deserializers.put("xsd:positiveInteger", new PrimitiveTypeSerializer("xsd:positiveInteger", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this._deserializers.put("xsd:negativeInteger", new PrimitiveTypeSerializer("xsd:negativeInteger", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this._deserializers.put("xsd:unsignedLong", new PrimitiveTypeSerializer("xsd:unsignedLong", class$java$lang$Long == null ? (class$java$lang$Long = SerializerRegistry.class$("java.lang.Long")) : class$java$lang$Long));
        this._deserializers.put("xsd:unsignedInt", new PrimitiveTypeSerializer("xsd:unsignedInt", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerRegistry.class$("java.lang.Integer")) : class$java$lang$Integer));
        this._deserializers.put("xsd:unsignedShort", new PrimitiveTypeSerializer("xsd:unsignedShort", class$java$lang$Short == null ? (class$java$lang$Short = SerializerRegistry.class$("java.lang.Short")) : class$java$lang$Short));
        this._deserializers.put("xsd:unsignedByte", new PrimitiveTypeSerializer("xsd:unsignedByte", class$java$lang$Byte == null ? (class$java$lang$Byte = SerializerRegistry.class$("java.lang.Byte")) : class$java$lang$Byte));
        this._deserializers.put("xsd:date", new DateSerializer("xsd:date"));
    }

    public void addSerializer(String string, ComponentSerializer componentSerializer) {
        this._serializers.put(string, componentSerializer);
        this._deserializers.put(componentSerializer.getXMLTypeName(), componentSerializer);
    }

    public ComponentSerializer getSerializer(Class clazz) throws SerializerException {
        String string = clazz.getName();
        if (clazz.isArray()) {
            string = "array";
        }
        return this.getSerializer(string);
    }

    public ComponentSerializer getSerializer(String string) throws SerializerException {
        ComponentSerializer componentSerializer = (ComponentSerializer)this._serializers.get(string);
        if (componentSerializer == null) {
            componentSerializer = new ObjectSerializer(string);
            this.addSerializer(string, componentSerializer);
        }
        return componentSerializer;
    }

    public ComponentSerializer getDeserializer(String string, Attributes attributes) throws DeserializerException {
        String string2 = attributes.getValue("xsi:type");
        if (string2 == null) {
            throw new DeserializerException("Element " + string + " missing xsi:type attribute");
        }
        ComponentSerializer componentSerializer = (ComponentSerializer)this._deserializers.get(string2);
        if (componentSerializer == null) {
            componentSerializer = new ObjectSerializer(string2);
            this.addSerializer(string2, componentSerializer);
        }
        return componentSerializer;
    }

    public ComponentSerializer findDeserializer(Object object, String string) throws DeserializerException {
        Class clazz = null;
        if (object != null) {
            clazz = object instanceof ArrayHelper ? ((ArrayHelper)object).getComponentType() : ObjectSerializer.getFieldType(object, string);
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new DeserializerException("can't determine java type for element: " + string);
        }
        try {
            return this.getSerializer(clazz);
        }
        catch (SerializerException serializerException) {
            throw new DeserializerException(serializerException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

