/*
 * Decompiled with CFR 0.152.
 */
package com.skaringa.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601DateTimeFormat
extends DateFormat {
    public ISO8601DateTimeFormat() {
        this.setCalendar(Calendar.getInstance());
    }

    public ISO8601DateTimeFormat(TimeZone timeZone) {
        this.setCalendar(Calendar.getInstance(timeZone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        try {
            int n2 = Integer.valueOf(string.substring(n, n + 4));
            if (string.charAt(n += 4) != '-') {
                throw new NumberFormatException();
            }
            int n3 = Integer.valueOf(string.substring(++n, n + 2)) - 1;
            if (string.charAt(n += 2) != '-') {
                throw new NumberFormatException();
            }
            int n4 = Integer.valueOf(string.substring(++n, n + 2));
            if (string.charAt(n += 2) != 'T') {
                throw new NumberFormatException();
            }
            int n5 = Integer.valueOf(string.substring(++n, n + 2));
            if (string.charAt(n += 2) != ':') {
                throw new NumberFormatException();
            }
            int n6 = Integer.valueOf(string.substring(++n, n + 2));
            int n7 = 0;
            if ((n += 2) < string.length() && string.charAt(n) == ':') {
                n7 = Integer.valueOf(string.substring(++n, n + 2));
                n += 2;
            }
            this.calendar.set(n2, n3, n4, n5, n6, n7);
            this.calendar.set(14, 0);
            n = this.parseTZ(n, string);
        }
        catch (NumberFormatException numberFormatException) {
            parsePosition.setErrorIndex(n);
            Date date = null;
            Object var11_15 = null;
            parsePosition.setIndex(n);
            return date;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                parsePosition.setErrorIndex(n);
                Date date = null;
                Object var11_16 = null;
                parsePosition.setIndex(n);
                return date;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                parsePosition.setIndex(n);
                throw throwable;
            }
        }
        Object var11_14 = null;
        parsePosition.setIndex(n);
        return this.calendar.getTime();
    }

    protected int parseTZ(int n, String string) throws NumberFormatException {
        if (n < string.length()) {
            int n2;
            int n3 = 0;
            if (string.charAt(n) == 'Z') {
                n3 = 0;
                ++n;
            } else {
                n2 = 1;
                if (string.charAt(n) == '-') {
                    n2 = -1;
                } else if (string.charAt(n) != '+') {
                    throw new NumberFormatException();
                }
                int n4 = Integer.valueOf(string.substring(++n, n + 2));
                if (string.charAt(n += 2) != ':') {
                    throw new NumberFormatException();
                }
                int n5 = Integer.valueOf(string.substring(++n, n + 2));
                n += 2;
                n3 = (n4 * 60 + n5) * 60000 * n2;
            }
            n2 = this.calendar.get(15) + this.calendar.get(16);
            this.calendar.add(14, n2 - n3);
        }
        return n;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        this.writeCCYYMM(stringBuffer);
        stringBuffer.append('T');
        this.writehhmmss(stringBuffer);
        this.writeTZ(stringBuffer);
        return stringBuffer;
    }

    protected void writeTZ(StringBuffer stringBuffer) {
        int n = this.calendar.get(15) + this.calendar.get(16);
        if (n == 0) {
            stringBuffer.append('Z');
        } else {
            int n2 = n / 3600000;
            int n3 = n % 3600000 / 60000;
            if (n >= 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n2 = 0 - n2;
                n3 = 0 - n3;
            }
            this.appendInt(stringBuffer, n2, 2);
            stringBuffer.append(':');
            this.appendInt(stringBuffer, n3, 2);
        }
    }

    protected void writehhmmss(StringBuffer stringBuffer) {
        int n = this.calendar.get(11);
        this.appendInt(stringBuffer, n, 2);
        stringBuffer.append(':');
        int n2 = this.calendar.get(12);
        this.appendInt(stringBuffer, n2, 2);
        stringBuffer.append(':');
        int n3 = this.calendar.get(13);
        this.appendInt(stringBuffer, n3, 2);
    }

    protected void writeCCYYMM(StringBuffer stringBuffer) {
        String string;
        int n = this.calendar.get(1);
        this.appendInt(stringBuffer, n, 4);
        switch (this.calendar.get(2)) {
            case 0: {
                string = "-01-";
                break;
            }
            case 1: {
                string = "-02-";
                break;
            }
            case 2: {
                string = "-03-";
                break;
            }
            case 3: {
                string = "-04-";
                break;
            }
            case 4: {
                string = "-05-";
                break;
            }
            case 5: {
                string = "-06-";
                break;
            }
            case 6: {
                string = "-07-";
                break;
            }
            case 7: {
                string = "-08-";
                break;
            }
            case 8: {
                string = "-09-";
                break;
            }
            case 9: {
                string = "-10-";
                break;
            }
            case 10: {
                string = "-11-";
                break;
            }
            case 11: {
                string = "-12-";
                break;
            }
            default: {
                string = "-NA-";
            }
        }
        stringBuffer.append(string);
        int n2 = this.calendar.get(5);
        this.appendInt(stringBuffer, n2, 2);
    }

    protected void appendInt(StringBuffer stringBuffer, int n, int n2) {
        int n3;
        int n4 = stringBuffer.length();
        stringBuffer.append(n);
        int n5 = n3 = stringBuffer.length();
        while (n5 < n4 + n2) {
            stringBuffer.insert(n4, '0');
            ++n5;
        }
    }
}

