/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.ComparableVector;
import flybase.FastVector;
import java.util.Vector;

public abstract class SortVector {
    protected Vector v;
    protected FastVector fv;
    protected ComparableVector cv;

    public SortVector(Vector vector, ComparableVector comparableVector) {
        this.v = vector;
        this.cv = comparableVector;
    }

    public SortVector(FastVector fastVector, ComparableVector comparableVector) {
        this.fv = fastVector;
        this.cv = comparableVector;
    }

    public abstract void sort();

    public void setVector(Vector vector, ComparableVector comparableVector) {
        this.v = vector;
        this.cv = comparableVector;
    }

    public void setVector(FastVector fastVector, ComparableVector comparableVector) {
        this.fv = fastVector;
        this.cv = comparableVector;
    }

    protected final int size() {
        return this.fv != null ? this.fv.size() : this.v.size();
    }

    protected final int compare(int n, int n2) {
        if (n < 0 || n >= this.size()) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.size()) {
            return 1;
        }
        return this.cv.compareAt(n, n2);
    }

    protected void swap(int n, int n2) {
        if (n < 0 || n >= this.size() || n2 < 0 || n2 >= this.size()) {
            return;
        }
        if (this.fv != null) {
            Object object = this.fv.elementAt(n);
            Object object2 = this.fv.elementAt(n2);
            this.fv.setElementAt(object2, n);
            this.fv.setElementAt(object, n2);
        } else {
            Object e = this.v.elementAt(n);
            Object e2 = this.v.elementAt(n2);
            this.v.setElementAt(e2, n);
            this.v.setElementAt(e, n2);
        }
    }
}

