/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import iubio.bioseq.BaseKind;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqRange;
import iubio.bioseq.SeqRangeException;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.FeatureItem;
import iubio.readseq.SeqFileInfo;
import java.util.Hashtable;
import java.util.Vector;

public class BioseqRecord
extends SeqFileInfo {
    public BioseqRecord() {
    }

    public BioseqRecord(Bioseq bioseq, BioseqDocImpl bioseqDocImpl) {
        this.set(bioseq, bioseqDocImpl, null);
    }

    public BioseqRecord(Bioseq bioseq, BioseqDocImpl bioseqDocImpl, String string) {
        this.set(bioseq, bioseqDocImpl, string);
    }

    public BioseqRecord(SeqFileInfo seqFileInfo) {
        this.seqlen = seqFileInfo.seqlen;
        this.offset = seqFileInfo.offset;
        this.set(seqFileInfo.seq, seqFileInfo.seqdoc, seqFileInfo.seqid);
    }

    public void set(Object object, Object object2, String string) {
        Object object3;
        this.seqid = string;
        this.seqdoc = object2 instanceof BioseqDocImpl ? (BioseqDocImpl)object2 : null;
        if (object == null) {
            this.seq = null;
        } else if (object instanceof Bioseq) {
            this.seq = (Bioseq)object;
        } else if (object instanceof byte[]) {
            object3 = new Bioseq();
            ((Bioseq)object3).setbases((byte[])object);
            this.seq = object3;
        } else {
            this.seq = new Bioseq(object);
        }
        int n = this.seqlen = this.seq != null ? this.getseq().length() : 0;
        if (this.hasdoc() && (this.seqid == null || this.seqid.startsWith(gBlankSeqid)) && (object3 = this.getdoc().getID()) != null) {
            this.seqid = object3;
        }
        if (this.seqid == null || this.seqid.equals(gBlankSeqid)) {
            this.seqid = BioseqRecord.getNextBlankID();
        }
    }

    public final Bioseq getseq() {
        return (Bioseq)this.seq;
    }

    public final BioseqDocImpl getdoc() {
        return (BioseqDocImpl)this.seqdoc;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": id=");
        stringBuffer.append(this.seqid);
        stringBuffer.append(", length=");
        stringBuffer.append(this.seqlen);
        if (this.hasdoc()) {
            stringBuffer.append(", title=\"");
            stringBuffer.append(this.getdoc().getTitle());
            stringBuffer.append('\"');
            if (this.getdoc().hasDocument()) {
                stringBuffer.append(", n.docitems=");
                stringBuffer.append(this.getdoc().documents().size());
            }
            if (this.getdoc().hasFeatures()) {
                stringBuffer.append(", n.features=");
                stringBuffer.append(this.getdoc().features().size());
            }
        }
        return stringBuffer.toString();
    }

    public SeqFileInfo getSeqFileInfo() {
        SeqFileInfo seqFileInfo = new SeqFileInfo();
        this.copyTo(seqFileInfo);
        return seqFileInfo;
    }

    public void copyTo(SeqFileInfo seqFileInfo) {
        seqFileInfo.seqlen = this.seqlen;
        seqFileInfo.offset = this.offset;
        seqFileInfo.seq = this.seq;
        seqFileInfo.seqdoc = this.seqdoc;
        seqFileInfo.seqid = this.seqid;
    }

    public Object clone() {
        BioseqRecord bioseqRecord = (BioseqRecord)super.clone();
        return bioseqRecord;
    }

    public final FeatureItem[] findFeatures(String string) {
        return this.findFeatures(new String[]{string});
    }

    public final FeatureItem[] findFeatures(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], "true");
        }
        return this.findFeatures(hashtable, null);
    }

    public final FeatureItem[] findFeatures(Hashtable hashtable) {
        return this.findFeatures(hashtable, null);
    }

    public final FeatureItem[] findFeatures(SeqRange seqRange) {
        return this.hasdoc() ? this.getdoc().findFeatures(seqRange) : null;
    }

    public FeatureItem[] findFeatures(Hashtable hashtable, SeqRange seqRange) {
        if ((hashtable != null || seqRange != null) && this.hasdoc()) {
            if (hashtable == null) {
                return this.getdoc().findFeatures(seqRange);
            }
            Vector vector = new Vector();
            vector = this.getdoc().findFeatures(hashtable, seqRange, vector);
            if (vector.isEmpty()) {
                return null;
            }
            Object[] objectArray = new FeatureItem[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public final Bioseq extractFeatureBases(FeatureItem featureItem) throws SeqRangeException {
        return this.extractBases(featureItem.getLocation());
    }

    public final Bioseq extractFeatureBases(Hashtable hashtable) throws SeqRangeException {
        return this.extractRemoveFeatureBases(true, hashtable, null);
    }

    public final Bioseq extractFeatureBases(Hashtable hashtable, SeqRange seqRange) throws SeqRangeException {
        return this.extractRemoveFeatureBases(true, hashtable, seqRange);
    }

    public final Bioseq removeFeatureBases(Hashtable hashtable) throws SeqRangeException {
        return this.extractRemoveFeatureBases(false, hashtable, null);
    }

    public final Bioseq removeFeatureBases(Hashtable hashtable, SeqRange seqRange) throws SeqRangeException {
        return this.extractRemoveFeatureBases(false, hashtable, seqRange);
    }

    public Bioseq extractRemoveFeatureBases(boolean bl, Hashtable hashtable, SeqRange seqRange) throws SeqRangeException {
        if (hashtable != null && this.hasdoc()) {
            this.getdoc().setWantedFeatures(bl, hashtable, seqRange);
            SeqRange seqRange2 = this.getdoc().getFeatureRanges(0, this.seqlen);
            Bioseq bioseq = this.extractBases(seqRange2);
            this.getdoc().setWantedFeatures(bl, null, null);
            return bioseq;
        }
        return null;
    }

    public Bioseq extractBases(SeqRange seqRange) throws SeqRangeException {
        Object object;
        if (seqRange == null) {
            throw new SeqRangeException("Null SeqRange");
        }
        int n = 0;
        boolean bl = seqRange.isComplement();
        int n2 = seqRange.start();
        int n3 = seqRange.max();
        int n4 = n3 - n2 + 1;
        for (object = seqRange; object != null; object = ((SeqRange)object).next()) {
            if (((SeqRange)object).isRemote()) continue;
            n += ((SeqRange)object).nbases();
        }
        object = new StringBuffer("extractBases - Bad range ");
        if (n > 0) {
            Cloneable cloneable;
            int n5 = 0;
            byte[] byArray = new byte[n];
            byte[] byArray2 = null;
            if (this.getseq().isBytes()) {
                n2 = 0;
                byArray2 = this.getseq().toBytes();
            } else {
                byArray2 = this.getseq().toBytes(n2, n4, 0);
            }
            int n6 = this.getseq().getSeqtype();
            boolean bl2 = n6 == 4;
            boolean bl3 = n6 == 2;
            for (cloneable = seqRange; cloneable != null; cloneable = ((SeqRange)cloneable).next()) {
                if (((SeqRange)cloneable).isRemote()) continue;
                int n7 = ((SeqRange)cloneable).start();
                int n8 = ((SeqRange)cloneable).nbases();
                boolean bl4 = bl ? bl : ((SeqRange)cloneable).isComplement();
                boolean bl5 = false;
                if ((n7 -= n2) < 0) {
                    bl5 = true;
                    ((StringBuffer)object).append(n7).append(" start<0");
                    n7 = 0;
                } else if (n7 + n8 > this.seqlen) {
                    bl5 = true;
                    ((StringBuffer)object).append(n7 + n8).append(" end>").append(this.seqlen);
                    n8 = Math.max(0, this.seqlen - n7);
                } else if (n5 + n8 > n) {
                    bl5 = true;
                    ((StringBuffer)object).append(n5 + n8).append("  size>").append(n);
                    n8 = Math.max(0, n - n7);
                } else {
                    bl5 = false;
                }
                if (bl5) {
                    ((StringBuffer)object).append(" of sr=").append(cloneable).append(" in r=").append(seqRange);
                    ((StringBuffer)object).append(", record=").append(this.seqid);
                    if (Debug.isOn) {
                        Debug.println(((StringBuffer)object).toString());
                    } else {
                        throw new SeqRangeException(((StringBuffer)object).toString());
                    }
                }
                if (bl4) {
                    int n9;
                    int n10 = n - n5 - 1;
                    if (bl2) {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = byArray2[n7 + n9];
                        }
                    } else {
                        for (n9 = 0; n9 < n8; ++n9) {
                            byArray[n10 - n9] = BaseKind.nucleicComplement(byArray2[n7 + n9], bl3);
                        }
                    }
                } else {
                    System.arraycopy(byArray2, n7, byArray, n5, n8);
                }
                n5 += n8;
            }
            cloneable = new Bioseq();
            ((Bioseq)cloneable).setbases(byArray);
            return cloneable;
        }
        throw new SeqRangeException("Empty SeqRange");
    }
}

