/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import java.io.IOException;

public class CompareSeqWriter
extends BioseqWriter {
    int seqkind;
    int ndiff;
    long mycrc;
    long osicrc;
    BioseqRecord osi;
    String myname;
    String oldname;

    public void compareTo(BioseqRecord bioseqRecord) {
        this.osi = bioseqRecord;
    }

    public void setSourceNames(String string, String string2) {
        this.myname = string;
        this.oldname = string2;
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        this.writeln("# Compare sources --- " + this.myname + " --- " + this.oldname);
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.writeln("# Compare sequence records ");
        this.seqkind = this.bioseq.getSeqtype();
        this.mycrc = CompareSeqWriter.CRC32checksum(this.bioseq, this.offset, this.seqlen);
        this.osicrc = CompareSeqWriter.CRC32checksum(this.osi.getseq(), this.osi.offset(), this.osi.length());
        this.writeString(Fmt.fmt("  ", 8, 2) + " ");
        this.writeString(Fmt.fmt("ID", 15, 2) + " ");
        this.writeString(Fmt.fmt("Length", 15) + " ");
        this.writeString(Fmt.fmt("Checksum", 15));
        this.writeln();
        this.writeString(Fmt.fmt("NEW", 8, 2) + " ");
        this.writeString(Fmt.fmt(this.seqid, 15, 2) + " ");
        this.writeString(Fmt.fmt(this.seqlen, 15) + " ");
        this.writeString(Fmt.fmt(Long.toHexString(this.mycrc), 15));
        this.writeln();
        this.writeString(Fmt.fmt("OLD", 8, 2) + " ");
        this.writeString(Fmt.fmt(this.osi.getID(), 15, 2) + " ");
        this.writeString(Fmt.fmt(this.osi.length(), 15) + " ");
        this.writeString(Fmt.fmt(Long.toHexString(this.osicrc), 15));
        this.writeln();
        this.writeln("# Differences ----- NEW ------- OLD --------");
        this.ndiff = 0;
    }

    public void writeRecordEnd() {
        this.writeln("# N. differences : " + this.ndiff + " ----------------------------------");
        this.writeln();
    }

    public void writeSeq() {
        if (this.seqlen != this.osi.length()) {
            this.diff("Sequence length: ", String.valueOf(this.seqlen), String.valueOf(this.osi.seqlen));
        } else if (this.mycrc != this.osicrc) {
            this.diff("Sequence checksum :", Long.toHexString(this.mycrc), Long.toHexString(this.osicrc));
        }
    }

    protected void diff(String string, String string2, String string3) {
        this.writeString(Fmt.fmt(string, 15, 2) + " ");
        this.writeString(Fmt.fmt(string2, 15));
        this.writeString(" != ");
        this.writeString(Fmt.fmt(string3, 15));
        this.writeln();
        ++this.ndiff;
    }

    public void writeDoc() {
        if (!this.seqid.equals(this.osi.getID())) {
            this.diff("ID: ", this.seqid, this.osi.seqid);
        }
        if (this.seqdoc instanceof BioseqDoc) {
            BasicBioseqDoc basicBioseqDoc = new BasicBioseqDoc((BioseqDoc)this.seqdoc);
            BasicBioseqDoc basicBioseqDoc2 = new BasicBioseqDoc(this.osi.getdoc());
            this.ndiff += basicBioseqDoc.compareTo(this.douts, basicBioseqDoc2);
        } else if (this.osi.getdoc() != null) {
            this.diff("Document values: ", "(missing)", String.valueOf(this.osi.getdoc().documents().size()));
        }
    }
}

