/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.OpenString;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.EmblSeqReader;
import iubio.readseq.EmblSeqWriter;

public class EmblSeqFormat
extends BioseqFormat {
    protected boolean isAmino;

    public String formatName() {
        return "EMBL|em";
    }

    public String formatSuffix() {
        return ".embl";
    }

    public String contentType() {
        return "biosequence/embl";
    }

    public BioseqReaderIface newReader() {
        return new EmblSeqReader();
    }

    public BioseqWriterIface newWriter() {
        return new EmblSeqWriter();
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean hasdoc() {
        return true;
    }

    public boolean formatTestLine(OpenString openString, int n, int n2) {
        if (openString.startsWith("ID   ")) {
            this.formatLikelihood += 80;
            if (openString.indexOf(" AA.") > 0) {
                this.isAmino = true;
            }
            if (this.recordStartline == 0) {
                this.recordStartline = n;
            }
            return false;
        }
        if (openString.startsWith("AC   ")) {
            this.formatLikelihood += 10;
            return false;
        }
        if (openString.startsWith("DE   ")) {
            this.formatLikelihood += 10;
            return false;
        }
        if (openString.startsWith("SQ   ")) {
            this.formatLikelihood += 70;
            return false;
        }
        return false;
    }
}

