/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import iubio.readseq.GenbankDoc;
import iubio.readseq.SeqFileInfo;
import java.text.SimpleDateFormat;
import java.util.Date;

class GenbankSeqWriter
extends BioseqWriter {
    static final int seqwidth = 60;
    static final int ktab = 0;
    static final int kspacer = 10;
    static final int knumwidth = 9;
    static final int knumflags = 0;
    String datestr;
    int seqkind;

    GenbankSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.spacer = 10;
        this.opts.seqwidth = 60;
        this.opts.numleft = true;
        this.opts.numwidth = 9;
        this.seqkind = this.bioseq.getSeqtype();
    }

    public void writeRecordEnd() {
        this.writeln("//");
    }

    public void writeSeq() {
        int n = 0;
        int n2 = this.opts.origin;
        boolean bl = true;
        if (this.bioseq.isBytes() && this.testbaseKind != 1) {
            byte[] byArray = this.bioseq.toBytes();
            for (int i = 0; i < this.seqlen; ++i) {
                if (bl) {
                    this.writeString(Fmt.fmt(i + n2, 9, 0));
                    this.writeByte(32);
                    bl = false;
                }
                this.writeByte(byArray[this.offset + i]);
                if (i % 60 == 59) {
                    this.writeln();
                    bl = true;
                    continue;
                }
                if (i % 10 != 9) continue;
                this.writeByte(32);
            }
        } else {
            for (int i = 0; i < this.seqlen; ++i) {
                if (bl) {
                    this.writeString(Fmt.fmt(n + n2, 9, 0));
                    this.writeByte(32);
                    bl = false;
                }
                char c = this.bioseq.base(this.offset + i, this.fBasePart);
                if (this.testbaseKind == 1) {
                    c = (char)this.testbase.outSeqChar(c);
                }
                if (c <= '\u0000') continue;
                this.writeByte(c);
                if ((++n - 1) % 60 == 59) {
                    this.writeln();
                    bl = true;
                    continue;
                }
                if ((n - 1) % 10 != 9) continue;
                this.writeByte(32);
            }
        }
        if (!bl) {
            this.writeln();
        }
    }

    protected void writeID() {
        this.writeString("LOCUS       ");
        this.writeString(Fmt.fmt(this.idword, 11, 2));
        this.writeString(Fmt.fmt(this.seqlen, 7, 0));
        if (this.seqkind == 4) {
            this.writeString(" aa ");
        } else {
            this.writeString(" bp ");
        }
        String string = SeqInfo.getKindLabel(this.seqkind);
        this.writeString(Fmt.fmt(string, 6, 0));
        this.writeString("             UNA       ");
        if (this.datestr == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            this.datestr = simpleDateFormat.format(new Date());
        }
        this.writeString(this.datestr);
        this.writeln();
    }

    protected final void writeTitle() {
        this.writeString("DEFINITION  ");
        this.writeln(this.seqid);
    }

    public void writeDoc() {
        String string = this.checksumString();
        if (this.seqdoc instanceof BioseqDoc) {
            GenbankDoc genbankDoc = new GenbankDoc((BioseqDoc)this.seqdoc);
            if (this.seqkind == 4) {
                genbankDoc.setAmino(true);
            }
            boolean bl = true;
            String string2 = genbankDoc.getID();
            if (string2 == null || !this.idword.startsWith(SeqFileInfo.gBlankSeqid) && !string2.equals(this.idword)) {
                this.writeID();
                bl = false;
            }
            if (!bl && genbankDoc.getTitle() == null) {
                this.writeTitle();
            }
            genbankDoc.replaceDocField(112, String.valueOf(this.seqlen));
            if (string.length() > 0) {
                genbankDoc.replaceDocField(114, string);
            }
            this.linesout += genbankDoc.writeTo(this.douts, bl);
        } else {
            this.writeID();
            this.writeTitle();
            if (string.length() > 0) {
                this.writeString("COMMENT     ");
                this.writeln(string);
            }
        }
        this.writeln("ORIGIN      ");
    }
}

