/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.bioseq.BaseKind;
import iubio.readseq.BioseqWriter;
import iubio.readseq.WriteseqOpts;

class PlainSeqWriter
extends BioseqWriter {
    protected final int kMaxlongbuf = 2048;
    protected boolean isoneline;

    PlainSeqWriter() {
    }

    public void writeRecordEnd() {
        if (!this.isoneline) {
            this.writeln();
        }
    }

    public void setOpts(WriteseqOpts writeseqOpts) {
        if (writeseqOpts != null) {
            this.opts.seqwidth = writeseqOpts.seqwidth;
        }
    }

    protected void writeLoop() {
        if (this.opts.seqwidth < 9999 && this.opts.seqwidth > 0) {
            super.writeLoop();
        } else {
            this.isoneline = true;
            int n = Math.min(this.offset + this.seqlen, this.bioseq.length());
            char[] cArray = new char[2048];
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.seqlen) {
                if (this.l1 < 0) {
                    this.l1 = 0;
                }
                ++this.l1;
                char c = this.offset + n2 >= n ? BaseKind.indelEdge : this.bioseq.base(this.offset + n2, this.fBasePart);
                ++n2;
                if (this.testbaseKind == 1) {
                    c = (char)this.testbase.outSeqChar(c);
                }
                if (c > '\u0000') {
                    cArray[n3++] = c;
                }
                if (n3 < 2048 && this.l1 != this.opts.seqwidth && n2 != this.seqlen) continue;
                int n4 = n3;
                n3 = 0;
                this.l1 = 0;
                this.writeByteArray(cArray, 0, n4);
                if (n2 != this.seqlen && this.l1 != this.opts.seqwidth) continue;
                this.writeln();
            }
        }
    }
}

