/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Debug;
import flybase.Environ;
import flybase.FastVector;
import flybase.Native;
import flybase.OpenString;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.readseq.BasicBioseqDoc;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqRecord;
import iubio.readseq.BioseqWriter;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.FeatureItem;
import iubio.readseq.PlainSeqFormat;
import iubio.readseq.PlainSeqReader;
import iubio.readseq.ReadseqException;
import iubio.readseq.RsInput;
import iubio.readseq.RsInputBytes;
import iubio.readseq.RsInputChars;
import iubio.readseq.RsInputFile;
import iubio.readseq.RsInputOpenString;
import iubio.readseq.RsInputReader;
import iubio.readseq.RsInputStream;
import iubio.readseq.RsInputString;
import iubio.readseq.RsInputUrl;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.Testseq;
import iubio.readseq.WriteseqOpts;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Readseq
implements Enumeration {
    public static String version = "Readseq version 2.1.8 (25 June 2002)";
    public static String kInputStringKey = "indata=";
    public boolean verbose;
    public boolean verboseClassic;
    protected int forceFormatId;
    protected File indir;
    protected boolean didinit;
    protected Hashtable exfeatures;
    protected SeqRange featSubrange;
    protected SeqRange extractRange;
    protected boolean wantSelectedFeats;
    protected int extractOrigin;
    protected boolean fWriteMask = SeqFileInfo.gWriteMask;
    protected Testseq formatTestor;
    protected Vector seqfilevec = new Vector();
    protected int fAt;
    protected BioseqReaderIface reader;
    protected BioseqFormat former;
    protected Reader fIns;
    protected RsInput fRdIns;
    protected SeqFileInfo si = new SeqFileInfo();
    protected int format;
    protected int saveskip;
    protected int whichEntry = 1;
    protected String seqDefname;

    public Readseq() {
        this(BioseqFormats.kNoformat);
    }

    public Readseq(int n) {
        this.setFormat(n);
        this.verbose = Debug.isOn || BioseqReader.verbose;
    }

    public Reader getInput() {
        return this.fIns;
    }

    public void setInput(File file) throws IOException {
        this.close();
        this.fRdIns = new RsInputFile(file);
        this.fIns = this.fRdIns;
    }

    public void setInput(Reader reader) throws IOException {
        this.close();
        this.fRdIns = new RsInputReader(reader);
        this.fIns = this.fRdIns;
    }

    public void setInput(InputStream inputStream) throws IOException {
        this.close();
        this.fRdIns = new RsInputStream(inputStream);
        this.fIns = this.fRdIns;
    }

    public void setInput(URL uRL) throws IOException {
        this.close();
        this.fRdIns = new RsInputUrl(uRL);
        this.fIns = this.fRdIns;
    }

    public void setInput(String string) throws IOException {
        this.close();
        this.fRdIns = new RsInputString(string);
        this.fIns = this.fRdIns;
    }

    public void setInput(OpenString openString) throws IOException {
        this.close();
        this.fRdIns = new RsInputOpenString(openString);
        this.fIns = this.fRdIns;
    }

    public void setInput(byte[] byArray) throws IOException {
        this.close();
        this.fRdIns = new RsInputBytes(byArray);
        this.fIns = this.fRdIns;
    }

    public void setInput(char[] cArray) throws IOException {
        this.close();
        this.fRdIns = new RsInputChars(cArray);
        this.fIns = this.fRdIns;
    }

    public String setInputObject(Object object) throws IOException {
        if (object instanceof String) {
            object = this.checkInString((String)object);
        }
        return this.setInputObjectChecked(object);
    }

    public String setInputObjectChecked(Object object) throws IOException {
        if (object instanceof File) {
            this.setInput((File)object);
            return object.toString();
        }
        if (object instanceof URL) {
            this.setInput((URL)object);
            return object.toString();
        }
        if (object instanceof InputStream) {
            this.setInput((InputStream)object);
            return "InputStream";
        }
        if (object instanceof Reader) {
            this.setInput((Reader)object);
            return "Reader";
        }
        if (object instanceof String) {
            this.setInput((String)object);
            return "String";
        }
        if (object instanceof OpenString) {
            this.setInput((OpenString)object);
            return "OpenString";
        }
        if (object instanceof char[]) {
            this.setInput((char[])object);
            return "char[]";
        }
        if (object instanceof byte[]) {
            this.setInput((byte[])object);
            return "byte[]";
        }
        if (object instanceof Enumeration) {
            this.readlist((Enumeration)object);
            return null;
        }
        if (object instanceof Integer) {
            return null;
        }
        if (object != null) {
            this.message("Unreadable input object " + object.getClass().getName());
            return null;
        }
        return null;
    }

    public static String tempFolder() {
        return Environ.gEnv.get("tempdir", Native.tempFolder());
    }

    public static String tempFilename() {
        return Native.tempFilename("readseq-", ".tmp");
    }

    public static File tempFile() {
        return new File(Readseq.tempFolder(), Readseq.tempFilename());
    }

    protected void message(String string) {
        BioseqReader.message(string);
    }

    public void close() throws IOException {
        if (this.fIns != null) {
            this.fIns.close();
        }
        if (this.fRdIns != null) {
            try {
                this.fRdIns.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.fIns = null;
    }

    public void setFormatTestor(Testseq testseq) {
        this.formatTestor = testseq;
    }

    public final boolean isMydata() {
        return this.isKnownFormat();
    }

    public void setInputFormat(int n) {
        this.forceFormatId = n;
    }

    public boolean isKnownFormat() {
        this.si = new SeqFileInfo();
        int n = BioseqFormats.kUnknown;
        if (this.forceFormatId > 0) {
            this.si.format = n = this.forceFormatId;
            this.si.skiplines = 0;
            this.forceFormatId = 0;
        } else {
            if (this.formatTestor == null) {
                this.formatTestor = new Testseq();
            }
            n = this.formatTestor.testFormat(this.fIns, this.si);
            this.fIns = this.formatTestor.getPossibleNewInputReader();
        }
        if (this.verbose) {
            this.message("isKnownFormat format=" + n + ":" + BioseqFormats.formatName(n));
        }
        if (n <= BioseqFormats.kUnknown) {
            return false;
        }
        this.setFormat(n);
        return true;
    }

    public boolean canread() {
        if (this.reader != null) {
            return true;
        }
        if (this.format > 0) {
            return BioseqFormats.canread(this.format);
        }
        return false;
    }

    public final SeqFileInfo getInfo() {
        return this.si;
    }

    public final int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
        this.former = BioseqFormats.bioseqFormat(n);
        if (this.reader != null && this.reader.formatID() != n) {
            this.reader = null;
        }
    }

    public String getFormatName() {
        if (this.reader != null) {
            return BioseqFormats.formatName(this.reader.formatID());
        }
        if (this.format > 0) {
            return BioseqFormats.formatName(this.getFormat());
        }
        return "";
    }

    public BioseqReaderIface getReader() {
        return this.reader;
    }

    public BioseqFormat getBioseqFormat() {
        return this.former;
    }

    public boolean eof() {
        try {
            return this.si != null && this.si.err != 0 || this.fIns == null || !this.fIns.ready();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public URL checkUrl(String string) {
        if (string.lastIndexOf(":/", 30) > 0) {
            try {
                URL uRL;
                if (string.startsWith("systemresource:/") && string.indexOf("/+/") < 0) {
                    uRL = AppResources.global.getUrl(string.substring("systemresource:/".length()));
                    Debug.println(" sysrez -> " + uRL);
                    if (uRL != null) {
                        return uRL;
                    }
                }
                uRL = new URL(string);
                Debug.println(" url -> " + uRL);
                return uRL;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public final Object checkInString(String string) {
        return this.checkInString(string, kInputStringKey);
    }

    public Object checkInString(String string, String string2) {
        if (Debug.isOn) {
            Debug.print("checkInString  '" + string.substring(0, Math.min(80, string.length())));
        }
        if (string.startsWith(string2)) {
            URL uRL = this.checkUrl(string = string.substring(string2.length()));
            if (uRL != null) {
                Debug.println("' is url.");
                return uRL;
            }
            Debug.println("' is data.");
            return string;
        }
        URL uRL = this.checkUrl(string);
        if (uRL != null) {
            Debug.println("' is url.");
            return uRL;
        }
        File file = this.indir != null ? new File(this.indir, string) : new File(string);
        if (file.exists() && file.isFile() && file.canRead()) {
            Debug.println("' is file.");
            return file;
        }
        Debug.println("' is unknown/unreadable object.");
        this.message("Unknown or unreadable data: " + string);
        return new Integer(0);
    }

    public void checkInList(FastVector fastVector, String string) {
        if (fastVector != null) {
            for (int i = 0; i < fastVector.size(); ++i) {
                Object object;
                Object object2 = fastVector.elementAt(i);
                if (!(object2 instanceof String) || (object = this.checkInString((String)object2, string)) == null) continue;
                fastVector.setElementAt(object, i);
            }
        }
    }

    public void setInDirectory(File file) {
        this.indir = file;
    }

    public final void readlist(FastVector fastVector) {
        this.readlist(fastVector, kInputStringKey);
    }

    public final void readlist(Enumeration enumeration) {
        this.readlist(enumeration, kInputStringKey);
    }

    public void readlist(FastVector fastVector, String string) {
        this.readlist(fastVector.elements(), string);
    }

    public void readlist(Enumeration enumeration, String string) {
        if (enumeration == null) {
            return;
        }
        int n = this.forceFormatId;
        while (enumeration.hasMoreElements()) {
            try {
                Object e = enumeration.nextElement();
                String string2 = this.setInputObject(e);
                if (string2 == null) continue;
                if (this.verbose) {
                    this.message("Reading from " + string2);
                }
                if (n > 0) {
                    this.setInputFormat(n);
                }
                if (!this.isKnownFormat()) {
                    this.message("Unknown biosequence format for input " + string2);
                } else if (!this.readInit()) {
                    this.message("Error initializing drawseq for input " + string2);
                } else {
                    while (this.canReadMore()) {
                        this.readNext();
                    }
                }
                this.close();
            }
            catch (IOException iOException) {
                this.message("Readseq.list error: " + iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    public final SeqFileInfo nextSeq() {
        if (this.moreresults()) {
            return (SeqFileInfo)this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public SeqFileInfo[] allSeqs() {
        Object[] objectArray = new SeqFileInfo[this.seqfilevec.size()];
        this.seqfilevec.copyInto(objectArray);
        return objectArray;
    }

    public final Object result() {
        if (this.moreresults()) {
            return this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public final boolean moreresults() {
        return this.fAt < this.seqfilevec.size();
    }

    public final int atresult() {
        return this.fAt;
    }

    public final int nresults() {
        return this.seqfilevec.size();
    }

    public final Vector allresults() {
        return this.seqfilevec;
    }

    public final void restartresults() {
        this.fAt = 0;
    }

    public final void removeresults() {
        this.fAt = 0;
        this.seqfilevec.removeAllElements();
    }

    public boolean hasMoreElements() {
        if (this.moreresults()) {
            return true;
        }
        return this.canReadMore();
    }

    public Object nextElement() {
        if (this.moreresults()) {
            return this.result();
        }
        try {
            if (this.readNext()) {
                return this.result();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void initIfNeeded(String string) {
        if (!this.didinit) {
            this.readInit(string);
        }
    }

    public final boolean readInit() {
        return this.readInit(SeqFileInfo.gBlankSeqid);
    }

    public boolean readInit(String string) {
        if (this.reader == null) {
            this.reader = BioseqFormats.newReader(this.format);
        }
        if (this.reader == null) {
            return false;
        }
        if (this.former.interleaved()) {
            this.fRdIns.makeRewindable();
        }
        this.reader.setInput(this.fIns);
        this.reader.reset();
        if (this.reader instanceof PlainSeqReader) {
            ((PlainSeqReader)this.reader).setInputFile(this.fRdIns.getFile());
        }
        if (this.reader instanceof BioseqReader) {
            int n = ((BioseqReader)this.reader).getReadChunkSize();
            long l = this.fRdIns.guessLength();
            if (l - (long)n > 50000L) {
                n = this.former instanceof PlainSeqFormat ? (int)Math.min(500000L, l) : (int)Math.max((long)n, Math.min(500000L, l / 10L));
                ((BioseqReader)this.reader).setReadChunkSize(n);
            }
        }
        if (string == null) {
            string = SeqFileInfo.gBlankSeqid;
        }
        this.seqDefname = SeqFileInfo.cleanSeqID(string);
        this.saveskip = this.si.skiplines;
        this.whichEntry = 0;
        this.didinit = true;
        return true;
    }

    void verboseClassic(SeqFileInfo seqFileInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sequence ");
        stringBuffer.append(this.whichEntry);
        stringBuffer.append(", length= ");
        stringBuffer.append(seqFileInfo.seqlen);
        long l = 0L;
        try {
            BioseqRecord bioseqRecord = new BioseqRecord(seqFileInfo);
            SeqInfo seqInfo = bioseqRecord.getseq().getSeqStats();
            l = seqInfo.getChecksum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(", checksum= ");
        stringBuffer.append(Long.toHexString(l).toUpperCase());
        stringBuffer.append(", format= ");
        stringBuffer.append(this.former.formatID());
        stringBuffer.append(". ");
        stringBuffer.append(this.former.formatName());
        stringBuffer.append(", id= ");
        stringBuffer.append(seqFileInfo.seqid);
        this.message(stringBuffer.toString());
    }

    public boolean canReadMore() {
        if (this.reader == null) {
            return false;
        }
        if (this.former.interleaved()) {
            return this.whichEntry == 0 ? true : this.whichEntry < this.si.nseq;
        }
        if (!this.reader.endOfFile()) {
            return true;
        }
        return !this.eof();
    }

    public SeqFileInfo readAt(int n) throws IOException {
        if (this.reader == null) {
            throw new ReadseqException("Null BioseqReader");
        }
        this.si = this.readSeq(this.si, n);
        if (this.si != null) {
            if (!this.si.hasid()) {
                this.si.seqid = this.seqDefname;
            }
            this.extractOrigin = 0;
            if (this.extractRange != null && !this.extractRange.isEmpty()) {
                int n2 = this.extractRange.start() + this.extractRange.origin();
                int n3 = this.extractRange.nbases();
                if (this.si.length() >= n3 && this.si.offset() + this.si.length() > n2) {
                    this.si.setoffset(n2);
                    this.si.setlength(n3);
                    this.extractOrigin = n2;
                }
            }
        }
        return this.si;
    }

    public boolean readNext() throws IOException {
        this.si = this.readAt(++this.whichEntry);
        if (this.si != null && (this.si.hasseq() || this.si.hasdoc())) {
            this.seqfilevec.addElement(this.si);
        }
        return this.moreresults();
    }

    public void setFeatureExtraction(Hashtable hashtable, SeqRange seqRange) {
        this.exfeatures = hashtable;
        this.featSubrange = seqRange;
        this.wantSelectedFeats = this.exfeatures != null && !this.exfeatures.isEmpty();
    }

    public void setExtractRange(SeqRange seqRange) {
        this.extractRange = seqRange;
    }

    protected void writeSelectedFeatureRecords(SeqFileInfo seqFileInfo, BioseqWriterIface bioseqWriterIface, BioseqWriterIface bioseqWriterIface2) throws IOException {
        BioseqRecord bioseqRecord = new BioseqRecord(seqFileInfo);
        BioseqRecord bioseqRecord2 = new BioseqRecord();
        String string = bioseqRecord.getID();
        bioseqRecord2.setSeqID(string);
        BasicBioseqDoc basicBioseqDoc = new BasicBioseqDoc(string);
        SeqRange seqRange = new SeqRange(bioseqRecord.offset(), bioseqRecord.length());
        int n = seqRange.start();
        int n2 = seqRange.max();
        if (Debug.isOn) {
            Debug.println("writeSelectedFeatureRecords for " + bioseqRecord);
        }
        if (bioseqRecord.hasdoc()) {
            basicBioseqDoc.addDocField(bioseqRecord.getdoc().findDocItem(30, 0));
            basicBioseqDoc.addDocField(bioseqRecord.getdoc().findDocItem(80, 0));
            basicBioseqDoc.addDocField(bioseqRecord.getdoc().findDocItem(20, 0));
        }
        FeatureItem[] featureItemArray = bioseqRecord.findFeatures(this.exfeatures, this.extractRange);
        String string2 = "";
        Enumeration enumeration = this.exfeatures.keys();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + (String)enumeration.nextElement() + ", ";
        }
        if (featureItemArray == null) {
            basicBioseqDoc.addComment("No such features found: " + string2);
            bioseqRecord2.set(null, basicBioseqDoc, null);
            if (bioseqWriterIface2 == null) {
                bioseqWriterIface2 = bioseqWriterIface;
            }
            if (bioseqWriterIface2 != null && bioseqWriterIface2.setSeq(bioseqRecord2)) {
                bioseqWriterIface2.writeSeqRecord();
            }
        } else {
            basicBioseqDoc.addComment("Extracted features: " + string2);
            if (this.featSubrange != null) {
                basicBioseqDoc.addComment("Extracted feature subrange: " + this.featSubrange);
            }
            FeatureItem featureItem = null;
            int n3 = 0;
            for (int i = 0; i < featureItemArray.length; ++i) {
                Object object;
                try {
                    int n4;
                    featureItem = featureItemArray[i];
                    if (Debug.isOn && i < 10) {
                        Debug.println(" feature [" + i + "]=" + featureItem);
                    }
                    SeqRange seqRange2 = featureItem.getLocation();
                    if (this.featSubrange != null) {
                        seqRange2 = seqRange2.subrange(this.featSubrange);
                    }
                    if (n > seqRange2.start() || n2 < seqRange2.max()) {
                        int n5 = Math.max(n, seqRange2.start());
                        n4 = Math.min(n2, seqRange2.max());
                        seqRange2 = new SeqRange(n5, n4 - n5 + 1);
                    }
                    object = bioseqRecord.extractBases(seqRange2);
                    n4 = 0;
                    n4 = seqRange2.isComplement() ? -(seqRange2.origin() + seqRange2.max()) : seqRange2.origin() + seqRange2.start();
                    String string3 = BioseqRecord.getNextBlankID(string);
                    basicBioseqDoc.replaceDocField(10, string3);
                    bioseqRecord2.setSeqID(string3);
                    basicBioseqDoc.addFeature(featureItem);
                    basicBioseqDoc.addFeature("extracted_range", seqRange2);
                    basicBioseqDoc.addFeatureNote("/note", "Location extracted from source. Feature locations are for source, not for this extraction.");
                    bioseqRecord2.set(object, basicBioseqDoc, null);
                    if (bioseqWriterIface2 != null && bioseqWriterIface2.setSeq(bioseqRecord2)) {
                        bioseqWriterIface2.writeSeqRecord();
                    }
                    if (bioseqWriterIface != null && bioseqWriterIface.setSeq(bioseqRecord2)) {
                        if (bioseqWriterIface instanceof BioseqWriter) {
                            WriteseqOpts writeseqOpts = ((BioseqWriter)bioseqWriterIface).getOpts();
                            writeseqOpts.origin = n4;
                        }
                        bioseqWriterIface.writeSeqRecord();
                    }
                    basicBioseqDoc.features().removeAllElements();
                    continue;
                }
                catch (Exception exception) {
                    if (Debug.isOn) {
                        Debug.println("Exception with feature [" + i + "]=" + featureItem);
                        exception.printStackTrace();
                    }
                    if (n3++ > 2) {
                        object = new ReadseqException(exception.getMessage());
                        throw object;
                    }
                    basicBioseqDoc.features().removeAllElements();
                }
            }
        }
    }

    public void writeSeqTo(SeqFileInfo seqFileInfo, BioseqWriterIface bioseqWriterIface, BioseqWriterIface bioseqWriterIface2) throws IOException {
        if (this.extractOrigin > 0 && bioseqWriterIface instanceof BioseqWriter) {
            WriteseqOpts writeseqOpts = ((BioseqWriter)bioseqWriterIface).getOpts();
            writeseqOpts.origin = this.extractOrigin;
        }
        if (this.wantSelectedFeats && seqFileInfo.hasdoc()) {
            this.writeSelectedFeatureRecords(seqFileInfo, bioseqWriterIface, bioseqWriterIface2);
        } else {
            if (bioseqWriterIface2 != null && bioseqWriterIface2.setSeq(seqFileInfo)) {
                bioseqWriterIface2.writeSeqRecord();
            }
            if (bioseqWriterIface != null && bioseqWriterIface.setSeq(seqFileInfo)) {
                bioseqWriterIface.writeSeqRecord();
            }
        }
    }

    public void setWriteMask(boolean bl) {
        this.fWriteMask = bl;
    }

    public boolean readTo(BioseqWriterIface bioseqWriterIface) throws IOException {
        return this.readTo(bioseqWriterIface, false);
    }

    public boolean readToOld(BioseqWriterIface bioseqWriterIface, boolean bl) throws IOException {
        if (this.reader == null) {
            throw new ReadseqException("Null BioseqReader");
        }
        if (bl) {
            bioseqWriterIface.writeHeader();
        }
        this.reader.readTo(bioseqWriterIface, this.si.skiplines);
        if (bl) {
            bioseqWriterIface.writeTrailer();
        }
        return true;
    }

    public boolean readTo(BioseqWriterIface bioseqWriterIface, boolean bl) throws IOException {
        if (bl) {
            bioseqWriterIface.writeHeader();
        }
        if (this.reader instanceof BioseqReader) {
            ((BioseqReader)this.reader).setSkipDocs(!this.wantSelectedFeats && !bioseqWriterIface.wantsDocument());
        }
        while (this.canReadMore() && (this.si = this.readAt(++this.whichEntry)) != null) {
            this.writeSeqTo(this.si, bioseqWriterIface, null);
        }
        if (bl) {
            bioseqWriterIface.writeTrailer();
        }
        return true;
    }

    public boolean readToPair(BioseqWriterIface bioseqWriterIface, BioseqWriterIface bioseqWriterIface2, boolean bl) throws IOException {
        if (bl) {
            bioseqWriterIface2.writeHeader();
            bioseqWriterIface.writeHeader();
        }
        if (this.reader instanceof BioseqReader) {
            ((BioseqReader)this.reader).setSkipDocs(false);
        }
        while (this.canReadMore() && (this.si = this.readAt(++this.whichEntry)) != null) {
            this.writeSeqTo(this.si, bioseqWriterIface, bioseqWriterIface2);
        }
        if (bl) {
            bioseqWriterIface2.writeTrailer();
            bioseqWriterIface.writeTrailer();
        }
        return true;
    }

    public void list(Writer writer) {
        try {
            boolean bl = true;
            while (bl) {
                this.si = this.readSeq(this.si, -1);
                bl = this.si != null && (this.si.hasseq() || this.si.hasdoc());
                if (!bl) continue;
                writer.write(((Bioseq)this.si.seq).toChars());
            }
        }
        catch (IOException iOException) {
            Debug.println("list error");
            iOException.printStackTrace();
        }
    }

    protected SeqFileInfo readSeq(SeqFileInfo seqFileInfo, int n) throws IOException {
        this.reader.skipPastHeader(seqFileInfo.skiplines);
        seqFileInfo.skiplines = 0;
        this.whichEntry = n;
        SeqFileInfo seqFileInfo2 = this.reader.readOne(this.whichEntry);
        if (this.verboseClassic && seqFileInfo2 != null) {
            this.verboseClassic(seqFileInfo2);
        } else if (this.verbose && seqFileInfo2 != null) {
            this.message("read " + n + ", id=" + seqFileInfo2.seqid + " seqlen=" + seqFileInfo2.seqlen);
        }
        return seqFileInfo2;
    }
}

