/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.HTMLFilterReader;
import iubio.readseq.PlainSeqFormat;
import iubio.readseq.SeqFileInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class Testseq {
    public static int maxlines2check = 500;
    public static int kBufferSize = 4094;
    protected static int plainFormatID = BioseqFormats.formatFromContentType("biosequence/plain");
    protected boolean done;
    protected int splen;
    protected int nbytes;
    protected int nlines;
    protected int format;
    protected int skiplines;
    protected int maxbytes2check;
    protected SeqInfo seqkind;
    protected Reader fIns;
    protected Reader fNewIns;
    private static final boolean bTestHtmlFilter = true;
    private static final boolean bSuckAll = true;
    private OpenString sp;
    private BufferedReader dis;
    private char[] osval;
    private OpenString osbuf;
    private int oslinei;
    private int oslen;
    private int osnewlinesize = 1;
    private char osnewline;

    public Testseq() {
        this.initTest();
    }

    public int getFormat() {
        return this.format;
    }

    public int getStartLine() {
        return this.skiplines;
    }

    public Reader getPossibleNewInputReader() {
        return this.fNewIns != null ? this.fNewIns : this.fIns;
    }

    public Reader getFilterReader() {
        return this.fNewIns;
    }

    protected void initTest() {
        this.format = BioseqFormats.kUnknown;
        this.done = false;
        this.skiplines = 0;
        this.splen = 0;
        this.nlines = 0;
        this.nbytes = 0;
        this.maxbytes2check = kBufferSize - 200;
        this.seqkind = SeqInfo.getSeqInfo(this.maxbytes2check, false, false);
    }

    protected final OpenString readLine() {
        return this.readOSLine();
    }

    protected OpenString readInsLine() {
        this.sp = null;
        this.splen = 0;
        try {
            String string = this.dis.readLine();
            if (string == null) {
                this.done = true;
            } else {
                this.sp = new OpenString(string);
                this.splen = this.sp.length();
                ++this.nlines;
                this.nbytes += this.splen;
            }
        }
        catch (IOException iOException) {
            this.done = true;
        }
        return this.sp;
    }

    protected OpenString readOSLine() {
        if (this.oslinei < 0) {
            this.done = true;
            this.splen = 0;
            this.sp = null;
        } else {
            int n = this.osbuf.indexOf(this.osnewline, this.oslinei);
            if (n < this.oslinei) {
                this.sp = this.osbuf.substring(this.oslinei);
                this.oslinei = -1;
            } else {
                this.sp = this.osbuf.substring(this.oslinei, n);
                this.oslinei = n + this.osnewlinesize;
                this.nbytes += this.osnewlinesize;
            }
            this.splen = this.sp.length();
            ++this.nlines;
            this.nbytes += this.splen;
        }
        return this.sp;
    }

    protected void openStream(Reader reader) {
        if (this.osval == null) {
            this.osval = new char[kBufferSize];
        }
        try {
            this.oslen = reader.read(this.osval);
            this.osbuf = new OpenString(this.osval, 0, this.oslen);
            this.oslinei = 0;
        }
        catch (IOException iOException) {
            this.oslen = 0;
            this.oslinei = -1;
        }
        this.osnewlinesize = 1;
        for (int i = 0; i < this.oslen; ++i) {
            if (this.osval[i] == '\n') {
                this.osnewline = (char)10;
                if (this.osval[i + 1] != '\r') break;
                this.osnewlinesize = 2;
                break;
            }
            if (this.osval[i] != '\r') continue;
            this.osnewline = (char)13;
            if (this.osval[i + 1] != '\n') break;
            this.osnewlinesize = 2;
            break;
        }
    }

    protected boolean checkMailHeader() {
        int n = this.sp.indexOf("From ");
        if (n != 0) {
            n = this.sp.indexOf("Received");
        }
        if (n == 0) {
            int n2 = 0;
            do {
                this.sp = this.readLine();
                for (n2 = 0; n2 < this.splen && this.sp.charAt(n2) <= ' '; ++n2) {
                }
            } while (!this.done && n2 < this.splen);
            this.skiplines = this.nlines;
            return true;
        }
        return false;
    }

    protected boolean checkHtmlHeader() {
        boolean bl = false;
        int n = this.sp.indexOf("<HTML");
        if (n < 0) {
            n = this.sp.indexOf("<html");
        }
        if (n < 0) {
            n = this.sp.indexOf("<BODY");
        }
        if (n < 0) {
            n = this.sp.indexOf("<body");
        }
        if (n < 0) {
            n = this.sp.indexOf("<PRE");
            if (n < 0) {
                n = this.sp.indexOf("<pre");
            }
            if (n >= 0) {
                bl = true;
                this.sp = this.sp.substring(n + 5);
                this.splen = this.sp.length();
            }
        }
        if (n >= 0) {
            while (!bl && !this.done) {
                this.sp = this.readLine();
                if (this.done) continue;
                int n2 = this.sp.indexOf("<PRE>");
                if (n2 < 0) {
                    n2 = this.sp.indexOf("<pre>");
                }
                if (n2 < 0) continue;
                bl = true;
                this.sp = this.sp.substring(n2 + 5);
                this.splen = this.sp.length();
            }
            this.skiplines = this.nlines - 1;
            this.fNewIns = new HTMLFilterReader(this.fIns, this.nbytes - this.splen - 1);
            Debug.println("using HTMLFilterReader");
            this.skiplines = 0;
            this.nlines = 1;
            return true;
        }
        return false;
    }

    public int testFormat(Reader reader, SeqFileInfo seqFileInfo) {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.fIns = reader;
        if (reader == null) {
            seqFileInfo.err = -1;
            this.format = BioseqFormats.kNoformat;
            return this.format;
        }
        this.initTest();
        BioseqFormats.formatTestInit();
        this.openStream(reader);
        boolean bl = false;
        BioseqFormat bioseqFormat = BioseqFormats.bioseqFormat(BioseqFormats.formatFromName("raw"));
        if (bioseqFormat instanceof PlainSeqFormat) {
            ((PlainSeqFormat)bioseqFormat).setSeqInfoTester(this.seqkind);
        }
        while (!this.done) {
            int n7;
            int n8;
            this.sp = this.readLine();
            if (this.nlines < 10 && !this.done && !bl) {
                if (this.checkHtmlHeader()) {
                    bl = true;
                } else if (this.checkMailHeader()) {
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (this.sp != null && this.splen > 0) {
                for (n8 = 1; n8 <= BioseqFormats.nFormats(); ++n8) {
                    if (!BioseqFormats.formatTestLine(n8, this.sp, this.nlines, this.skiplines)) continue;
                    bl2 = true;
                }
                if (!bl2 || this.nlines - this.skiplines > 10) {
                    this.seqkind.add(this.sp.getValue(), this.sp.getOffset(), this.splen);
                    n7 = this.seqkind.getKind();
                    switch (n7) {
                        case 1: 
                        case 2: {
                            if (this.splen <= 20) break;
                            ++n6;
                            break;
                        }
                        case 4: {
                            if (this.splen <= 20) break;
                            ++n5;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 0: {
                            ++n4;
                        }
                    }
                }
            }
            n2 = -1;
            n3 = 0;
            for (n8 = 1; n8 <= BioseqFormats.nFormats(); ++n8) {
                n7 = BioseqFormats.formatTestLikelihood(n8);
                if (n7 <= n3) continue;
                n2 = n8;
                n3 = n7;
            }
            if (n2 >= 0 && n3 >= 90) {
                this.format = BioseqFormats.formatFromIndex(n2);
                this.done = true;
                continue;
            }
            if (!this.done && this.nbytes <= this.maxbytes2check) continue;
            this.format = n2 >= 0 && n3 > 50 ? BioseqFormats.formatFromIndex(n2) : (n4 > 0 ? BioseqFormats.kUnknown : (n6 > 0 ? plainFormatID : (n5 > 0 ? plainFormatID : BioseqFormats.kUnknown)));
            this.done = true;
        }
        if (n2 >= 0) {
            n = BioseqFormats.recordStartLine(n2) - 1;
        }
        if (this.skiplines == 0 && n > 0) {
            this.skiplines = n;
        }
        seqFileInfo.format = this.format;
        seqFileInfo.skiplines = this.skiplines;
        return this.format;
    }
}

