/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.ReadseqException;
import iubio.readseq.SeqFileInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class Writeseq
implements Enumeration {
    protected Vector seqfilevec = new Vector();
    protected int fAt;
    protected int format;
    protected int minbases;
    protected boolean sizesDiffer = false;
    protected boolean fWriteMask = SeqFileInfo.gWriteMask;
    protected BioseqWriterIface writer;
    protected BioseqFormat former;

    public Writeseq() {
        this(BioseqFormats.kNoformat);
    }

    public Writeseq(int n) {
        this.setFormat(n);
    }

    public final int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
        this.former = BioseqFormats.bioseqFormat(n);
        if (this.writer != null && this.writer.formatID() != n) {
            this.writer = null;
        }
    }

    public BioseqWriterIface getWriter() {
        return this.writer;
    }

    public BioseqFormat getBioseqFormat() {
        return this.former;
    }

    public boolean canwrite() {
        if (this.writer != null) {
            return true;
        }
        if (this.former != null) {
            return this.former.canwrite();
        }
        return false;
    }

    public SeqFileInfo nextSeq() {
        if (this.moreresults()) {
            return (SeqFileInfo)this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public Object result() {
        if (this.moreresults()) {
            return this.seqfilevec.elementAt(this.fAt++);
        }
        return null;
    }

    public boolean moreresults() {
        return this.fAt < this.seqfilevec.size();
    }

    public int atresult() {
        return this.fAt;
    }

    public int nresults() {
        return this.seqfilevec.size();
    }

    public Vector allresults() {
        return this.seqfilevec;
    }

    public void restartresults() {
        this.fAt = 0;
    }

    public void removeresults() {
        this.fAt = 0;
        this.seqfilevec.removeAllElements();
    }

    public boolean hasMoreElements() {
        return this.moreresults();
    }

    public Object nextElement() {
        if (this.moreresults()) {
            return this.result();
        }
        return null;
    }

    public void addSeq(SeqFileInfo seqFileInfo) {
        if (this.minbases <= 0) {
            this.minbases = seqFileInfo.seqlen;
        } else {
            if (seqFileInfo.seqlen != this.minbases) {
                this.sizesDiffer = true;
            }
            this.minbases = Math.min(seqFileInfo.seqlen, this.minbases);
        }
        this.seqfilevec.addElement(seqFileInfo);
    }

    public void addSeq(Object object, String string, int n, int n2, Object object2, boolean bl) {
        SeqFileInfo seqFileInfo = new SeqFileInfo();
        seqFileInfo.seq = object;
        seqFileInfo.seqdoc = object2;
        seqFileInfo.offset = n;
        seqFileInfo.seqlen = n2;
        seqFileInfo.seqid = string;
        seqFileInfo.hasmask = bl;
        this.addSeq(seqFileInfo);
    }

    public void setWriteMask(boolean bl) {
        this.fWriteMask = bl;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public final void open(File file, int n, int n2) throws IOException {
        this.open(new FileWriter(file), n, n2);
    }

    public void open(Writer writer, int n, int n2) throws IOException {
        if (n <= BioseqFormats.kUnknown) {
            throw new ReadseqException("Unknown BioseqWriter format: " + n);
        }
        this.setFormat(n);
        if (this.writer == null) {
            this.writer = BioseqFormats.newWriter(n, n2);
        }
        if (this.writer == null) {
            throw new ReadseqException("Null BioseqWriter");
        }
        this.writer.setOutput(writer);
        this.minbases = 0;
        this.sizesDiffer = false;
        this.removeresults();
    }

    public boolean write() throws IOException {
        this.restartresults();
        if (this.moreresults()) {
            if (this.writer == null) {
                throw new ReadseqException("Null BioseqWriter");
            }
            this.writer.setNseq(this.nresults());
            if (this.sizesDiffer && this.former.needsamelength()) {
                this.setSameSize();
            }
            this.writer.writeHeader();
            while (this.moreresults()) {
                SeqFileInfo seqFileInfo = this.nextSeq();
                if (this.writer.setSeq(seqFileInfo)) {
                    this.writer.writeSeqRecord();
                }
                if (!this.fWriteMask) continue;
                if (!this.writer.setMask(seqFileInfo, SeqFileInfo.gMaskName)) continue;
                this.writer.writeSeqRecord();
            }
            this.writer.writeTrailer();
            return true;
        }
        return false;
    }

    protected void setSameSize() {
        this.restartresults();
        while (this.moreresults()) {
            SeqFileInfo seqFileInfo = this.nextSeq();
            seqFileInfo.seqlen = this.minbases;
        }
        this.restartresults();
    }
}

