/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.FastStack;
import flybase.FastVector;
import iubio.bioseq.Bioseq;
import iubio.readseq.BioseqDocVals;
import iubio.readseq.BioseqReader;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.SeqFileInfo;
import iubio.readseq.XmlDoc;
import iubio.readseq.XmlSeqFormat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class XmlSeqReader
implements BioseqReaderIface,
BioseqDocVals,
EntityResolver,
DTDHandler,
DocumentHandler,
ErrorHandler {
    public boolean showErrors;
    public static int readChunkSize = 2048;
    protected int formatId;
    protected int err;
    protected int seqlen;
    protected int offset;
    protected int nseq;
    protected int atseq;
    protected int seqoffset;
    protected int seqlencount;
    protected int maxseqlen;
    protected int choice;
    protected String seqid = SeqFileInfo.gBlankSeqid;
    protected String idword = SeqFileInfo.gBlankSeqid;
    protected boolean skipdocs;
    protected boolean verbose;
    protected byte[] seqbytes;
    private XmlDoc xmlseqdoc;
    private FastVector seqvec;
    private boolean fEof = false;
    private Reader fIns;
    protected static final int kUseTester = 1;
    protected static final int kAnyChar = 2;
    protected static final int kAlphaChar = 3;
    protected int testbaseKind = 3;
    protected int inElVal;
    protected int inFeatures;
    protected int parselevel;
    protected int docfieldlevel;
    protected Integer inEl;
    protected String inTagName;
    protected boolean inElAppend;
    protected FastStack inElStack = new FastStack();
    protected StringBuffer inFeatureKey;
    protected StringBuffer inFeatureVal;
    protected int featlevel;
    boolean continueOnError = true;
    protected BioseqWriterIface bioseqwriter;

    public XmlSeqReader() {
        this.showErrors = Debug.isOn;
        this.verbose = BioseqReader.verbose;
    }

    private final int testbase(int n) {
        switch (this.testbaseKind) {
            default: {
                if (n <= 32 || n >= 48 && n <= 57) {
                    return 0;
                }
                return n;
            }
            case 2: 
        }
        if (n < 32) {
            return 0;
        }
        return n;
    }

    protected void message(String string) {
        BioseqReader.message(string);
    }

    public int formatID() {
        return this.formatId;
    }

    public void setFormatID(int n) {
        this.formatId = n;
    }

    public int seqLen() {
        return this.seqlen;
    }

    public int getNseq() {
        return this.nseq;
    }

    public void setChoice(int n) {
        this.choice = n;
    }

    public void setInput(Reader reader) {
        this.fIns = reader;
        this.fEof = false;
        this.setReaderBuf(this.fIns);
    }

    public void doRead() throws IOException {
        if (this.fIns == null) {
            throw new FileNotFoundException();
        }
        if (this.seqvec == null || this.seqvec.isEmpty()) {
            this.doSaxRead();
        }
    }

    public void readTo(BioseqWriterIface bioseqWriterIface, int n) throws IOException {
        this.skipdocs = !bioseqWriterIface.wantsDocument();
        this.setSaxWriteTo(bioseqWriterIface);
        this.doSaxRead();
        this.setSaxWriteTo(null);
    }

    public SeqFileInfo readOne(int n) throws IOException {
        this.resetSeq();
        this.setChoice(n);
        if (this.endOfFile()) {
            return null;
        }
        this.doRead();
        SeqFileInfo seqFileInfo = new SeqFileInfo();
        this.copyto(seqFileInfo);
        seqFileInfo.nseq = this.getNseq();
        seqFileInfo.checkSeqID();
        return seqFileInfo;
    }

    public boolean endOfFile() {
        if (this.seqvec != null) {
            return this.choice > this.seqvec.size();
        }
        return this.fEof;
    }

    private void setReaderBuf(Reader reader) {
        if (this.seqvec != null) {
            this.seqvec.removeAllElements();
        }
    }

    public void reset() {
        this.atseq = 0;
        this.err = 0;
        this.seqlencount = 0;
        this.seqlen = 0;
        this.fEof = false;
        if (this.fIns != null) {
            try {
                this.fIns.reset();
                this.fEof = !this.fIns.ready();
                this.setReaderBuf(this.fIns);
            }
            catch (IOException iOException) {
                Debug.println(this.getClass().getName() + ".reset() err=" + iOException.getMessage());
            }
        }
    }

    public void skipPastHeader(int n) {
    }

    public void copyto(SeqFileInfo seqFileInfo) {
        if (seqFileInfo == null) {
            return;
        }
        try {
            SeqFileInfo seqFileInfo2 = (SeqFileInfo)this.seqvec.elementAt(this.choice - 1);
            seqFileInfo2.copyto(seqFileInfo);
        }
        catch (Exception exception) {
            seqFileInfo.err = -2;
        }
    }

    protected void storeSeq() throws IOException {
        if (this.seqlen > 0) {
            ++this.atseq;
            ++this.nseq;
            Bioseq bioseq = new Bioseq(this.seqbytes, 0, this.seqlen);
            SeqFileInfo seqFileInfo = new SeqFileInfo(bioseq, 0, this.seqlen);
            seqFileInfo.atseq = this.atseq;
            seqFileInfo.nseq = this.nseq;
            seqFileInfo.seqid = this.seqid;
            seqFileInfo.err = this.err;
            seqFileInfo.seqdoc = this.xmlseqdoc;
            if (Debug.isOn || this.verbose) {
                this.message("saxread " + seqFileInfo.nseq + " id=" + seqFileInfo.seqid + " seqlen=" + seqFileInfo.seqlen);
            }
            if (this.seqvec == null) {
                this.seqvec = new FastVector();
            }
            if (this.bioseqwriter != null) {
                if (this.bioseqwriter.setSeq(seqFileInfo)) {
                    this.bioseqwriter.writeSeqRecord();
                }
                SeqFileInfo seqFileInfo2 = new SeqFileInfo();
                seqFileInfo2.seqid = seqFileInfo.seqid;
                seqFileInfo2.atseq = seqFileInfo.atseq;
                this.seqvec.addElement(seqFileInfo2);
            } else {
                this.seqvec.addElement(seqFileInfo);
            }
        }
    }

    public void setSeqName(String string) {
        this.seqid = string;
        this.seqid = this.seqid.trim();
        int n = this.seqid.indexOf(32);
        if (n <= 0) {
            n = this.seqid.length();
        }
        if (n > 30) {
            n = 30;
        }
        this.idword = this.seqid.substring(0, n).toString();
    }

    protected void doSaxRead() throws IOException {
        try {
            Parser parser2;
            try {
                parser2 = ParserFactory.makeParser(XmlSeqFormat.saxParserClass);
            }
            catch (Exception exception) {
                parser2 = ParserFactory.makeParser();
            }
            if (parser2 == null) {
                throw new IOException("Can't instantiate an XML parser");
            }
            parser2.setDocumentHandler(this);
            parser2.setDTDHandler(this);
            parser2.setErrorHandler(this);
            InputSource inputSource = new InputSource(this.fIns);
            parser2.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    protected void setSaxWriteTo(BioseqWriterIface bioseqWriterIface) {
        this.bioseqwriter = bioseqWriterIface;
    }

    protected void initSaxDoc() {
        this.nseq = 0;
        this.atseq = 0;
        this.inFeatures = 0;
        this.inElVal = 0;
        this.inEl = null;
        this.inTagName = null;
        this.inElAppend = false;
        this.inElStack.removeAllElements();
        this.inFeatureKey = new StringBuffer();
        this.inFeatureVal = new StringBuffer();
        this.resetSaxSeq();
    }

    protected void resetSaxSeq() {
        this.resetSeq();
        this.xmlseqdoc = new XmlDoc();
        this.xmlseqdoc.setSkipDocs(this.skipdocs);
    }

    public void resetSeq() {
        this.seqlencount = 0;
        this.seqlen = 0;
        this.idword = SeqFileInfo.gBlankSeqid;
        this.seqid = SeqFileInfo.gBlankSeqid;
    }

    protected void addseq(char[] cArray, int n, int n2) {
        n2 += n;
        for (int i = n; i < n2; ++i) {
            int n3 = this.testbase(cArray[i]);
            if (n3 <= 0) continue;
            if (this.seqlen >= this.maxseqlen && !this.expand()) {
                return;
            }
            this.seqbytes[this.seqlen++] = (byte)n3;
        }
    }

    protected boolean expand() {
        this.maxseqlen += readChunkSize;
        if (this.seqbytes == null) {
            this.seqbytes = new byte[this.maxseqlen];
        } else {
            byte[] byArray = new byte[this.maxseqlen];
            System.arraycopy(this.seqbytes, 0, byArray, 0, this.seqlen);
            this.seqbytes = byArray;
        }
        return this.seqbytes != null;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.errorOut("error: ", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errorOut("fatalError: ", sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.errorOut("warning: ", sAXParseException);
    }

    protected void errorOut(String string, SAXParseException sAXParseException) {
        ++this.err;
        if (this.showErrors) {
            int n;
            String string2 = sAXParseException.getSystemId();
            if (string2 != null && (n = string2.lastIndexOf(47)) > 0) {
                string2 = string2.substring(n + 1);
            }
            this.message(string2 + ":" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + " ");
            this.message(string + sAXParseException.getMessage());
        }
    }

    public void startDocument() throws SAXException {
        try {
            if (this.xmlseqdoc == null || this.nseq > 0) {
                this.initSaxDoc();
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endDocument() throws SAXException {
        this.fEof = true;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            int n = this.inElVal;
            if (this.inEl != null) {
                this.inElStack.push(new Pair(this.inTagName, this.inEl));
            }
            this.inTagName = string;
            this.inElAppend = false;
            ++this.parselevel;
            this.inEl = this.xmlseqdoc.getBiodocInteger(string);
            this.inElVal = this.inEl != null ? this.inEl : 0;
            switch (this.inElVal) {
                case 1: 
                case 2: 
                case 3: {
                    this.xmlseqdoc.addDocField(this.inTagName, "", this.inElVal, 1, false);
                    this.docfieldlevel = this.parselevel + 1;
                    break;
                }
                case 70: {
                    this.inFeatures = 2;
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    this.xmlseqdoc.addDocField(this.inTagName, "", this.inElVal, 1, false);
                    break;
                }
                case 71: {
                    break;
                }
                case 72: {
                    if (this.inFeatureKey.length() <= 0 || n != 71) break;
                    this.xmlseqdoc.startFeature(71, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
                case 74: 
                case 75: {
                    if (this.inFeatureVal.length() > 0) {
                        // empty if block
                    }
                    this.inFeatureVal.setLength(0);
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endElement(String string) throws SAXException {
        try {
            switch (this.inElVal) {
                case 2: {
                    this.storeSeq();
                    this.resetSaxSeq();
                    break;
                }
                case 70: {
                    this.inFeatures = 3;
                    break;
                }
                case 71: {
                    this.xmlseqdoc.endFeature(71, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
                case 72: {
                    this.xmlseqdoc.endFeature(72, this.inFeatureKey.toString(), this.inFeatureVal.toString());
                    this.inFeatureVal.setLength(0);
                    this.inFeatureKey.setLength(0);
                    break;
                }
            }
            --this.parselevel;
            if (!this.inElStack.empty()) {
                Pair pair = (Pair)this.inElStack.pop();
                this.inEl = pair.val;
                this.inTagName = pair.name;
                this.inElVal = this.inEl != null ? this.inEl : 0;
                this.inElAppend = true;
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    protected String charsToString(char[] cArray, int n, int n2) {
        int n3;
        while (n2 > 0 && cArray[n + n2 - 1] <= ' ') {
            --n2;
        }
        for (n3 = 0; n3 < n2 && cArray[n + n3] <= ' '; ++n3) {
        }
        if (n3 > 0) {
            n += n3;
            n2 -= n3;
        }
        if (n2 <= 0) {
            return null;
        }
        String string = new String(cArray, n, n2);
        string = string.replace('\n', ' ');
        return string;
    }

    protected StringBuffer charsToString(StringBuffer stringBuffer, char[] cArray, int n, int n2) {
        String string = this.charsToString(cArray, n, n2);
        if (stringBuffer != null) {
            if (string == null) {
                return stringBuffer;
            }
            stringBuffer.append(string);
            return stringBuffer;
        }
        return new StringBuffer(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (!this.xmlseqdoc.keepField(this.inElVal)) {
                return;
            }
            switch (this.inElVal) {
                case 111: {
                    this.addseq(cArray, n, n2);
                    break;
                }
                case 10: {
                    this.docfieldlevel = this.parselevel;
                    String string = this.charsToString(cArray, n, n2);
                    if (string != null) {
                        this.setSeqName(string);
                        this.xmlseqdoc.addDocField(this.inTagName, string, this.inElVal, 1, this.inElAppend);
                        this.inElAppend = true;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.docfieldlevel = this.parselevel + 1;
                }
                case 70: 
                case 200: {
                    break;
                }
                default: {
                    String string = this.charsToString(cArray, n, n2);
                    if (string != null || !this.inElAppend) {
                        int n3 = this.parselevel > this.docfieldlevel ? 2 : 1;
                        this.xmlseqdoc.addDocField(this.inTagName, string, this.inElVal, n3, this.inElAppend);
                        this.inElAppend = true;
                    }
                    break;
                }
                case 74: 
                case 75: {
                    this.inFeatureVal = this.charsToString(this.inFeatureVal, cArray, n, n2);
                    break;
                }
                case 71: {
                    this.inFeatureKey = this.charsToString(this.inFeatureKey, cArray, n, n2);
                    break;
                }
                case 72: {
                    this.inFeatureKey = this.charsToString(this.inFeatureKey, cArray, n, n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    class Pair {
        Integer val;
        String name;

        Pair(String string, Integer n) {
            this.name = string;
            this.val = n;
        }
    }
}

