/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.Presentation;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class WindowPresentation
extends Presentation {
    private HelpSet.Presentation hsPres = null;
    private JFrame frame = null;
    private JHelp jhelp = null;
    private JDialog dialog = null;
    private Window ownerWindow = null;
    private boolean modallyActivated = false;
    private Point location = null;
    private String title = null;
    private Image image = null;
    private String currentView = null;
    private boolean viewDisplayed = true;
    private boolean toolbarDisplayed = true;
    private boolean destroyOnExit = false;
    private boolean titleFromDocument = false;
    private WindowPropertyChangeListener propertyChangeListener = null;
    WindowListener dl;
    boolean modalDeactivated = true;
    private static final boolean debug = false;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Window;

    public WindowPresentation(HelpSet helpSet) {
        this.setHelpSet(helpSet);
    }

    public void setHelpSetPresentation(HelpSet.Presentation presentation) {
        Map.ID iD;
        String string;
        WindowPresentation.debug("setHelpSetPrsentation");
        if (presentation == null) {
            return;
        }
        super.setHelpSetPresentation(presentation);
        Point point = presentation.getLocation();
        if (point != null) {
            this.setLocation(point);
        }
        if ((string = presentation.getTitle()) != null) {
            this.setTitle(string);
        }
        if ((iD = presentation.getImageID()) != null) {
            ImageIcon imageIcon = null;
            try {
                Map map = this.getHelpSet().getCombinedMap();
                URL uRL = map.getURLFromID(iD);
                imageIcon = new ImageIcon(uRL);
                this.image = imageIcon.getImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.hsPres = presentation;
    }

    public HelpSet.Presentation getHelpSetPresentation() {
        return this.hsPres;
    }

    public Window getActivationWindow() {
        WindowPresentation.debug("getActivationWindow");
        return this.ownerWindow;
    }

    public void setActivationWindow(Window window) {
        WindowPresentation.debug("setActivationWindow");
        if (window != null && window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (dialog.isModal()) {
                this.ownerWindow = window;
                this.modallyActivated = true;
            } else {
                this.ownerWindow = null;
                this.modallyActivated = false;
            }
        } else {
            this.ownerWindow = null;
            this.modallyActivated = false;
        }
    }

    public void setActivationObject(Object object) {
        WindowPresentation.debug("setActivationObject");
        while (object instanceof MenuComponent) {
            object = ((MenuComponent)object).getParent();
        }
        Window window = null;
        if (object instanceof Frame) {
            window = (Window)object;
        } else if (object instanceof Component) {
            window = SwingUtilities.windowForComponent((Component)object);
        }
        this.setActivationWindow(window);
    }

    public String getCurrentView() {
        WindowPresentation.debug("getCurrentView");
        if (this.jhelp != null) {
            this.currentView = this.jhelp.getCurrentNavigator().getNavigatorName();
        }
        return this.currentView;
    }

    public void setCurrentView(String string) {
        WindowPresentation.debug("setCurrentView");
        if (this.jhelp != null) {
            JHelpNavigator jHelpNavigator = this.getNavigatorByName(string);
            if (jHelpNavigator == null) {
                throw new IllegalArgumentException("Invalid view name");
            }
            this.jhelp.setCurrentNavigator(jHelpNavigator);
        } else {
            HelpSet helpSet = this.getHelpSet();
            NavigatorView navigatorView = helpSet.getNavigatorView(string);
            if (navigatorView == null) {
                throw new IllegalArgumentException("Invalid view name");
            }
        }
        this.currentView = string;
    }

    private JHelpNavigator getNavigatorByName(String string) {
        JHelpNavigator jHelpNavigator = null;
        if (this.jhelp != null) {
            Enumeration enumeration = this.jhelp.getHelpNavigators();
            while (enumeration.hasMoreElements()) {
                jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
                if (jHelpNavigator.getNavigatorName().equals(string)) break;
                jHelpNavigator = null;
            }
        }
        return jHelpNavigator;
    }

    public boolean isDestroyedOnExit() {
        WindowPresentation.debug("isDestoryedOnExit");
        return this.destroyOnExit;
    }

    public void setDestroyOnExit(boolean bl) {
        WindowPresentation.debug("setDestoryOnExit");
        this.destroyOnExit = bl;
    }

    public void destroy() {
        this.frame = null;
        this.jhelp = null;
        this.dialog = null;
        this.ownerWindow = null;
        this.location = null;
        this.title = null;
        this.currentView = null;
        this.propertyChangeListener = null;
    }

    public void setDisplayed(boolean bl) {
        WindowPresentation.debug("setDisplayed");
        if (this.jhelp == null && !bl) {
            return;
        }
        this.createHelpWindow();
        if (this.modallyActivated) {
            if (bl) {
                this.dialog.show();
            } else {
                this.dialog.hide();
            }
        } else {
            this.frame.setVisible(bl);
            try {
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = (class$java$awt$Frame == null ? (class$java$awt$Frame = WindowPresentation.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("setState", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{new Integer(0)};
                    method.invoke((Object)this.frame, objectArray);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public boolean isDisplayed() {
        WindowPresentation.debug("isDisplayed");
        if (this.jhelp == null) {
            return false;
        }
        if (this.modallyActivated) {
            if (this.dialog != null) {
                return this.dialog.isShowing();
            }
            return false;
        }
        if (this.frame != null) {
            if (!this.frame.isVisible()) {
                return false;
            }
            try {
                Method method = (class$java$awt$Frame == null ? (class$java$awt$Frame = WindowPresentation.class$("java.awt.Frame")) : class$java$awt$Frame).getMethod("getState", null);
                if (method != null) {
                    int n = (Integer)method.invoke((Object)this.frame, null);
                    return n == 0;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
        WindowPresentation.debug("setFont");
        super.setFont(font);
        if (this.jhelp != null) {
            this.jhelp.setFont(font);
        }
    }

    public void setLocale(Locale locale) {
        WindowPresentation.debug("setLocale");
        super.setLocale(locale);
        if (this.jhelp != null) {
            this.jhelp.setLocale(locale);
        }
    }

    public Point getLocation() {
        WindowPresentation.debug("getLocation");
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                return this.dialog.getLocation();
            }
            return this.frame.getLocation();
        }
        return this.location;
    }

    public void setLocation(Point point) {
        WindowPresentation.debug("setLocation");
        this.location = point;
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                this.dialog.setLocation(point);
            } else {
                this.frame.setLocation(point);
            }
        }
    }

    public void setSize(Dimension dimension) {
        WindowPresentation.debug("setSize");
        super.setSize(dimension);
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                this.dialog.setSize(dimension);
                this.dialog.validate();
            } else {
                this.frame.setSize(dimension);
                this.frame.validate();
            }
        }
    }

    public String getTitle() {
        Object object;
        WindowPresentation.debug("getTitle");
        if (this.titleFromDocument && this.jhelp != null && (object = this.jhelp.getContentViewer().getDocumentTitle()) != null) {
            return object;
        }
        if (this.title != null) {
            return this.title;
        }
        object = this.getHelpSet();
        if (object != null) {
            this.title = ((HelpSet)object).getTitle();
        }
        return this.title;
    }

    public void setTitle(String string) {
        WindowPresentation.debug("setTitle");
        this.title = string;
        if (this.jhelp != null) {
            if (this.modallyActivated) {
                this.dialog.setTitle(string);
                this.dialog.validate();
            } else {
                this.frame.setTitle(string);
                this.frame.validate();
            }
        }
    }

    public boolean isTitleSetFromDocument() {
        WindowPresentation.debug("isTitleSetFromDocument");
        return this.titleFromDocument;
    }

    public void setTitleFromDocument(boolean bl) {
        WindowPresentation.debug("setTitleFromDocument");
        if (this.titleFromDocument != bl) {
            this.titleFromDocument = bl;
            if (this.titleFromDocument) {
                this.propertyChangeListener = new WindowPropertyChangeListener();
                if (this.jhelp != null) {
                    this.jhelp.getContentViewer().addPropertyChangeListener("page", this.propertyChangeListener);
                }
            } else if (this.jhelp != null) {
                this.jhelp.getContentViewer().removePropertyChangeListener("page", this.propertyChangeListener);
            }
        }
    }

    public boolean isViewDisplayed() {
        WindowPresentation.debug("isViewDisplayed");
        if (this.jhelp != null) {
            return this.jhelp.isNavigatorDisplayed();
        }
        return this.viewDisplayed;
    }

    public void setViewDisplayed(boolean bl) {
        WindowPresentation.debug("setViewDisplayed");
        if (this.jhelp != null) {
            this.jhelp.setNavigatorDisplayed(bl);
        }
        this.viewDisplayed = bl;
    }

    public boolean isToolbarDisplayed() {
        WindowPresentation.debug("isToolbarDisplayed");
        if (this.jhelp != null) {
            return this.jhelp.isToolbarDisplayed();
        }
        return this.toolbarDisplayed;
    }

    public void setToolbarDisplayed(boolean bl) {
        WindowPresentation.debug("setToolbarDisplayed=" + bl);
        if (this.jhelp != null) {
            this.jhelp.setToolbarDisplayed(bl);
        }
        this.toolbarDisplayed = bl;
    }

    private synchronized void createJHelp() {
        WindowPresentation.debug("createJHelp");
        if (this.jhelp == null) {
            JHelpNavigator jHelpNavigator;
            Locale locale;
            this.jhelp = new JHelp(this.getHelpModel(), null, this.getHelpSetPresentation());
            Font font = this.getFont();
            if (font != null) {
                this.jhelp.setFont(font);
            }
            if ((locale = this.getLocale()) != null) {
                this.jhelp.setLocale(locale);
            }
            this.jhelp.setToolbarDisplayed(this.toolbarDisplayed);
            this.jhelp.setNavigatorDisplayed(this.viewDisplayed);
            if (this.currentView != null && (jHelpNavigator = this.getNavigatorByName(this.currentView)) != null) {
                this.jhelp.setCurrentNavigator(jHelpNavigator);
            }
            if (this.titleFromDocument) {
                this.jhelp.getContentViewer().addPropertyChangeListener("page", this.propertyChangeListener);
            }
        }
    }

    public synchronized void createHelpWindow() {
        WindowPresentation.debug("createHelpWindow");
        Point point = null;
        Dimension dimension = null;
        JDialog jDialog = null;
        this.createJHelp();
        if (this.modallyActivated) {
            Window window = null;
            try {
                Method method = (class$java$awt$Window == null ? (class$java$awt$Window = WindowPresentation.class$("java.awt.Window")) : class$java$awt$Window).getMethod("getOwner", null);
                if (method != null && this.dialog != null) {
                    window = (Window)method.invoke((Object)this.dialog, null);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (this.dialog == null || window != this.ownerWindow || this.modalDeactivated) {
                if (this.frame != null) {
                    point = this.frame.getLocation();
                    dimension = this.frame.getSize();
                    this.frame.dispose();
                }
                if (this.dialog != null) {
                    point = this.dialog.getLocation();
                    dimension = this.dialog.getSize();
                    jDialog = this.dialog;
                }
                this.dialog = new JDialog((Dialog)this.ownerWindow, this.getTitle());
                this.dl = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        WindowPresentation.debug("modal window closing");
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                        if (WindowPresentation.this.dialog.isShowing()) {
                            WindowPresentation.this.dialog.hide();
                        }
                        if (WindowPresentation.this.ownerWindow != null) {
                            WindowPresentation.this.ownerWindow.removeWindowListener(WindowPresentation.this.dl);
                        }
                        WindowPresentation.this.ownerWindow = null;
                        WindowPresentation.this.modalDeactivated = true;
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        WindowPresentation.debug("modal window closing");
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                    }
                };
                WindowPresentation.debug("adding windowlistener");
                this.ownerWindow.addWindowListener(this.dl);
                this.modalDeactivated = false;
                if (dimension != null) {
                    this.dialog.setSize(dimension);
                } else {
                    this.dialog.setSize(this.getSize());
                }
                if (point != null) {
                    this.dialog.setLocation(point);
                } else if (this.location != null) {
                    this.dialog.setLocation(this.location);
                }
                this.dialog.setTitle(this.getTitle());
                this.dialog.getContentPane().add(this.jhelp);
                if (jDialog != null) {
                    jDialog.dispose();
                }
            }
        } else {
            if (this.frame == null) {
                this.frame = new JFrame(this.getTitle());
                WindowAdapter windowAdapter = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                        WindowPresentation.this.frame.setVisible(false);
                    }

                    public void windowClosed(WindowEvent windowEvent) {
                        WindowPresentation.this.frame.setVisible(false);
                        if (WindowPresentation.this.destroyOnExit) {
                            WindowPresentation.this.destroy();
                            return;
                        }
                    }
                };
                this.frame.addWindowListener(windowAdapter);
                if (this.image != null) {
                    this.frame.setIconImage(this.image);
                }
            }
            if (this.dialog != null) {
                point = this.dialog.getLocation();
                dimension = this.dialog.getSize();
                this.dialog.dispose();
                this.dialog = null;
                this.ownerWindow = null;
            }
            if (dimension != null) {
                this.frame.setSize(dimension);
            } else {
                this.frame.setSize(this.getSize());
            }
            if (point != null) {
                this.frame.setLocation(point);
            } else if (this.location != null) {
                this.frame.setLocation(this.location);
            }
            this.frame.getContentPane().add(this.jhelp);
            this.frame.setTitle(this.getTitle());
        }
    }

    private static void debug(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WindowPropertyChangeListener
    implements PropertyChangeListener {
        private WindowPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("page")) {
                String string2 = WindowPresentation.this.getTitle();
                if (WindowPresentation.this.modallyActivated) {
                    WindowPresentation.this.dialog.setTitle(string2);
                } else {
                    WindowPresentation.this.frame.setTitle(string2);
                }
            }
        }
    }
}

