/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverMappedNames;
import org.apache.commons.discovery.resource.names.DiscoverNamesInAlternateManagedProperties;
import org.apache.commons.discovery.resource.names.DiscoverNamesInManagedProperties;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.discovery.resource.names.NameDiscoverers;
import org.apache.commons.discovery.tools.ClassUtils;
import org.apache.commons.discovery.tools.DefaultClassHolder;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.discovery.tools.ManagedProperties;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.logging.Log;

public class AxisProperties {
    protected static Log log = LogFactory.getLog(AxisProperties.class.getName());
    private static DiscoverNamesInAlternateManagedProperties altNameDiscoverer;
    private static DiscoverMappedNames mappedNames;
    private static NameDiscoverers nameDiscoverer;
    private static ClassLoaders loaders;

    public static void setClassOverrideProperty(Class clazz, String string) {
        AxisProperties.getAlternatePropertyNameDiscoverer().addClassToPropertyNameMapping(clazz.getName(), string);
    }

    public static void setClassDefault(Class clazz, String string) {
        AxisProperties.getMappedNames().map(clazz.getName(), string);
    }

    public static void setClassDefaults(Class clazz, String[] stringArray) {
        AxisProperties.getMappedNames().map(clazz.getName(), stringArray);
    }

    public static synchronized ResourceNameDiscover getNameDiscoverer() {
        if (nameDiscoverer == null) {
            nameDiscoverer = new NameDiscoverers();
            nameDiscoverer.addResourceNameDiscover(AxisProperties.getAlternatePropertyNameDiscoverer());
            nameDiscoverer.addResourceNameDiscover(new DiscoverNamesInManagedProperties());
            nameDiscoverer.addResourceNameDiscover(new DiscoverServiceNames(AxisProperties.getClassLoaders()));
            nameDiscoverer.addResourceNameDiscover(AxisProperties.getMappedNames());
        }
        return nameDiscoverer;
    }

    public static ResourceClassIterator getResourceClassIterator(Class clazz) {
        ResourceNameIterator resourceNameIterator = AxisProperties.getNameDiscoverer().findResourceNames(clazz.getName());
        return new DiscoverClasses(loaders).findResourceClasses(resourceNameIterator);
    }

    private static synchronized ClassLoaders getClassLoaders() {
        if (loaders == null) {
            loaders = ClassLoaders.getAppLoaders(AxisProperties.class, null, true);
        }
        return loaders;
    }

    private static synchronized DiscoverMappedNames getMappedNames() {
        if (mappedNames == null) {
            mappedNames = new DiscoverMappedNames();
        }
        return mappedNames;
    }

    private static synchronized DiscoverNamesInAlternateManagedProperties getAlternatePropertyNameDiscoverer() {
        if (altNameDiscoverer == null) {
            altNameDiscoverer = new DiscoverNamesInAlternateManagedProperties();
        }
        return altNameDiscoverer;
    }

    public static Object newInstance(Class clazz) {
        return AxisProperties.newInstance(clazz, null, null);
    }

    public static Object newInstance(final Class clazz, final Class[] classArray, final Object[] objectArray) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceClassIterator resourceClassIterator = AxisProperties.getResourceClassIterator(clazz);
                Object object = null;
                while (object == null && resourceClassIterator.hasNext()) {
                    Class clazz2 = resourceClassIterator.nextResourceClass().loadClass();
                    if (clazz2 == null) continue;
                    try {
                        ClassUtils.verifyAncestory(clazz, clazz2);
                        object = ClassUtils.newInstance(clazz2, classArray, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (invocationTargetException.getTargetException() instanceof NoClassDefFoundError) {
                            log.debug(Messages.getMessage("exception00"), invocationTargetException);
                            continue;
                        }
                        log.warn(Messages.getMessage("exception00"), invocationTargetException);
                    }
                    catch (Exception exception) {
                        log.warn(Messages.getMessage("exception00"), exception);
                    }
                }
                return object;
            }
        });
    }

    public static String getProperty(String string) {
        return ManagedProperties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return ManagedProperties.getProperty(string, string2);
    }

    public static void setProperty(String string, String string2) {
        ManagedProperties.setProperty(string, string2);
    }

    public static void setProperty(String string, String string2, boolean bl) {
        ManagedProperties.setProperty(string, string2, bl);
    }

    public static void setProperties(Map map) {
        ManagedProperties.setProperties(map);
    }

    public static void setProperties(Map map, boolean bl) {
        ManagedProperties.setProperties(map, bl);
    }

    public static Enumeration propertyNames() {
        return ManagedProperties.propertyNames();
    }

    public static Properties getProperties() {
        return ManagedProperties.getProperties();
    }

    public static Object newInstance(Class clazz, Class clazz2) {
        return AxisProperties.newInstance(new SPInterface(clazz), new DefaultClassHolder(clazz2));
    }

    private static Object newInstance(final SPInterface sPInterface, final DefaultClassHolder defaultClassHolder) {
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return DiscoverClass.newInstance(null, sPInterface, null, defaultClassHolder);
                }
                catch (Exception exception) {
                    log.error(Messages.getMessage("exception00"), exception);
                    return null;
                }
            }
        });
    }
}

