/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.Part;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.message.MimeHeaders;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;

public class Message
extends SOAPMessage
implements Serializable {
    protected static Log log = LogFactory.getLog(Message.class.getName());
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    public static final String MIME_APPLICATION_DIME = "application/dime";
    public static final String DEFAULT_ATTACHMNET_IMPL = "org.apache.axis.attachments.AttachmentsImpl";
    private static String mAttachmentsImplClassName = "org.apache.axis.attachments.AttachmentsImpl";
    public static final String MIME_UNKNOWN = "  ";
    private String messageType;
    private SOAPPart mSOAPPart;
    private Attachments mAttachments = null;
    private MimeHeaders headers;
    private boolean saveRequired = true;
    private MessageContext msgContext;
    private static Class attachImpl = null;
    private static boolean checkForAttachmentSupport = true;
    private static boolean attachmentSupportEnabled = false;
    private Hashtable mProps = new Hashtable();

    public static String getAttachmentImplClassName() {
        return mAttachmentsImplClassName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public Message(Object object, boolean bl) {
        this.setup(object, bl, null, null, null);
    }

    public Message(Object object, boolean bl, javax.xml.soap.MimeHeaders mimeHeaders) {
        this.setup(object, bl, null, null, mimeHeaders);
    }

    public Message(Object object, MimeHeaders mimeHeaders) {
        this.setup(object, true, null, null, mimeHeaders);
    }

    public Message(Object object, boolean bl, String string, String string2) {
        this.setup(object, bl, string, string2, null);
    }

    public Message(Object object) {
        this.setup(object, false, null, null, null);
    }

    private static synchronized boolean isAttachmentSupportEnabled(MessageContext messageContext) {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                AxisEngine axisEngine;
                String string = DEFAULT_ATTACHMNET_IMPL;
                if (null != messageContext && null != (axisEngine = messageContext.getAxisEngine())) {
                    string = (String)axisEngine.getOption("attachments.implementation");
                }
                if (null == string) {
                    string = DEFAULT_ATTACHMNET_IMPL;
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImpl = ClassUtils.forName(string);
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            log.debug(Messages.getMessage("attachEnabled") + MIME_UNKNOWN + attachmentSupportEnabled);
        }
        return attachmentSupportEnabled;
    }

    private void setup(Object object, boolean bl, String string, String string2, javax.xml.soap.MimeHeaders mimeHeaders) {
        int n;
        String[] stringArray;
        if (string == null && mimeHeaders != null) {
            stringArray = mimeHeaders.getHeader("Content-Type");
            String string3 = string = stringArray != null ? stringArray[0] : null;
        }
        if (string2 == null && mimeHeaders != null) {
            stringArray = mimeHeaders.getHeader("Content-Location");
            String string4 = string2 = stringArray != null ? stringArray[0] : null;
        }
        if (string != null && (n = string.lastIndexOf("charset")) > 0) {
            int n2;
            String string5 = string.substring(n);
            String string6 = string5.substring((n2 = string5.indexOf(61)) + 1).trim();
            if (string6.startsWith("\"") && string6.endsWith("\"") || string6.startsWith("'") && string6.endsWith("'")) {
                string6 = string6.substring(1, string6.length() - 1);
            }
            try {
                this.setProperty("javax.xml.soap.character-set-encoding", string6);
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        if (Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            Constructor<?> constructor = attachImpl.getConstructors()[0];
            try {
                this.mAttachments = (Attachments)constructor.newInstance(object, string, string2);
                this.mSOAPPart = (SOAPPart)this.mAttachments.getRootPart();
            }
            catch (InvocationTargetException invocationTargetException) {
                log.fatal(Messages.getMessage("invocationTargetException00"), invocationTargetException);
                throw new RuntimeException(invocationTargetException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                log.fatal(Messages.getMessage("instantiationException00"), instantiationException);
                throw new RuntimeException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                log.fatal(Messages.getMessage("illegalAccessException00"), illegalAccessException);
                throw new RuntimeException(illegalAccessException.getMessage());
            }
        } else if (string != null && string.startsWith("multipart")) {
            throw new RuntimeException(Messages.getMessage("noAttachments"));
        }
        if (null == this.mSOAPPart) {
            this.mSOAPPart = new SOAPPart(this, object, bl);
        } else {
            this.mSOAPPart.setMessage(this);
        }
        if (this.mAttachments != null) {
            this.mAttachments.setRootPart(this.mSOAPPart);
        }
        this.headers = mimeHeaders == null ? new MimeHeaders() : new MimeHeaders(mimeHeaders);
    }

    public javax.xml.soap.SOAPPart getSOAPPart() {
        return this.mSOAPPart;
    }

    public String getSOAPPartAsString() throws AxisFault {
        return this.mSOAPPart.getAsString();
    }

    public byte[] getSOAPPartAsBytes() throws AxisFault {
        return this.mSOAPPart.getAsBytes();
    }

    public SOAPEnvelope getSOAPEnvelope() throws AxisFault {
        return this.mSOAPPart.getAsSOAPEnvelope();
    }

    public Attachments getAttachmentsImpl() {
        return this.mAttachments;
    }

    public String getContentType(SOAPConstants sOAPConstants) throws AxisFault {
        Object object;
        boolean bl = false;
        if (sOAPConstants != null) {
            if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                bl = true;
            }
        } else {
            object = this.getSOAPEnvelope();
            if (object != null && ((SOAPEnvelope)object).getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
                bl = true;
            }
        }
        object = XMLUtils.getEncoding(this, this.msgContext);
        String string = sOAPConstants.getContentType() + "; charset=" + ((String)object).toLowerCase();
        if (bl) {
            string = "application/soap+xml; charset=" + (String)object;
        }
        if (this.getSendType() != 4 && this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
            string = this.mAttachments.getContentType();
        }
        return string;
    }

    private int getSendType() {
        int n = 1;
        if (this.msgContext != null && this.msgContext.getService() != null) {
            n = this.msgContext.getService().getSendType();
        }
        return n;
    }

    public long getContentLength() throws AxisFault {
        long l = this.mSOAPPart.getContentLength();
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            l = this.mAttachments.getContentLength();
        }
        return l;
    }

    public void writeTo(OutputStream outputStream) throws SOAPException, IOException {
        if (this.getSendType() == 4 || this.mAttachments == null || 0 == this.mAttachments.getAttachmentCount()) {
            try {
                String string = XMLUtils.getEncoding(this, this.msgContext);
                this.mSOAPPart.setEncoding(string);
                this.mSOAPPart.writeTo(outputStream);
            }
            catch (IOException iOException) {
                log.error(Messages.getMessage("javaIOException00"), iOException);
            }
        } else {
            try {
                this.mAttachments.writeContentToStream(outputStream);
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
            }
        }
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.mSOAPPart.getEnvelope().getBody();
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.mSOAPPart.getEnvelope().getHeader();
    }

    public void setProperty(String string, Object object) throws SOAPException {
        this.mProps.put(string, object);
    }

    public Object getProperty(String string) throws SOAPException {
        return this.mProps.get(string);
    }

    public String getContentDescription() {
        String[] stringArray = this.headers.getHeader("Content-Description");
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public void setContentDescription(String string) {
        this.headers.setHeader("Content-Description", string);
    }

    public void saveChanges() throws SOAPException {
        if (this.mAttachments != null && 0 < this.mAttachments.getAttachmentCount()) {
            try {
                this.headers.setHeader("Content-Type", this.mAttachments.getContentType());
            }
            catch (AxisFault axisFault) {
                log.error(Messages.getMessage("exception00"), axisFault);
            }
        }
        this.saveRequired = false;
        try {
            this.mSOAPPart.saveChanges();
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("exception00"), axisFault);
        }
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public javax.xml.soap.MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public void removeAllAttachments() {
        this.mAttachments.removeAllAttachments();
    }

    public int countAttachments() {
        return this.mAttachments == null ? 0 : this.mAttachments.getAttachmentCount();
    }

    public Iterator getAttachments() {
        try {
            if (this.mAttachments != null && 0 != this.mAttachments.getAttachmentCount()) {
                return this.mAttachments.getAttachments().iterator();
            }
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("exception00"), axisFault);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getAttachments(javax.xml.soap.MimeHeaders mimeHeaders) {
        return this.mAttachments.getAttachments(mimeHeaders);
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        try {
            this.mAttachments.addAttachmentPart((Part)((Object)attachmentPart));
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("exception00"), axisFault);
        }
    }

    public AttachmentPart createAttachmentPart() {
        if (!Message.isAttachmentSupportEnabled(this.getMessageContext())) {
            throw new RuntimeException(Messages.getMessage("noAttachments"));
        }
        try {
            return (AttachmentPart)((Object)this.mAttachments.createAttachmentPart());
        }
        catch (AxisFault axisFault) {
            log.error(Messages.getMessage("exception00"), axisFault);
            return null;
        }
    }

    public void dispose() {
        if (this.mAttachments != null) {
            this.mAttachments.dispose();
        }
    }
}

