/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.MimeHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.commons.logging.Log;

public class MimeUtils {
    protected static Log log = LogFactory.getLog(MimeUtils.class.getName());
    public static String[] filter = new String[]{"Message-ID", "Mime-Version", "Content-Type"};

    public static long getContentLength(Multipart multipart) throws MessagingException, IOException {
        Object object;
        int n = multipart.getCount();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            object = (MimeBodyPart)multipart.getBodyPart(i);
            l += MimeUtils.getContentLength((MimeBodyPart)object);
        }
        String string = multipart.getContentType();
        object = new ContentType(string);
        String string2 = ((ContentType)object).getParameter("boundary");
        int n2 = string2.length() + 4;
        return l + (long)(n2 * (n + 1)) + (long)(2 * n) + 4L;
    }

    protected static long getContentLength(MimeBodyPart mimeBodyPart) {
        long l = -1L;
        long l2 = -1L;
        try {
            l = MimeUtils.getHeaderLength(mimeBodyPart);
            DataHandler dataHandler = mimeBodyPart.getDataHandler();
            DataSource dataSource = dataHandler.getDataSource();
            if (dataSource instanceof FileDataSource) {
                FileDataSource fileDataSource = (FileDataSource)dataSource;
                File file = fileDataSource.getFile();
                if (!file.exists()) {
                    throw new RuntimeException(Messages.getMessage("noFile", file.getAbsolutePath()));
                }
                l2 = file.length();
            } else {
                l2 = mimeBodyPart.getSize();
                if (-1L == l2) {
                    int n;
                    l2 = 0L;
                    InputStream inputStream = dataSource.getInputStream();
                    byte[] byArray = new byte[65536];
                    do {
                        if ((n = inputStream.read(byArray)) <= 0) continue;
                        l2 += (long)n;
                    } while (n > -1);
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
        }
        return l2 + l;
    }

    private static long getHeaderLength(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart(new InternetHeaders(), new byte[0]);
        Object object = mimeBodyPart.getAllHeaders();
        while (object.hasMoreElements()) {
            Header header = (Header)object.nextElement();
            mimeBodyPart2.addHeader(header.getName(), header.getValue());
        }
        object = new ByteArrayOutputStream(16384);
        mimeBodyPart2.writeTo((OutputStream)object);
        ((ByteArrayOutputStream)object).close();
        return ((ByteArrayOutputStream)object).size();
    }

    public static void writeToMultiPartStream(OutputStream outputStream, MimeMultipart mimeMultipart) {
        try {
            Properties properties = AxisProperties.getProperties();
            properties.setProperty("mail.smtp.host", "localhost");
            Session session = Session.getInstance(properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setContent(mimeMultipart);
            mimeMessage.saveChanges();
            mimeMessage.writeTo(outputStream, filter);
        }
        catch (MessagingException messagingException) {
            log.error(Messages.getMessage("javaxMailMessagingException00"), messagingException);
        }
        catch (IOException iOException) {
            log.error(Messages.getMessage("javaIOException00"), iOException);
        }
    }

    public static String getContentType(MimeMultipart mimeMultipart) {
        StringBuffer stringBuffer = new StringBuffer(mimeMultipart.getContentType());
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '\r' || c == '\n') {
                stringBuffer.deleteCharAt(n);
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static MimeMultipart createMP(String string, Collection collection) throws AxisFault {
        MimeMultipart mimeMultipart = null;
        try {
            String string2 = SessionUtils.generateSessionId();
            mimeMultipart = new MimeMultipart("related; type=\"text/xml\"; start=\"<" + string2 + ">\"");
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(string, "UTF-8");
            mimeBodyPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
            mimeBodyPart.setHeader("Content-Id", "<" + string2 + ">");
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
            mimeMultipart.addBodyPart(mimeBodyPart);
            for (Part part : collection) {
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(part);
                String string3 = part.getContentId();
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDataHandler(dataHandler);
                String string4 = part.getContentType();
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = dataHandler.getContentType();
                }
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "application/octet-stream";
                }
                mimeBodyPart.setHeader("Content-Type", string4);
                mimeBodyPart.setHeader("Content-Id", "<" + string3 + ">");
                mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
                Iterator iterator = part.getNonMatchingMimeHeaders(new String[]{"Content-Type", "Content-Id", "Content-Transfer-Encoding"});
                while (iterator.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)iterator.next();
                    mimeBodyPart.setHeader(mimeHeader.getName(), mimeHeader.getValue());
                }
                mimeMultipart.addBodyPart(mimeBodyPart);
            }
        }
        catch (MessagingException messagingException) {
            log.error(Messages.getMessage("javaxMailMessagingException00"), messagingException);
        }
        return mimeMultipart;
    }
}

