/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Handler;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHeaderParam;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPTransport;
import org.apache.axis.transport.java.JavaTransport;
import org.apache.axis.transport.local.LocalTransport;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.FaultInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.commons.logging.Log;

public class Call
implements javax.xml.rpc.Call {
    protected static Log log = LogFactory.getLog(Call.class.getName());
    private static Log tlog = LogFactory.getLog("org.apache.axis.TIME");
    protected static Log entLog = LogFactory.getLog("org.apache.axis.enterprise");
    private boolean parmAndRetReq = true;
    private Service service = null;
    private QName portName = null;
    private QName portTypeName = null;
    private QName operationName = null;
    private MessageContext msgContext = null;
    private LockableHashtable myProperties = new LockableHashtable();
    private String username = null;
    private String password = null;
    private boolean maintainSession = false;
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private Integer timeout = null;
    private boolean useStreaming = false;
    private OperationDesc operation = null;
    private boolean operationSetManually = false;
    private boolean invokeOneWay = false;
    private boolean isMsg = false;
    private Transport transport = null;
    private String transportName = null;
    private HashMap outParams = null;
    private ArrayList outParamsList = null;
    private Vector myHeaders = null;
    public static final String SEND_TYPE_ATTR = "sendXsiTypes";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String CHARACTER_SET_ENCODING = "javax.xml.soap.character-set-encoding";
    public static final String TRANSPORT_PROPERTY = "java.protocol.handler.pkgs";
    public static final String WSDL_SERVICE = "wsdl.service";
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    public static final String JAXRPC_SERVICE = "wsdl.service";
    public static final String JAXRPC_PORTTYPE_NAME = "wsdl.portName";
    public static final String FAULT_ON_NO_RESPONSE = "call.FaultOnNoResponse";
    public static final String CHECK_MUST_UNDERSTAND = "call.CheckMustUnderstand";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT = "attachment_encapsulation_format";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_MIME = "axis.attachment.style.mime";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_DIME = "axis.attachment.style.dime";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "axis.connection.timeout";
    public static final String STREAMING_PROPERTY = "axis.streaming";
    protected static final String ONE_WAY = "axis.one.way";
    private static Hashtable transports = new Hashtable();
    static ParameterMode[] modes = new ParameterMode[]{null, ParameterMode.IN, ParameterMode.OUT, ParameterMode.INOUT};
    private boolean encodingStyleExplicitlySet = false;
    private boolean useExplicitlySet = false;
    private SOAPService myService = null;
    protected Vector attachmentParts = new Vector();
    private boolean isNeverInvoked = true;
    private static ArrayList propertyNames;
    private static ArrayList transportPackages;

    public Call(Service service) {
        this.service = service;
        AxisEngine axisEngine = service.getEngine();
        this.msgContext = new MessageContext(axisEngine);
        this.myProperties.setParent(axisEngine.getOptions());
        this.maintainSession = service.getMaintainSession();
    }

    public Call(String string) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(string));
    }

    public Call(URL uRL) {
        this(new Service());
        this.setTargetEndpointAddress(uRL);
    }

    public void setProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            this.verifyStringProperty(string, object);
            this.setUsername((String)object);
        } else if (string.equals("javax.xml.rpc.security.auth.password")) {
            this.verifyStringProperty(string, object);
            this.setPassword((String)object);
        } else if (string.equals("javax.xml.rpc.session.maintain")) {
            this.verifyBooleanProperty(string, object);
            this.setMaintainSession((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.operation.style")) {
            this.verifyStringProperty(string, object);
            this.setOperationStyle((String)object);
            if (this.getOperationStyle() == Style.DOCUMENT || this.getOperationStyle() == Style.WRAPPED) {
                this.setOperationUse("literal");
            } else if (this.getOperationStyle() == Style.RPC) {
                this.setOperationUse("encoded");
            }
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            this.verifyBooleanProperty(string, object);
            this.setUseSOAPAction((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            this.verifyStringProperty(string, object);
            this.setSOAPActionURI((String)object);
        } else if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            this.verifyStringProperty(string, object);
            this.setEncodingStyle((String)object);
        } else if (string.equals("javax.xml.rpc.service.endpoint.address")) {
            this.verifyStringProperty(string, object);
            this.setTargetEndpointAddress((String)object);
        } else if (string.equals(TRANSPORT_NAME)) {
            this.verifyStringProperty(string, object);
            this.transportName = (String)object;
            if (this.transport != null) {
                this.transport.setTransportName((String)object);
            }
        } else if (string.equals(ATTACHMENT_ENCAPSULATION_FORMAT)) {
            this.verifyStringProperty(string, object);
            if (!object.equals(ATTACHMENT_ENCAPSULATION_FORMAT_MIME) && !object.equals(ATTACHMENT_ENCAPSULATION_FORMAT_DIME)) {
                throw new JAXRPCException(Messages.getMessage("badattachmenttypeerr", new String[]{(String)object, "axis.attachment.style.mime axis.attachment.style.dime"}));
            }
        } else if (string.equals(CONNECTION_TIMEOUT_PROPERTY)) {
            this.verifyIntegerProperty(string, object);
            this.setTimeout((Integer)object);
        } else if (string.equals(STREAMING_PROPERTY)) {
            this.verifyBooleanProperty(string, object);
            this.setStreaming((Boolean)object);
        } else if (string.equals(CHARACTER_SET_ENCODING)) {
            this.verifyStringProperty(string, object);
        } else if (string.startsWith("java.") || string.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        this.myProperties.put(string, object);
    }

    private void verifyStringProperty(String string, Object object) {
        if (!(object instanceof String)) {
            throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
        }
    }

    private void verifyBooleanProperty(String string, Object object) {
        if (!(object instanceof Boolean)) {
            throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
        }
    }

    private void verifyIntegerProperty(String string, Object object) {
        if (!(object instanceof Integer)) {
            throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Integer", object.getClass().getName()}));
        }
    }

    public Object getProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        return this.myProperties.get(string);
    }

    public void removeProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        this.myProperties.remove(string);
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String string) {
        return propertyNames.contains(string) || !string.startsWith("java.") && !string.startsWith("javax.");
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public void setOperationStyle(String string) {
        Style style = Style.getStyle(string, Style.DEFAULT);
        this.setOperationStyle(style);
    }

    public void setOperationStyle(Style style) {
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        this.operation.setStyle(style);
        if (!this.useExplicitlySet && style != Style.RPC) {
            this.operation.setUse(Use.LITERAL);
        }
        if (!this.encodingStyleExplicitlySet) {
            String string = "";
            if (style == Style.RPC) {
                string = this.msgContext.getSOAPConstants().getEncodingURI();
            }
            this.msgContext.setEncodingStyle(string);
        }
    }

    public Style getOperationStyle() {
        if (this.operation != null) {
            return this.operation.getStyle();
        }
        return Style.DEFAULT;
    }

    public void setOperationUse(String string) {
        Use use = Use.getUse(string, Use.DEFAULT);
        this.setOperationUse(use);
    }

    public void setOperationUse(Use use) {
        this.useExplicitlySet = true;
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        this.operation.setUse(use);
        if (!this.encodingStyleExplicitlySet) {
            String string = "";
            if (use == Use.ENCODED) {
                string = this.msgContext.getSOAPConstants().getEncodingURI();
            }
            this.msgContext.setEncodingStyle(string);
        }
    }

    public Use getOperationUse() {
        if (this.operation != null) {
            return this.operation.getUse();
        }
        return Use.DEFAULT;
    }

    public void setUseSOAPAction(boolean bl) {
        this.useSOAPAction = bl;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String string) {
        this.useSOAPAction = true;
        this.SOAPActionURI = string;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String string) {
        this.encodingStyleExplicitlySet = true;
        this.msgContext.setEncodingStyle(string);
    }

    public String getEncodingStyle() {
        return this.msgContext.getEncodingStyle();
    }

    public void setTargetEndpointAddress(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JAXRPCException(malformedURLException);
        }
        this.setTargetEndpointAddress(uRL);
    }

    public void setTargetEndpointAddress(URL uRL) {
        try {
            URL uRL2;
            String string;
            Object object;
            if (uRL == null) {
                this.setTransport(null);
                return;
            }
            String string2 = uRL.getProtocol();
            if (this.transport != null && (object = this.transport.getUrl()) != null && !((String)object).equals("") && string2.equals(string = (uRL2 = new URL((String)object)).getProtocol())) {
                this.transport.setUrl(uRL.toString());
                return;
            }
            object = this.service.getTransportForURL(uRL);
            if (object != null) {
                this.setTransport((Transport)object);
            } else {
                object = this.getTransportForProtocol(string2);
                if (object == null) {
                    throw new AxisFault("Call.setTargetEndpointAddress", Messages.getMessage("noTransport01", string2), null, null);
                }
                ((Transport)object).setUrl(uRL.toString());
                this.setTransport((Transport)object);
                this.service.registerTransportForURL(uRL, (Transport)object);
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
        }
    }

    public String getTargetEndpointAddress() {
        try {
            if (this.transport == null) {
                return null;
            }
            return this.transport.getUrl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public boolean getStreaming() {
        return this.useStreaming;
    }

    public void setStreaming(boolean bl) {
        this.useStreaming = bl;
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this.parmAndRetReq;
    }

    public void addParameter(QName qName, QName qName2, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName2);
        }
        this.addParameter(qName, qName2, clazz, parameterMode);
    }

    public void addParameter(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        ParameterDesc parameterDesc = new ParameterDesc();
        byte by = 1;
        if (parameterMode == ParameterMode.INOUT) {
            by = 3;
            parameterDesc.setIsReturn(true);
        } else if (parameterMode == ParameterMode.OUT) {
            by = 2;
            parameterDesc.setIsReturn(true);
        }
        parameterDesc.setMode(by);
        parameterDesc.setQName(new QName(qName.getNamespaceURI(), Utils.getLastLocalPart(qName.getLocalPart())));
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        this.operation.addParameter(parameterDesc);
        this.parmAndRetReq = true;
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName);
        }
        this.addParameter(new QName("", string), qName, clazz, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.addParameter(new QName("", string), qName, clazz, parameterMode);
    }

    public void addParameterAsHeader(QName qName, QName qName2, ParameterMode parameterMode, ParameterMode parameterMode2) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName2);
        }
        this.addParameterAsHeader(qName, qName2, clazz, parameterMode, parameterMode2);
    }

    public void addParameterAsHeader(QName qName, QName qName2, Class clazz, ParameterMode parameterMode, ParameterMode parameterMode2) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setQName(new QName(qName.getNamespaceURI(), Utils.getLastLocalPart(qName.getLocalPart())));
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        if (parameterMode == ParameterMode.IN) {
            parameterDesc.setMode((byte)1);
        } else if (parameterMode == ParameterMode.INOUT) {
            parameterDesc.setMode((byte)3);
        } else if (parameterMode == ParameterMode.OUT) {
            parameterDesc.setMode((byte)2);
        }
        if (parameterMode2 == ParameterMode.IN) {
            parameterDesc.setInHeader(true);
        } else if (parameterMode2 == ParameterMode.INOUT) {
            parameterDesc.setInHeader(true);
            parameterDesc.setOutHeader(true);
        } else if (parameterMode2 == ParameterMode.OUT) {
            parameterDesc.setOutHeader(true);
        }
        this.operation.addParameter(parameterDesc);
        this.parmAndRetReq = true;
    }

    public QName getParameterTypeByName(String string) {
        QName qName = new QName("", string);
        return this.getParameterTypeByQName(qName);
    }

    public QName getParameterTypeByQName(QName qName) {
        ParameterDesc parameterDesc = this.operation.getParamByQName(qName);
        if (parameterDesc != null) {
            return parameterDesc.getTypeQName();
        }
        return null;
    }

    public void setReturnType(QName qName) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        this.operation.setReturnType(qName);
        TypeMapping typeMapping = this.getTypeMapping();
        this.operation.setReturnClass(typeMapping.getClassForQName(qName));
        this.parmAndRetReq = true;
    }

    public void setReturnType(QName qName, Class clazz) {
        this.setReturnType(qName);
        this.operation.setReturnClass(clazz);
    }

    public void setReturnTypeAsHeader(QName qName) {
        this.setReturnType(qName);
        this.operation.setReturnHeader(true);
    }

    public void setReturnTypeAsHeader(QName qName, Class clazz) {
        this.setReturnType(qName, clazz);
        this.operation.setReturnHeader(true);
    }

    public QName getReturnType() {
        if (this.operation != null) {
            return this.operation.getReturnType();
        }
        return null;
    }

    public void setReturnQName(QName qName) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        this.operation.setReturnQName(qName);
    }

    public void setReturnClass(Class clazz) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        this.operation.setReturnClass(clazz);
        TypeMapping typeMapping = this.getTypeMapping();
        this.operation.setReturnType(typeMapping.getTypeQName(clazz));
        this.parmAndRetReq = true;
    }

    public void removeAllParameters() {
        this.operation = new OperationDesc();
        this.operationSetManually = false;
        this.parmAndRetReq = true;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        this.operationName = qName;
    }

    public void setOperationName(String string) {
        this.operationName = new QName(string);
    }

    public void setOperation(String string) {
        Style style;
        Serializable serializable;
        Object object;
        Object object22;
        Object object3;
        Object object4;
        BindingInput bindingInput;
        Object object5;
        Object object6;
        Object object7;
        if (this.service == null) {
            throw new JAXRPCException(Messages.getMessage("noService04"));
        }
        this.setOperationName(string);
        this.setEncodingStyle(null);
        this.setReturnType(null);
        this.removeAllParameters();
        javax.wsdl.Service service = this.service.getWSDLService();
        if (service == null) {
            return;
        }
        Port port = service.getPort(this.portName.getLocalPart());
        if (port == null) {
            throw new JAXRPCException(Messages.getMessage("noPort00", "" + this.portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + this.portName));
        }
        this.setPortTypeName(portType.getQName());
        List list = portType.getOperations();
        if (list == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        Operation operation = null;
        for (int i = 0; i < list.size() && !string.equals((operation = (Operation)list.get(i)).getName()); ++i) {
            operation = null;
        }
        if (operation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        List list2 = port.getExtensibilityElements();
        String string2 = null;
        BindingOperation bindingOperation = binding.getBindingOperation(string, null, null);
        if (bindingOperation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation02", string));
        }
        list2 = bindingOperation.getExtensibilityElements();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            object7 = list2.get(i);
            if (!(object7 instanceof SOAPOperation)) continue;
            object6 = (SOAPOperation)object7;
            string2 = ((SOAPOperation)object7).getStyle();
            object5 = object6.getSoapActionURI();
            if (object5 != null) {
                this.setUseSOAPAction(true);
                this.setSOAPActionURI((String)object5);
                break;
            }
            this.setUseSOAPAction(false);
            this.setSOAPActionURI(null);
            break;
        }
        if ((bindingInput = bindingOperation.getBindingInput()) != null) {
            list2 = bindingInput.getExtensibilityElements();
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                object6 = list2.get(i);
                if (object6 instanceof MIMEMultipartRelated) {
                    object5 = (MIMEMultipartRelated)object6;
                    object4 = null;
                    List list3 = object5.getMIMEParts();
                    for (int j = 0; list3 != null && j < list3.size() && object4 == null; ++j) {
                        object3 = (MIMEPart)list3.get(j);
                        object22 = object3.getExtensibilityElements();
                        for (int k = 0; object22 != null && k < object22.size() && object4 == null; ++k) {
                            object4 = object22.get(k);
                            if (object4 instanceof SOAPBody) continue;
                            object4 = null;
                        }
                    }
                    if (null != object4) {
                        object6 = object4;
                    }
                }
                if (!(object6 instanceof SOAPBody)) continue;
                object5 = (SOAPBody)object6;
                list2 = object5.getEncodingStyles();
                if (list2 != null && list2.size() > 0) {
                    this.setEncodingStyle((String)list2.get(0));
                }
                if ((object4 = object5.getNamespaceURI()) == null || ((String)object4).equals("")) break;
                this.setOperationName(new QName((String)object4, string));
                break;
            }
        }
        object7 = this.getService();
        object6 = ((Service)object7).getWSDLParser().getSymbolTable();
        object5 = ((SymbolTable)object6).getBindingEntry(binding.getQName());
        object4 = ((BindingEntry)object5).getParameters(bindingOperation.getOperation());
        for (int i = 0; i < ((Parameters)object4).list.size(); ++i) {
            Parameter parameter = (Parameter)((Parameters)object4).list.get(i);
            object3 = Utils.getXSIType(parameter);
            object22 = modes[parameter.getMode()];
            if (parameter.isInHeader() || parameter.isOutHeader()) {
                this.addParameterAsHeader(parameter.getQName(), (QName)object3, (ParameterMode)object22, (ParameterMode)object22);
                continue;
            }
            this.addParameter(parameter.getQName(), (QName)object3, (ParameterMode)object22);
        }
        HashMap hashMap = ((BindingEntry)object5).getFaults();
        ArrayList arrayList = (ArrayList)hashMap.get(bindingOperation);
        if (arrayList == null) {
            return;
        }
        for (Object object22 : arrayList) {
            QName qName = ((FaultInfo)object22).getQName();
            ((FaultInfo)object22).getMessage();
            if (qName == null) continue;
            object = ((FaultInfo)object22).getXMLType();
            serializable = this.getTypeMapping().getClassForQName((QName)object);
            if (serializable != null) {
                this.addFault(qName, (Class)serializable, (QName)object, true);
                continue;
            }
            log.debug(Messages.getMessage("clientNoTypemapping", ((QName)object).toString()));
        }
        if (((Parameters)object4).returnParam != null) {
            object3 = Utils.getXSIType(((Parameters)object4).returnParam);
            object22 = ((Parameters)object4).returnParam.getQName();
            String string3 = null;
            string3 = ((Parameters)object4).returnParam.getMIMEInfo() != null ? "javax.activation.DataHandler" : ((Parameters)object4).returnParam.getType().getName();
            string3 = string3 == null ? "" : string3 + ".class";
            this.setReturnType((QName)object3);
            try {
                object = ClassUtils.forName(string3);
                this.setReturnClass((Class)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.debug(Messages.getMessage("clientNoReturnClass", string3));
            }
            this.setReturnQName((QName)object22);
        } else {
            this.setReturnType(XMLType.AXIS_VOID);
        }
        boolean bl = Utils.hasMIME((BindingEntry)object5, bindingOperation);
        object22 = ((BindingEntry)object5).getInputBodyType(bindingOperation.getOperation());
        this.setOperationUse((Use)object22);
        if (object22 == Use.LITERAL) {
            this.setEncodingStyle(null);
            this.setProperty(SEND_TYPE_ATTR, Boolean.FALSE);
        }
        if (bl || object22 == Use.LITERAL) {
            this.setProperty("sendMultiRefs", Boolean.FALSE);
        }
        if ((style = Style.getStyle(string2, ((BindingEntry)object5).getBindingStyle())) == Style.DOCUMENT && ((SymbolTable)object6).isWrapped()) {
            style = Style.WRAPPED;
        }
        this.setOperationStyle(style);
        if (style == Style.WRAPPED) {
            object = bindingOperation.getOperation().getInput().getMessage().getParts();
            serializable = (Part)object.values().iterator().next();
            QName qName = serializable.getElementName();
            this.setOperationName(qName);
        } else {
            object = Utils.getOperationQName(bindingOperation, (BindingEntry)object5, (SymbolTable)object6);
            if (object != null) {
                this.setOperationName((QName)object);
            }
        }
        this.parmAndRetReq = false;
    }

    public void setOperation(QName qName, String string) {
        this.setOperation(qName, new QName(string));
    }

    public void setOperation(QName qName, QName qName2) {
        if (this.service == null) {
            throw new JAXRPCException(Messages.getMessage("noService04"));
        }
        this.setPortName(qName);
        this.setOperationName(qName2);
        this.setReturnType(null);
        this.removeAllParameters();
        javax.wsdl.Service service = this.service.getWSDLService();
        if (service == null) {
            return;
        }
        this.setTargetEndpointAddress((URL)null);
        Port port = service.getPort(qName.getLocalPart());
        if (port == null) {
            throw new JAXRPCException(Messages.getMessage("noPort00", "" + qName));
        }
        List list = port.getExtensibilityElements();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof SOAPAddress)) continue;
            try {
                SOAPAddress sOAPAddress = (SOAPAddress)e;
                URL uRL = new URL(sOAPAddress.getLocationURI());
                this.setTargetEndpointAddress(uRL);
                continue;
            }
            catch (Exception exception) {
                throw new JAXRPCException(Messages.getMessage("cantSetURI00", "" + exception));
            }
        }
        this.setOperation(qName2.getLocalPart());
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public QName getPortTypeName() {
        return this.portTypeName == null ? new QName("") : this.portTypeName;
    }

    public void setPortTypeName(QName qName) {
        this.portTypeName = qName;
    }

    public void setSOAPVersion(SOAPConstants sOAPConstants) {
        this.msgContext.setSOAPConstants(sOAPConstants);
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        QName qName2 = this.operationName;
        this.operationName = qName;
        try {
            return this.invoke(objectArray);
        }
        catch (AxisFault axisFault) {
            this.operationName = qName2;
            if (axisFault.detail != null && axisFault.detail instanceof RemoteException) {
                throw (RemoteException)axisFault.detail;
            }
            throw axisFault;
        }
        catch (RemoteException remoteException) {
            this.operationName = qName2;
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            this.operationName = qName2;
            throw runtimeException;
        }
        catch (Error error) {
            this.operationName = qName2;
            throw error;
        }
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        int n;
        long l = 0L;
        long l2 = 0L;
        if (tlog.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        SOAPEnvelope sOAPEnvelope = null;
        for (n = 0; objectArray != null && n < objectArray.length && objectArray[n] instanceof SOAPBodyElement; ++n) {
        }
        if (objectArray != null && objectArray.length > 0 && n == objectArray.length) {
            this.isMsg = true;
            sOAPEnvelope = new SOAPEnvelope(this.msgContext.getSOAPConstants(), this.msgContext.getSchemaVersion());
            for (n = 0; n < objectArray.length; ++n) {
                sOAPEnvelope.addBodyElement((SOAPBodyElement)objectArray[n]);
            }
            Message message = new Message(sOAPEnvelope);
            this.setRequestMessage(message);
            this.invoke();
            message = this.msgContext.getResponseMessage();
            if (message == null) {
                if (this.msgContext.isPropertyTrue(FAULT_ON_NO_RESPONSE, false)) {
                    throw new AxisFault(Messages.getMessage("nullResponse00"));
                }
                return null;
            }
            sOAPEnvelope = message.getSOAPEnvelope();
            return sOAPEnvelope.getBodyElements();
        }
        if (this.operationName == null) {
            throw new AxisFault(Messages.getMessage("noOperation00"));
        }
        try {
            Object object = this.invoke(this.operationName.getNamespaceURI(), this.operationName.getLocalPart(), objectArray);
            if (tlog.isDebugEnabled()) {
                l2 = System.currentTimeMillis();
                tlog.debug("axis.Call.invoke: " + (l2 - l) + " " + this.operationName);
            }
            return object;
        }
        catch (AxisFault axisFault) {
            if (axisFault.detail != null && axisFault.detail instanceof RemoteException) {
                throw (RemoteException)axisFault.detail;
            }
            throw axisFault;
        }
        catch (Exception exception) {
            entLog.debug(Messages.getMessage("toAxisFault00"), exception);
            throw AxisFault.makeFault(exception);
        }
    }

    public void invokeOneWay(Object[] objectArray) {
        try {
            this.invokeOneWay = true;
            this.invoke(objectArray);
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception.toString());
        }
        finally {
            this.invokeOneWay = false;
        }
    }

    public SOAPEnvelope invoke(Message message) throws AxisFault {
        try {
            this.setRequestMessage(message);
            this.invoke();
            message = this.msgContext.getResponseMessage();
            if (message == null) {
                if (this.msgContext.isPropertyTrue(FAULT_ON_NO_RESPONSE, false)) {
                    throw new AxisFault(Messages.getMessage("nullResponse00"));
                }
                return null;
            }
            SOAPEnvelope sOAPEnvelope = null;
            sOAPEnvelope = message.getSOAPEnvelope();
            return sOAPEnvelope;
        }
        catch (Exception exception) {
            if (exception instanceof AxisFault) {
                throw (AxisFault)exception;
            }
            entLog.debug(Messages.getMessage("toAxisFault00"), exception);
            throw new AxisFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope sOAPEnvelope) throws AxisFault {
        try {
            Message message = new Message(sOAPEnvelope);
            if (this.getProperty(CHARACTER_SET_ENCODING) != null) {
                message.setProperty(CHARACTER_SET_ENCODING, this.getProperty(CHARACTER_SET_ENCODING));
            } else if (this.msgContext.getProperty(CHARACTER_SET_ENCODING) != null) {
                message.setProperty(CHARACTER_SET_ENCODING, this.msgContext.getProperty(CHARACTER_SET_ENCODING));
            }
            this.setRequestMessage(message);
            this.invoke();
            message = this.msgContext.getResponseMessage();
            if (message == null) {
                if (this.msgContext.isPropertyTrue(FAULT_ON_NO_RESPONSE, false)) {
                    throw new AxisFault(Messages.getMessage("nullResponse00"));
                }
                return null;
            }
            return message.getSOAPEnvelope();
        }
        catch (Exception exception) {
            if (exception instanceof AxisFault) {
                throw (AxisFault)exception;
            }
            entLog.debug(Messages.getMessage("toAxisFault00"), exception);
            throw AxisFault.makeFault(exception);
        }
    }

    public static void setTransportForProtocol(String string, Class clazz) {
        if (!Transport.class.isAssignableFrom(clazz)) {
            throw new InternalException(clazz.toString());
        }
        transports.put(string, clazz);
    }

    public static synchronized void initialize() {
        Call.addTransportPackage("org.apache.axis.transport");
        Call.setTransportForProtocol("java", JavaTransport.class);
        Call.setTransportForProtocol("local", LocalTransport.class);
        Call.setTransportForProtocol("http", HTTPTransport.class);
        Call.setTransportForProtocol("https", HTTPTransport.class);
    }

    public static synchronized void addTransportPackage(String string) {
        CharSequence charSequence;
        if (transportPackages == null) {
            transportPackages = new ArrayList();
            charSequence = AxisProperties.getProperty(TRANSPORT_PROPERTY);
            if (charSequence != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    transportPackages.add(stringTokenizer.nextToken());
                }
            }
        }
        if (transportPackages.contains(string)) {
            return;
        }
        transportPackages.add(string);
        charSequence = new StringBuffer();
        for (String string2 : transportPackages) {
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append('|');
        }
        System.setProperty(TRANSPORT_PROPERTY, ((StringBuffer)charSequence).toString());
    }

    private Object[] getParamList(Object[] objectArray) {
        int n = 0;
        if (log.isDebugEnabled()) {
            log.debug("operation=" + this.operation);
            if (this.operation != null) {
                log.debug("operation.getNumParams()=" + this.operation.getNumParams());
            }
        }
        if (this.operation == null || this.operation.getNumParams() == 0) {
            return objectArray;
        }
        n = this.operation.getNumInParams();
        if (objectArray == null || n != objectArray.length) {
            throw new JAXRPCException(Messages.getMessage("parmMismatch00", objectArray == null ? "no params" : "" + objectArray.length, "" + n));
        }
        log.debug("getParamList number of params: " + objectArray.length);
        Vector<RPCParam> vector = new Vector<RPCParam>();
        int n2 = 0;
        ArrayList arrayList = this.operation.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            if (parameterDesc.getMode() == 2) continue;
            QName qName = parameterDesc.getQName();
            RPCParam rPCParam = null;
            rPCParam = (object = objectArray[n2++]) instanceof RPCParam ? (RPCParam)object : new RPCParam(qName.getNamespaceURI(), qName.getLocalPart(), object);
            rPCParam.setParamDesc(parameterDesc);
            if (parameterDesc.isInHeader()) {
                this.addHeader(new RPCHeaderParam(rPCParam));
                continue;
            }
            vector.add(rPCParam);
        }
        return vector.toArray();
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("transport00", "" + this.transport));
        }
    }

    public Transport getTransportForProtocol(String string) {
        Class clazz = (Class)transports.get(string);
        Transport transport = null;
        if (clazz != null) {
            try {
                transport = (Transport)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return transport;
    }

    public void setRequestMessage(Message message) {
        Attachments attachments;
        String string = (String)this.getProperty(ATTACHMENT_ENCAPSULATION_FORMAT);
        if (null != string && null != (attachments = message.getAttachmentsImpl())) {
            if (ATTACHMENT_ENCAPSULATION_FORMAT_MIME.equals(string)) {
                attachments.setSendType(2);
            } else if (ATTACHMENT_ENCAPSULATION_FORMAT_DIME.equals(string)) {
                attachments.setSendType(3);
            }
        }
        if (null != this.attachmentParts && !this.attachmentParts.isEmpty()) {
            try {
                attachments = message.getAttachmentsImpl();
                if (null == attachments) {
                    throw new RuntimeException(Messages.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(this.attachmentParts);
            }
            catch (AxisFault axisFault) {
                log.info(Messages.getMessage("axisFault00"), axisFault);
                throw new RuntimeException(axisFault.getMessage());
            }
        }
        this.msgContext.setRequestMessage(message);
        this.attachmentParts.clear();
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(sOAPHeaderElement);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    public TypeMapping getTypeMapping() {
        TypeMappingRegistry typeMappingRegistry = this.msgContext.getTypeMappingRegistry();
        return typeMappingRegistry.getOrMakeTypeMapping(this.getEncodingStyle());
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
        this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, boolean bl) {
        TypeMapping typeMapping = this.getTypeMapping();
        if (!bl && typeMapping.isRegistered(clazz, qName)) {
            return;
        }
        typeMapping.register(clazz, qName, serializerFactory, deserializerFactory);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3) {
        this.registerTypeMapping(clazz, qName, clazz2, clazz3, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3, boolean bl) {
        SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(clazz2, clazz, qName);
        DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(clazz3, clazz, qName);
        if (serializerFactory != null || deserializerFactory != null) {
            this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, bl);
        }
    }

    public Object invoke(String string, String string2, Object[] objectArray) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Call::invoke(ns, meth, args)");
        }
        if (this.getReturnType() != null && objectArray != null && objectArray.length != 0 && this.operation.getNumParams() == 0) {
            throw new AxisFault(Messages.getMessage("mustSpecifyParms"));
        }
        RPCElement rPCElement = new RPCElement(string, string2, this.getParamList(objectArray));
        Object object = this.invoke(rPCElement);
        if (log.isDebugEnabled()) {
            log.debug("Exit: Call::invoke(ns, meth, args)");
        }
        return object;
    }

    public Object invoke(String string, Object[] objectArray) throws AxisFault {
        return this.invoke("", string, objectArray);
    }

    public Object invoke(RPCElement rPCElement) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Call::invoke(RPCElement)");
        }
        if (!this.invokeOneWay && this.operation != null && this.operation.getNumParams() > 0 && this.getReturnType() == null) {
            log.error(Messages.getMessage("mustSpecifyReturnType"));
        }
        SOAPEnvelope sOAPEnvelope = new SOAPEnvelope(this.msgContext.getSOAPConstants(), this.msgContext.getSchemaVersion());
        SOAPEnvelope sOAPEnvelope2 = null;
        Message message = new Message(sOAPEnvelope);
        Message message2 = null;
        Vector vector = null;
        Object object = null;
        this.outParams = new HashMap();
        this.outParamsList = new ArrayList();
        try {
            rPCElement.setEncodingStyle(this.getEncodingStyle());
            this.setRequestMessage(message);
            sOAPEnvelope.addBodyElement(rPCElement);
            sOAPEnvelope.setMessageType("request");
            this.invoke();
        }
        catch (Exception exception) {
            entLog.debug(Messages.getMessage("toAxisFault00"), exception);
            throw AxisFault.makeFault(exception);
        }
        message2 = this.msgContext.getResponseMessage();
        if (message2 == null) {
            if (this.msgContext.isPropertyTrue(FAULT_ON_NO_RESPONSE, false)) {
                throw new AxisFault(Messages.getMessage("nullResponse00"));
            }
            return null;
        }
        sOAPEnvelope2 = message2.getSOAPEnvelope();
        SOAPBodyElement sOAPBodyElement = sOAPEnvelope2.getFirstBody();
        if (sOAPBodyElement == null) {
            return null;
        }
        if (sOAPBodyElement instanceof RPCElement) {
            try {
                vector = ((RPCElement)sOAPBodyElement).getParams();
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("exception00"), exception);
                throw AxisFault.makeFault(exception);
            }
            if (vector != null && vector.size() > 0) {
                Serializable serializable;
                Serializable serializable2;
                int n = 0;
                boolean bl = false;
                QName qName = null;
                if (this.operation != null) {
                    qName = this.operation.getReturnQName();
                }
                if (!XMLType.AXIS_VOID.equals(this.getReturnType())) {
                    if (qName == null) {
                        RPCParam rPCParam = (RPCParam)vector.get(0);
                        object = rPCParam.getObjectValue();
                        n = 1;
                    } else {
                        bl = true;
                    }
                }
                for (int i = n; i < vector.size(); ++i) {
                    serializable2 = (RPCParam)vector.get(i);
                    serializable = this.getJavaTypeForQName(((MessageElement)serializable2).getQName());
                    Object object2 = ((RPCParam)serializable2).getObjectValue();
                    if (serializable != null && object2 != null && !serializable.isAssignableFrom(object2.getClass())) {
                        object2 = JavaUtils.convert(object2, serializable);
                    }
                    if (bl && qName.equals(((MessageElement)serializable2).getQName())) {
                        object = object2;
                        bl = false;
                        continue;
                    }
                    this.outParams.put(((MessageElement)serializable2).getQName(), object2);
                    this.outParamsList.add(object2);
                }
                if (bl) {
                    Iterator iterator = this.outParams.keySet().iterator();
                    while (iterator.hasNext() && bl) {
                        serializable2 = (QName)iterator.next();
                        serializable = this.operation.getOutputParamByQName((QName)serializable2);
                        if (serializable != null) continue;
                        bl = false;
                        object = this.outParams.remove(serializable2);
                    }
                }
                if (bl) {
                    String string = qName.toString();
                    throw new AxisFault(Messages.getMessage("noReturnParam", string));
                }
            }
        } else {
            try {
                object = sOAPBodyElement.getValueAsType(this.getReturnType());
            }
            catch (Exception exception) {
                object = sOAPBodyElement;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Call::invoke(RPCElement)");
        }
        if (this.operation != null && this.operation.getReturnClass() != null) {
            object = JavaUtils.convert(object, this.operation.getReturnClass());
        }
        return object;
    }

    private Class getJavaTypeForQName(QName qName) {
        if (this.operation == null) {
            return null;
        }
        ParameterDesc parameterDesc = this.operation.getOutputParamByQName(qName);
        return parameterDesc == null ? null : parameterDesc.getJavaType();
    }

    public void setOption(String string, Object object) {
        this.service.getEngine().setOption(string, object);
    }

    public void invoke() throws AxisFault {
        Message message;
        if (log.isDebugEnabled()) {
            log.debug("Enter: Call::invoke()");
        }
        this.isNeverInvoked = false;
        Message message2 = null;
        SOAPEnvelope sOAPEnvelope = null;
        this.msgContext.reset();
        this.msgContext.setResponseMessage(null);
        this.msgContext.setProperty("call_object", this);
        this.msgContext.setProperty("wsdl.service", this.service);
        this.msgContext.setProperty("wsdl.portName", this.getPortName());
        if (this.isMsg) {
            this.msgContext.setProperty("isMsg", "true");
        }
        if (this.username != null) {
            this.msgContext.setUsername(this.username);
        }
        if (this.password != null) {
            this.msgContext.setPassword(this.password);
        }
        this.msgContext.setMaintainSession(this.maintainSession);
        if (this.operation != null) {
            this.msgContext.setOperation(this.operation);
            this.operation.setStyle(this.getOperationStyle());
            this.operation.setUse(this.getOperationUse());
        }
        if (this.useSOAPAction) {
            this.msgContext.setUseSOAPAction(true);
        }
        if (this.SOAPActionURI != null) {
            this.msgContext.setSOAPActionURI(this.SOAPActionURI);
        } else {
            this.msgContext.setSOAPActionURI(null);
        }
        if (this.timeout != null) {
            this.msgContext.setTimeout(this.timeout);
        }
        this.msgContext.setHighFidelity(!this.useStreaming);
        if (this.myService != null) {
            this.msgContext.setService(this.myService);
        } else if (this.portName != null) {
            this.msgContext.setTargetService(this.portName.getLocalPart());
        } else {
            SOAPBodyElement sOAPBodyElement;
            message2 = this.msgContext.getRequestMessage();
            boolean bl = ((SOAPPart)message2.getSOAPPart()).isBodyStream();
            if (message2 != null && !bl && (sOAPBodyElement = (sOAPEnvelope = message2.getSOAPEnvelope()).getFirstBody()) != null) {
                if (sOAPBodyElement.getNamespaceURI() == null) {
                    throw new AxisFault("Call.invoke", Messages.getMessage("cantInvoke00", sOAPBodyElement.getName()), null, null);
                }
                this.msgContext.setTargetService(sOAPBodyElement.getNamespaceURI());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("targetService", this.msgContext.getTargetService()));
        }
        if ((message = this.msgContext.getRequestMessage()) != null) {
            try {
                this.msgContext.setProperty(CHARACTER_SET_ENCODING, message.getProperty(CHARACTER_SET_ENCODING));
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            if (this.myHeaders != null) {
                sOAPEnvelope = message.getSOAPEnvelope();
                for (int i = 0; this.myHeaders != null && i < this.myHeaders.size(); ++i) {
                    sOAPEnvelope.addHeader((SOAPHeaderElement)this.myHeaders.get(i));
                }
            }
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(this.msgContext, this, this.service.getEngine());
        } else {
            this.msgContext.setTransportName(this.transportName);
        }
        SOAPService sOAPService = this.msgContext.getService();
        if (sOAPService != null) {
            sOAPService.setPropertyParent(this.myProperties);
        } else {
            this.msgContext.setPropertyParent(this.myProperties);
        }
        if (log.isDebugEnabled()) {
            StringWriter stringWriter = new StringWriter();
            try {
                SerializationContext serializationContext = new SerializationContext(stringWriter, this.msgContext);
                message.getSOAPEnvelope().output(serializationContext);
                stringWriter.close();
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            finally {
                log.debug(stringWriter.getBuffer().toString());
            }
        }
        if (!this.invokeOneWay) {
            this.invokeEngine(this.msgContext);
        } else {
            this.invokeEngineOneWay(this.msgContext);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Call::invoke()");
        }
    }

    private void invokeEngine(MessageContext messageContext) throws AxisFault {
        Message message;
        this.service.getEngine().invoke(messageContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(messageContext);
        }
        if ((message = messageContext.getResponseMessage()) == null) {
            if (messageContext.isPropertyTrue(FAULT_ON_NO_RESPONSE, false)) {
                throw new AxisFault(Messages.getMessage("nullResponse00"));
            }
            return;
        }
        message.setMessageType("response");
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        SOAPBodyElement sOAPBodyElement = sOAPEnvelope.getFirstBody();
        if (sOAPBodyElement instanceof SOAPFault && (this.operation == null || this.operation.getReturnClass() == null || this.operation.getReturnClass() != SOAPMessage.class)) {
            throw ((SOAPFault)sOAPBodyElement).getFault();
        }
    }

    private void invokeEngineOneWay(final MessageContext messageContext) {
        Runnable runnable = new Runnable(){

            public void run() {
                messageContext.setProperty(Call.ONE_WAY, Boolean.TRUE);
                try {
                    Call.this.service.getEngine().invoke(messageContext);
                }
                catch (AxisFault axisFault) {
                    log.debug(Messages.getMessage("exceptionPrinting"), axisFault);
                }
                messageContext.removeProperty(Call.ONE_WAY);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public Map getOutputParams() {
        if (this.isNeverInvoked) {
            throw new JAXRPCException(Messages.getMessage("outputParamsUnavailable"));
        }
        return this.outParams;
    }

    public List getOutputValues() {
        if (this.isNeverInvoked) {
            throw new JAXRPCException(Messages.getMessage("outputParamsUnavailable"));
        }
        return this.outParamsList;
    }

    public Service getService() {
        return this.service;
    }

    public void setSOAPService(SOAPService sOAPService) {
        this.myService = sOAPService;
        if (sOAPService != null) {
            sOAPService.setEngine(this.service.getAxisClient());
            sOAPService.setPropertyParent(this.myProperties);
        }
    }

    public void setClientHandlers(Handler handler, Handler handler2) {
        this.setSOAPService(new SOAPService(handler, null, handler2));
    }

    public void addAttachmentPart(Object object) {
        this.attachmentParts.add(object);
    }

    public void addFault(QName qName, Class clazz, QName qName2, boolean bl) {
        if (this.operationSetManually) {
            throw new RuntimeException(Messages.getMessage("operationAlreadySet"));
        }
        if (this.operation == null) {
            this.operation = new OperationDesc();
        }
        FaultDesc faultDesc = new FaultDesc();
        faultDesc.setQName(qName);
        faultDesc.setClassName(clazz.getName());
        faultDesc.setXmlType(qName2);
        faultDesc.setComplex(bl);
        this.operation.addFault(faultDesc);
    }

    public void setOperation(OperationDesc operationDesc) {
        this.operation = operationDesc;
        this.operationSetManually = true;
    }

    public OperationDesc getOperation() {
        return this.operation;
    }

    public void clearOperation() {
        this.operation = null;
        this.operationSetManually = false;
    }

    static {
        Call.initialize();
        propertyNames = new ArrayList();
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add("javax.xml.rpc.soap.operation.style");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        propertyNames.add("javax.xml.rpc.service.endpoint.address");
        propertyNames.add(TRANSPORT_NAME);
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        propertyNames.add(CONNECTION_TIMEOUT_PROPERTY);
        propertyNames.add(CHARACTER_SET_ENCODING);
        transportPackages = null;
    }
}

