/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;

public class ServiceFactory
extends javax.xml.rpc.ServiceFactory
implements ObjectFactory {
    public static final String SERVICE_CLASSNAME = "service classname";
    public static final String WSDL_LOCATION = "WSDL location";
    public static final String MAINTAIN_SESSION = "maintain session";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    public static final String SERVICE_IMPLEMENTATION_NAME_PROPERTY = "serviceImplementationName";
    private static final String SERVICE_IMPLEMENTATION_SUFFIX = "Locator";
    private static EngineConfiguration _defaultEngineConfig = null;
    private static ThreadLocal threadDefaultConfig = new ThreadLocal();

    public static void setThreadDefaultConfig(EngineConfiguration engineConfiguration) {
        threadDefaultConfig.set(engineConfiguration);
    }

    private static EngineConfiguration getDefaultEngineConfig() {
        if (_defaultEngineConfig == null) {
            _defaultEngineConfig = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
        }
        return _defaultEngineConfig;
    }

    public static Service getService(Map map) {
        Service service = null;
        InitialContext initialContext = null;
        EngineConfiguration engineConfiguration = (EngineConfiguration)map.get("engineConfig");
        if (engineConfiguration == null) {
            engineConfiguration = (EngineConfiguration)threadDefaultConfig.get();
        }
        if (engineConfiguration == null) {
            engineConfiguration = ServiceFactory.getDefaultEngineConfig();
        }
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (initialContext != null) {
            String string = (String)map.get("jndiName");
            if (string == null) {
                string = "axisServiceName";
            }
            try {
                service = (Service)initialContext.lookup(string);
            }
            catch (NamingException namingException) {
                service = new Service(engineConfiguration);
                try {
                    initialContext.bind(string, (Object)service);
                }
                catch (NamingException namingException2) {}
            }
        } else {
            service = new Service(engineConfiguration);
        }
        return service;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Object var5_5 = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            RefAddr refAddr = reference.get(SERVICE_CLASSNAME);
            Object object2 = null;
            if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                var5_5 = ClassUtils.forName((String)object2).newInstance();
            } else {
                refAddr = reference.get(WSDL_LOCATION);
                if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                    URL uRL = new URL((String)object2);
                    refAddr = reference.get(SERVICE_NAMESPACE);
                    if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                        String string = (String)object2;
                        refAddr = reference.get(SERVICE_LOCAL_PART);
                        if (refAddr != null && (object2 = refAddr.getContent()) instanceof String) {
                            String string2 = (String)object2;
                            QName qName = new QName(string, string2);
                            Class[] classArray = new Class[]{URL.class, QName.class};
                            Object[] objectArray = new Object[]{uRL, qName};
                            Constructor constructor = Service.class.getDeclaredConstructor(classArray);
                            var5_5 = constructor.newInstance(objectArray);
                        }
                    }
                }
            }
            refAddr = reference.get(MAINTAIN_SESSION);
            if (refAddr != null && var5_5 instanceof Service) {
                ((Service)var5_5).setMaintainSession(true);
            }
        }
        return var5_5;
    }

    public javax.xml.rpc.Service createService(URL uRL, QName qName) throws ServiceException {
        return new Service(uRL, qName);
    }

    public javax.xml.rpc.Service createService(QName qName) throws ServiceException {
        return new Service(qName);
    }

    public javax.xml.rpc.Service loadService(Class clazz) throws ServiceException {
        if (clazz == null) {
            throw new IllegalArgumentException(Messages.getMessage("serviceFactoryIllegalServiceInterface"));
        }
        if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
            throw new ServiceException(Messages.getMessage("serviceFactoryServiceInterfaceRequirement", clazz.getName()));
        }
        String string = clazz.getName() + SERVICE_IMPLEMENTATION_SUFFIX;
        Service service = this.createService(string);
        return service;
    }

    public javax.xml.rpc.Service loadService(URL uRL, Class clazz, Properties properties) throws ServiceException {
        if (clazz == null) {
            throw new IllegalArgumentException(Messages.getMessage("serviceFactoryIllegalServiceInterface"));
        }
        if (!javax.xml.rpc.Service.class.isAssignableFrom(clazz)) {
            throw new ServiceException(Messages.getMessage("serviceFactoryServiceInterfaceRequirement", clazz.getName()));
        }
        String string = clazz.getName() + SERVICE_IMPLEMENTATION_SUFFIX;
        Service service = this.createService(string);
        return service;
    }

    public javax.xml.rpc.Service loadService(URL uRL, QName qName, Properties properties) throws ServiceException {
        String string = properties.getProperty(SERVICE_IMPLEMENTATION_NAME_PROPERTY);
        Service service = this.createService(string);
        if (service.getServiceName().equals(qName)) {
            return service;
        }
        throw new ServiceException(Messages.getMessage("serviceFactoryServiceImplementationNotFound", string));
    }

    private Service createService(String string) throws ServiceException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.getMessage("serviceFactoryInvalidServiceName"));
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            if (!Service.class.isAssignableFrom(clazz)) {
                throw new ServiceException(Messages.getMessage("serviceFactoryServiceImplementationRequirement", string));
            }
            Service service = (Service)clazz.newInstance();
            if (service.getServiceName() != null) {
                return service;
            }
            throw new ServiceException(Messages.getMessage("serviceFactoryInvalidServiceName"));
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (Exception exception) {
            throw new ServiceException(exception);
        }
    }
}

