/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.image;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis.components.image.ImageIO;
import org.apache.axis.utils.IOUtils;
import org.apache.axis.utils.Messages;
import sun.awt.image.codec.JPEGImageEncoderImpl;

public class JDK13IO
extends Component
implements ImageIO {
    public void saveImage(String string, Image image, OutputStream outputStream) throws Exception {
        MediaTracker mediaTracker;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForAll();
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
        }
        if (!"image/jpeg".equals(string)) {
            throw new IOException(Messages.getMessage("jpegOnly", string));
        }
        mediaTracker = new JPEGImageEncoderImpl(outputStream);
        mediaTracker.encode(bufferedImage);
    }

    public Image loadImage(InputStream inputStream) throws Exception {
        if (inputStream.available() <= 0) {
            return null;
        }
        byte[] byArray = new byte[inputStream.available()];
        IOUtils.readFully(inputStream, byArray);
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }
}

