/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.jms;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.ClassUtils;

public abstract class BeanVendorAdapter
extends JMSVendorAdapter {
    protected static final String CONNECTION_FACTORY_CLASS = "transport.jms.ConnectionFactoryClass";

    public QueueConnectionFactory getQueueConnectionFactory(HashMap hashMap) throws Exception {
        return (QueueConnectionFactory)this.getConnectionFactory(hashMap);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap hashMap) throws Exception {
        return (TopicConnectionFactory)this.getConnectionFactory(hashMap);
    }

    private ConnectionFactory getConnectionFactory(HashMap hashMap) throws Exception {
        String string = (String)hashMap.get(CONNECTION_FACTORY_CLASS);
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("noCFClass");
        }
        Class clazz = ClassUtils.forName(string);
        ConnectionFactory connectionFactory = (ConnectionFactory)clazz.newInstance();
        this.callSetters(hashMap, clazz, connectionFactory);
        return connectionFactory;
    }

    private void callSetters(HashMap hashMap, Class clazz, ConnectionFactory connectionFactory) throws Exception {
        BeanPropertyDescriptor[] beanPropertyDescriptorArray = BeanUtils.getPd(clazz);
        for (int i = 0; i < beanPropertyDescriptorArray.length; ++i) {
            Object v;
            BeanPropertyDescriptor beanPropertyDescriptor = beanPropertyDescriptorArray[i];
            String string = beanPropertyDescriptor.getName();
            if (!hashMap.containsKey(string) || (v = hashMap.get(string)) == null) continue;
            String string2 = beanPropertyDescriptor.getType().getName();
            if (!v.getClass().getName().equals(string2)) {
                throw new IllegalArgumentException("badType");
            }
            if (!beanPropertyDescriptor.isWriteable()) {
                throw new IllegalArgumentException("notWriteable");
            }
            if (beanPropertyDescriptor.isIndexed()) {
                throw new IllegalArgumentException("noIndexedSupport");
            }
            beanPropertyDescriptor.set(connectionFactory, v);
        }
    }
}

