/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.threadpool;

import java.util.Hashtable;
import java.util.Map;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.i18n.Messages;
import org.apache.commons.logging.Log;

public class ThreadPool {
    protected static Log log = LogFactory.getLog(ThreadPool.class.getName());
    public static final int DEFAULT_MAX_THREADS = 100;
    protected Map threads = new Hashtable();
    protected long threadcount;
    public boolean _shutdown;
    private int maxPoolSize = 100;

    public ThreadPool() {
    }

    public ThreadPool(int n) {
        this.maxPoolSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::cleanup");
        }
        if (!this.isShutdown()) {
            this.safeShutdown();
            this.awaitShutdown();
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.threads.clear();
            this._shutdown = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this._shutdown && this.threadcount == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this._shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWorkerCount() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.threadcount;
        }
    }

    public void addWorker(Runnable runnable) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::addWorker");
        }
        if (this._shutdown || this.threadcount == (long)this.maxPoolSize) {
            throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
        }
        Thread thread = new Thread(runnable);
        this.threads.put(runnable, thread);
        ++this.threadcount;
        thread.start();
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::addWorker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::interruptAll");
        }
        Map map = this.threads;
        synchronized (map) {
            for (Thread thread : this.threads.values()) {
                thread.interrupt();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::interruptAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::shutdown");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this._shutdown = true;
        }
        this.interruptAll();
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeShutdown() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::safeShutdown");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this._shutdown = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::safeShutdown");
        }
    }

    public synchronized void awaitShutdown() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::awaitShutdown");
        }
        if (!this._shutdown) {
            throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
        }
        while (this.threadcount > 0L) {
            this.wait();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::awaitShutdown");
        }
    }

    public synchronized boolean awaitShutdown(long l) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::awaitShutdown");
        }
        if (!this._shutdown) {
            throw new IllegalStateException(Messages.getMessage("illegalStateException00"));
        }
        if (this.threadcount == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: ThreadPool::awaitShutdown");
            }
            return true;
        }
        long l2 = l;
        if (l2 <= 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: ThreadPool::awaitShutdown");
            }
            return false;
        }
        do {
            this.wait(l2);
            if (this.threadcount != 0L) continue;
            if (log.isDebugEnabled()) {
                log.debug("Exit: ThreadPool::awaitShutdown");
            }
            return true;
        } while ((l2 = l - System.currentTimeMillis()) > 0L);
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::awaitShutdown");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workerDone(Runnable runnable, boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: ThreadPool::workerDone");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.threads.remove(runnable);
            if (--this.threadcount == 0L && this._shutdown) {
                this.notifyAll();
            }
            if (!this._shutdown && bl) {
                this.addWorker(runnable);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: ThreadPool::workerDone");
        }
    }
}

