/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirProvider
implements WSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog(DirProvider.class.getName());
    private WSDDDeployment deployment = null;
    private String configFile;
    private File dir;
    private static final String SERVER_CONFIG_FILE = "server-config.wsdd";

    public DirProvider(String string) throws ConfigurationException {
        this(string, SERVER_CONFIG_FILE);
    }

    public DirProvider(String string, String string2) throws ConfigurationException {
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canRead())) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", string));
        }
        this.dir = file;
        this.configFile = string2;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void configureEngine(AxisEngine axisEngine) throws ConfigurationException {
        this.deployment = new WSDDDeployment();
        WSDDGlobalConfiguration wSDDGlobalConfiguration = new WSDDGlobalConfiguration();
        wSDDGlobalConfiguration.setOptionsHashtable(new Hashtable());
        this.deployment.setGlobalConfiguration(wSDDGlobalConfiguration);
        File[] fileArray = this.dir.listFiles(new DirFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            this.processWSDD(fileArray[i]);
        }
        this.deployment.configureEngine(axisEngine);
        axisEngine.refreshGlobalOptions();
    }

    private void processWSDD(File file) throws ConfigurationException {
        File file2 = new File(file, this.configFile);
        if (!file2.exists()) {
            return;
        }
        log.debug("Loading service configuration from file: " + file2);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            WSDDDocument wSDDDocument = new WSDDDocument(XMLUtils.newDocument(fileInputStream));
            wSDDDocument.deploy(this.deployment);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeEngineConfig(AxisEngine axisEngine) throws ConfigurationException {
    }

    public Handler getHandler(QName qName) throws ConfigurationException {
        return this.deployment.getHandler(qName);
    }

    public SOAPService getService(QName qName) throws ConfigurationException {
        SOAPService sOAPService = this.deployment.getService(qName);
        if (sOAPService == null) {
            throw new ConfigurationException(Messages.getMessage("noService10", qName.toString()));
        }
        return sOAPService;
    }

    public SOAPService getServiceByNamespaceURI(String string) throws ConfigurationException {
        return this.deployment.getServiceByNamespaceURI(string);
    }

    public Handler getTransport(QName qName) throws ConfigurationException {
        return this.deployment.getTransport(qName);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.deployment.getTypeMappingRegistry();
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.deployment.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.deployment.getGlobalResponse();
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration wSDDGlobalConfiguration = this.deployment.getGlobalConfiguration();
        if (wSDDGlobalConfiguration != null) {
            return wSDDGlobalConfiguration.getParametersTable();
        }
        return null;
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        return this.deployment.getDeployedServices();
    }

    public List getRoles() {
        return this.deployment.getRoles();
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

