/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.axis.AxisProperties;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryDefault;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class EngineConfigurationFactoryServlet
extends EngineConfigurationFactoryDefault {
    protected static Log log = LogFactory.getLog(EngineConfigurationFactoryServlet.class.getName());
    private ServletConfig cfg;

    public static EngineConfigurationFactory newFactory(Object object) {
        return object instanceof ServletConfig ? new EngineConfigurationFactoryServlet((ServletConfig)object) : null;
    }

    protected EngineConfigurationFactoryServlet(ServletConfig servletConfig) {
        this.cfg = servletConfig;
    }

    public EngineConfiguration getServerEngineConfig() {
        return EngineConfigurationFactoryServlet.getServerEngineConfig(this.cfg);
    }

    private static EngineConfiguration getServerEngineConfig(ServletConfig servletConfig) {
        Object object;
        ServletContext servletContext = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter("axis.ServerConfigFile");
        if (string == null) {
            string = AxisProperties.getProperty("axis.ServerConfigFile");
        }
        if (string == null) {
            string = "server-config.wsdd";
        }
        String string2 = "/WEB-INF";
        FileProvider fileProvider = null;
        String string3 = servletContext.getRealPath(string2);
        if (string3 == null || !new File(string3, string).exists()) {
            object = string2 + "/" + string;
            InputStream inputStream = servletContext.getResourceAsStream((String)object);
            if (inputStream != null) {
                fileProvider = new FileProvider(inputStream);
            }
            if (fileProvider == null) {
                log.error(Messages.getMessage("servletEngineWebInfError03", (String)object));
            }
        }
        if (fileProvider == null && string3 != null) {
            try {
                fileProvider = new FileProvider(string3, string);
            }
            catch (ConfigurationException configurationException) {
                log.error(Messages.getMessage("servletEngineWebInfError00"), configurationException);
            }
        }
        if (fileProvider == null) {
            log.warn(Messages.getMessage("servletEngineWebInfWarn00"));
            try {
                object = ClassUtils.getResourceAsStream(AxisServer.class, "server-config.wsdd");
                fileProvider = new FileProvider((InputStream)object);
            }
            catch (Exception exception) {
                log.error(Messages.getMessage("servletEngineWebInfError02"), exception);
            }
        }
        return fileProvider;
    }
}

