/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDArrayMapping
extends WSDDTypeMapping {
    private QName innerType = null;

    public WSDDArrayMapping() {
    }

    public WSDDArrayMapping(Element element) throws WSDDException {
        super(element);
        Attr attr = element.getAttributeNode("innerType");
        if (attr != null) {
            String string = attr.getValue();
            this.innerType = XMLUtils.getQNameFromString(string, element);
        }
        this.serializer = "org.apache.axis.encoding.ser.ArraySerializerFactory";
        this.deserializer = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
    }

    protected QName getElementName() {
        return QNAME_ARRAYMAPPING;
    }

    public QName getInnerType() {
        return this.innerType;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = serializationContext.qName2String(this.typeQName);
        attributesImpl.addAttribute("", "languageSpecificType", "languageSpecificType", "CDATA", string);
        String string2 = serializationContext.qName2String(this.qname);
        attributesImpl.addAttribute("", "qname", "qname", "CDATA", string2);
        String string3 = serializationContext.qName2String(this.innerType);
        attributesImpl.addAttribute("", "innerType", "innerType", "CDATA", string3);
        serializationContext.startElement(QNAME_ARRAYMAPPING, attributesImpl);
        serializationContext.endElement();
    }
}

