/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDElement;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDJAXRPCHandlerInfo
extends WSDDElement {
    private String _classname;
    private Map _map;
    private QName[] _headers;

    public WSDDJAXRPCHandlerInfo() {
    }

    public WSDDJAXRPCHandlerInfo(Element element) throws WSDDException {
        super(element);
        String string;
        Object object;
        String string2 = element.getAttribute("classname");
        if (string2 == null || string2.equals("")) {
            throw new WSDDException(Messages.getMessage("noClassNameAttr00"));
        }
        this._classname = string2;
        Element[] elementArray = this.getChildElements(element, "parameter");
        this._map = new HashMap();
        if (elementArray.length != 0) {
            for (int i = 0; i < elementArray.length; ++i) {
                Element element2 = elementArray[i];
                object = element2.getAttribute("name");
                string = element2.getAttribute("value");
                this._map.put(object, string);
            }
        }
        if ((elementArray = this.getChildElements(element, "header")).length != 0) {
            ArrayList<QName> arrayList = new ArrayList<QName>();
            for (int i = 0; i < elementArray.length; ++i) {
                object = elementArray[i];
                string = object.getAttribute("qname");
                if (string == null || string.equals("")) {
                    throw new WSDDException(Messages.getMessage("noValidHeader"));
                }
                QName qName = XMLUtils.getQNameFromString(string, (Node)object);
                if (qName == null) continue;
                arrayList.add(qName);
            }
            QName[] qNameArray = new QName[arrayList.size()];
            this._headers = arrayList.toArray(qNameArray);
        }
    }

    protected QName getElementName() {
        return QNAME_JAXRPC_HANDLERINFO;
    }

    public String getHandlerClassName() {
        return this._classname;
    }

    public void setHandlerClassName(String string) {
        this._classname = string;
    }

    public Map getHandlerMap() {
        return this._map;
    }

    public void setHandlerMap(Map map) {
        this._map = map;
    }

    public QName[] getHeaders() {
        return this._headers;
    }

    public void setHeaders(QName[] qNameArray) {
        this._headers = qNameArray;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "classname", "classname", "CDATA", this._classname);
        serializationContext.startElement(WSDDConstants.QNAME_JAXRPC_HANDLERINFO, attributesImpl);
        Map map = this._map;
        if (map != null) {
            Set set = map.keySet();
            for (String string : set) {
                String string2 = (String)map.get(string);
                attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "name", "name", "CDATA", string);
                attributesImpl.addAttribute("", "value", "value", "CDATA", string2);
                serializationContext.startElement(WSDDConstants.QNAME_PARAM, attributesImpl);
                serializationContext.endElement();
            }
        }
        if (this._headers != null) {
            for (int i = 0; i < this._headers.length; ++i) {
                QName qName = this._headers[i];
                attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "qname", "qname", "CDATA", serializationContext.qName2String(qName));
                serializationContext.startElement(WSDDConstants.QNAME_JAXRPC_HEADER, attributesImpl);
                serializationContext.endElement();
            }
        }
        serializationContext.endElement();
    }
}

