/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDJAXRPCHandlerInfo;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.handlers.HandlerInfoChainFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDJAXRPCHandlerInfoChain
extends WSDDHandler {
    protected static Log log = LogFactory.getLog(WSDDJAXRPCHandlerInfoChain.class.getName());
    private ArrayList _hiList;
    private HandlerInfoChainFactory _hiChainFactory;
    private String[] _roles;

    public WSDDJAXRPCHandlerInfoChain() {
    }

    public WSDDJAXRPCHandlerInfoChain(Element element) throws WSDDException {
        super(element);
        String string;
        ArrayList<HandlerInfo> arrayList = new ArrayList<HandlerInfo>();
        this._hiList = new ArrayList();
        Element[] elementArray = this.getChildElements(element, "handlerInfo");
        if (elementArray.length != 0) {
            for (int i = 0; i < elementArray.length; ++i) {
                WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo = new WSDDJAXRPCHandlerInfo(elementArray[i]);
                this._hiList.add(wSDDJAXRPCHandlerInfo);
                string = wSDDJAXRPCHandlerInfo.getHandlerClassName();
                Class clazz = null;
                try {
                    clazz = ClassUtils.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.error(Messages.getMessage("handlerInfoChainNoClass00", string), classNotFoundException);
                }
                Map map = wSDDJAXRPCHandlerInfo.getHandlerMap();
                QName[] qNameArray = wSDDJAXRPCHandlerInfo.getHeaders();
                if (clazz == null) continue;
                HandlerInfo handlerInfo = new HandlerInfo(clazz, map, qNameArray);
                arrayList.add(handlerInfo);
            }
        }
        this._hiChainFactory = new HandlerInfoChainFactory(arrayList);
        elementArray = this.getChildElements(element, "role");
        if (elementArray.length != 0) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < elementArray.length; ++i) {
                string = elementArray[i].getAttribute("soapActorName");
                arrayList2.add(string);
            }
            this._roles = new String[arrayList2.size()];
            this._roles = arrayList2.toArray(this._roles);
            this._hiChainFactory.setRoles(this._roles);
        }
    }

    public HandlerInfoChainFactory getHandlerChainFactory() {
        return this._hiChainFactory;
    }

    public void setHandlerChainFactory(HandlerInfoChainFactory handlerInfoChainFactory) {
        this._hiChainFactory = handlerInfoChainFactory;
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_JAXRPC_HANDLERINFOCHAIN;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        serializationContext.startElement(QNAME_JAXRPC_HANDLERINFOCHAIN, null);
        ArrayList arrayList = this._hiList;
        for (WSDDJAXRPCHandlerInfo wSDDJAXRPCHandlerInfo : arrayList) {
            wSDDJAXRPCHandlerInfo.writeToContext(serializationContext);
        }
        if (this._roles != null) {
            for (int i = 0; i < this._roles.length; ++i) {
                AttributesImpl attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "soapActorName", "soapActorName", "CDATA", this._roles[i]);
                serializationContext.startElement(QNAME_JAXRPC_ROLE, attributesImpl);
                serializationContext.endElement();
            }
        }
        serializationContext.endElement();
    }

    public ArrayList getHandlerInfoList() {
        return this._hiList;
    }

    public void setHandlerInfoList(ArrayList arrayList) {
        this._hiList = arrayList;
    }

    public String[] getRoles() {
        return this._roles;
    }

    public void setRoles(String[] stringArray) {
        this._roles = stringArray;
    }
}

