/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.description;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.TypeEntry;

public class ParameterDesc
implements Serializable {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private transient QName name;
    public TypeEntry typeEntry;
    private byte mode = 1;
    private QName typeQName;
    private Class javaType = null;
    private int order = -1;
    private boolean isReturn = false;
    private String mimeType = null;
    private QName itemQName;
    private QName itemType;
    private boolean inHeader = false;
    private boolean outHeader = false;
    private String documentation = null;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc parameterDesc) {
        this.name = parameterDesc.name;
        this.typeEntry = parameterDesc.typeEntry;
        this.mode = parameterDesc.mode;
        this.typeQName = parameterDesc.typeQName;
        this.javaType = parameterDesc.javaType;
        this.order = parameterDesc.order;
        this.isReturn = parameterDesc.isReturn;
        this.mimeType = parameterDesc.mimeType;
        this.inHeader = parameterDesc.inHeader;
        this.outHeader = parameterDesc.outHeader;
    }

    public ParameterDesc(QName qName, byte by, QName qName2) {
        this.name = qName;
        this.mode = by;
        this.typeQName = qName2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz, boolean bl, boolean bl2) {
        this(qName, by, qName2);
        this.javaType = clazz;
        this.inHeader = bl;
        this.outHeader = bl2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, Class clazz) {
        this(qName, by, qName2, clazz, false, false);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "name:       " + this.name + "\n";
        string2 = string2 + string + "typeEntry:  " + this.typeEntry + "\n";
        string2 = string2 + string + "mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT")) + "\n";
        string2 = string2 + string + "position:   " + this.order + "\n";
        string2 = string2 + string + "isReturn:   " + this.isReturn + "\n";
        string2 = string2 + string + "typeQName:  " + this.typeQName + "\n";
        string2 = string2 + string + "javaType:   " + this.javaType + "\n";
        string2 = string2 + string + "inHeader:   " + this.inHeader + "\n";
        string2 = string2 + string + "outHeader:  " + this.outHeader + "\n";
        return string2;
    }

    public static byte modeFromString(String string) {
        int n = 1;
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("out")) {
            n = 2;
        } else if (string.equalsIgnoreCase("inout")) {
            n = 3;
        }
        return (byte)n;
    }

    public static String getModeAsString(byte by) {
        if (by == 3) {
            return "inout";
        }
        if (by == 2) {
            return "out";
        }
        if (by == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(by)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String string) {
        this.name = new QName("", string);
    }

    public void setQName(QName qName) {
        this.name = qName;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName qName) {
        this.typeQName = qName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class clazz) {
        if (clazz != null && ((this.mode == 1 || this.isReturn) && Holder.class.isAssignableFrom(clazz) || this.mode != 1 && !this.isReturn && !Holder.class.isAssignableFrom(clazz))) {
            throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", clazz.getName(), ParameterDesc.getModeAsString(this.mode)));
        }
        this.javaType = clazz;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean bl) {
        this.outHeader = bl;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean bl) {
        this.isReturn = bl;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.name == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.name.getNamespaceURI());
            objectOutputStream.writeObject(this.name.getLocalPart());
        }
        if (this.typeQName == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.typeQName.getNamespaceURI());
            objectOutputStream.writeObject(this.typeQName.getLocalPart());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readBoolean() ? new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()) : null;
        this.typeQName = objectInputStream.readBoolean() ? new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()) : null;
        objectInputStream.defaultReadObject();
    }

    public QName getItemQName() {
        return this.itemQName;
    }

    public void setItemQName(QName qName) {
        this.itemQName = qName;
    }

    public QName getItemType() {
        return this.itemType;
    }

    public void setItemType(QName qName) {
        this.itemType = qName;
    }
}

