/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.ArrayUtil;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;

public class TypeMappingImpl
implements Serializable {
    protected static Log log = LogFactory.getLog(TypeMappingImpl.class.getName());
    public static boolean dotnet_soapenc_bugfix = false;
    private HashMap qName2Pair = new HashMap();
    private HashMap class2Pair = new HashMap();
    private HashMap pair2SF = new HashMap();
    private HashMap pair2DF = new HashMap();
    private ArrayList namespaces = new ArrayList();
    protected Boolean doAutoTypes = null;

    private static boolean isArray(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public String[] getSupportedEncodings() {
        String[] stringArray = new String[this.namespaces.size()];
        return this.namespaces.toArray(stringArray);
    }

    public void setSupportedEncodings(String[] stringArray) {
        this.namespaces.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.namespaces.contains(stringArray[i])) continue;
            this.namespaces.add(stringArray[i]);
        }
    }

    public boolean isRegistered(Class clazz, QName qName) {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        return this.pair2SF.keySet().contains(new Pair(clazz, qName));
    }

    public void register(Class clazz, QName qName, javax.xml.rpc.encoding.SerializerFactory serializerFactory, javax.xml.rpc.encoding.DeserializerFactory deserializerFactory) throws JAXRPCException {
        if (serializerFactory == null && deserializerFactory == null) {
            throw new JAXRPCException(Messages.getMessage("badSerFac"));
        }
        this.internalRegister(clazz, qName, serializerFactory, deserializerFactory);
    }

    protected void internalRegister(Class clazz, QName qName, javax.xml.rpc.encoding.SerializerFactory serializerFactory, javax.xml.rpc.encoding.DeserializerFactory deserializerFactory) throws JAXRPCException {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(clazz, qName);
        this.qName2Pair.put(qName, pair);
        this.class2Pair.put(clazz, pair);
        if (serializerFactory != null) {
            this.pair2SF.put(pair, serializerFactory);
        }
        if (deserializerFactory != null) {
            this.pair2DF.put(pair, deserializerFactory);
        }
    }

    public javax.xml.rpc.encoding.SerializerFactory getSerializer(Class clazz, QName qName) throws JAXRPCException {
        Pair pair;
        javax.xml.rpc.encoding.SerializerFactory serializerFactory = null;
        if (qName == null && (qName = this.getTypeQName(clazz, null)) == null) {
            return null;
        }
        Pair pair2 = new Pair(clazz, qName);
        serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair2);
        if (serializerFactory == null && clazz.isArray()) {
            int n = 1;
            Class<?> clazz2 = clazz.getComponentType();
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            int[] nArray = new int[n];
            Class<?> clazz3 = null;
            for (clazz2 = clazz2.getSuperclass(); clazz2 != null && (serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair2 = new Pair(clazz3 = Array.newInstance(clazz2, nArray).getClass(), qName))) == null; clazz2 = clazz2.getSuperclass()) {
            }
        }
        if (serializerFactory == null && clazz.isArray() && qName != null && (pair = (Pair)this.qName2Pair.get(qName)) != null && pair.javaType != null && !pair.javaType.isPrimitive() && ArrayUtil.isConvertable(pair.javaType, clazz)) {
            serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        }
        return serializerFactory;
    }

    public SerializerFactory finalGetSerializer(Class clazz) {
        Pair pair = TypeMappingImpl.isArray(clazz) ? (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY) : (Pair)this.class2Pair.get(clazz);
        if (pair != null) {
            return (SerializerFactory)this.pair2SF.get(pair);
        }
        return null;
    }

    public QName getXMLType(Class clazz, QName qName, boolean bl) throws JAXRPCException {
        javax.xml.rpc.encoding.SerializerFactory serializerFactory = null;
        if (qName == null && (qName = this.getTypeQNameRecursive(clazz)) == null) {
            return null;
        }
        Pair pair = new Pair(clazz, qName);
        serializerFactory = (javax.xml.rpc.encoding.SerializerFactory)this.pair2SF.get(pair);
        if (serializerFactory != null) {
            return qName;
        }
        if (TypeMappingImpl.isArray(clazz)) {
            if (bl) {
                return Constants.SOAP_ARRAY;
            }
            pair = (Pair)this.qName2Pair.get(qName);
        }
        if (pair == null) {
            pair = (Pair)this.class2Pair.get(clazz);
        }
        if (pair != null) {
            qName = pair.xmlType;
        }
        return qName;
    }

    public javax.xml.rpc.encoding.DeserializerFactory getDeserializer(Class clazz, QName qName, TypeMappingDelegate typeMappingDelegate) throws JAXRPCException {
        if (clazz == null && (clazz = typeMappingDelegate.getClassForQName(qName)) == null) {
            return null;
        }
        Pair pair = new Pair(clazz, qName);
        return (javax.xml.rpc.encoding.DeserializerFactory)this.pair2DF.get(pair);
    }

    public DeserializerFactory finalGetDeserializer(Class clazz, QName qName, TypeMappingDelegate typeMappingDelegate) {
        DeserializerFactory deserializerFactory = null;
        if (clazz != null && clazz.isArray()) {
            QName qName2;
            Serializable serializable;
            Class<?> clazz2 = clazz.getComponentType();
            if (qName != null && ((serializable = typeMappingDelegate.getClassForQName(qName)) == clazz2 || serializable != null && clazz2.isAssignableFrom((Class<?>)serializable))) {
                return null;
            }
            serializable = (Pair)this.qName2Pair.get(Constants.SOAP_ARRAY);
            deserializerFactory = (DeserializerFactory)this.pair2DF.get(serializable);
            if (deserializerFactory instanceof ArrayDeserializerFactory && clazz.isArray() && (qName2 = typeMappingDelegate.getTypeQName(clazz2)) != null) {
                deserializerFactory = new ArrayDeserializerFactory(qName2);
            }
        }
        return deserializerFactory;
    }

    public void removeSerializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(clazz, qName);
        this.pair2SF.remove(pair);
    }

    public void removeDeserializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            throw new JAXRPCException(Messages.getMessage(clazz == null ? "badJavaType" : "badXmlType"));
        }
        Pair pair = new Pair(clazz, qName);
        this.pair2DF.remove(pair);
    }

    public QName getTypeQNameRecursive(Class clazz) {
        QName qName = null;
        while (clazz != null) {
            qName = this.getTypeQName(clazz, null);
            if (qName != null) {
                return qName;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    Class<?> clazz2 = classArray[i];
                    qName = this.getTypeQName(clazz2, null);
                    if (qName == null) continue;
                    return qName;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public QName getTypeQNameExact(Class clazz, TypeMappingDelegate typeMappingDelegate) {
        if (clazz == null) {
            return null;
        }
        QName qName = null;
        Pair pair = (Pair)this.class2Pair.get(clazz);
        if (this.isDotNetSoapEncFixNeeded() && pair != null && Constants.isSOAP_ENC((qName = pair.xmlType).getNamespaceURI()) && !qName.getLocalPart().equals("Array")) {
            pair = null;
        }
        if (pair == null && typeMappingDelegate != null) {
            qName = typeMappingDelegate.delegate.getTypeQNameExact(clazz, typeMappingDelegate.next);
        }
        if (pair != null) {
            qName = pair.xmlType;
        }
        return qName;
    }

    private boolean isDotNetSoapEncFixNeeded() {
        String string;
        SOAPService sOAPService;
        MessageContext messageContext = MessageContext.getCurrentContext();
        if (messageContext != null && (sOAPService = messageContext.getService()) != null && (string = (String)sOAPService.getOption("dotNetSoapEncFix")) != null) {
            return JavaUtils.isTrue(string);
        }
        return dotnet_soapenc_bugfix;
    }

    public QName getTypeQName(Class clazz, TypeMappingDelegate typeMappingDelegate) {
        QName qName = this.getTypeQNameExact(clazz, typeMappingDelegate);
        if (this.shouldDoAutoTypes() && clazz != List.class && !List.class.isAssignableFrom(clazz) && qName != null && qName.equals(Constants.SOAP_ARRAY)) {
            qName = new QName(Namespaces.makeNamespace(clazz.getName()), Types.getLocalNameFromFullName(clazz.getName()));
            this.internalRegister(clazz, qName, new ArraySerializerFactory(), new ArrayDeserializerFactory());
        }
        if (qName == null && TypeMappingImpl.isArray(clazz)) {
            Pair pair = (Pair)this.class2Pair.get(Object[].class);
            qName = pair != null ? pair.xmlType : Constants.SOAP_ARRAY;
        }
        if (qName == null && this.shouldDoAutoTypes()) {
            qName = new QName(Namespaces.makeNamespace(clazz.getName()), Types.getLocalNameFromFullName(clazz.getName()));
            this.internalRegister(clazz, qName, new BeanSerializerFactory(clazz, qName), new BeanDeserializerFactory(clazz, qName));
        }
        return qName;
    }

    public Class getClassForQName(QName qName, Class clazz, TypeMappingDelegate typeMappingDelegate) {
        Object object;
        if (qName == null) {
            return null;
        }
        if (clazz != null && this.pair2DF.get(object = new Pair(clazz, qName)) == null && typeMappingDelegate != null) {
            clazz = typeMappingDelegate.getClassForQName(qName, clazz);
        }
        if (clazz == null) {
            object = (Pair)this.qName2Pair.get(qName);
            if (object == null && typeMappingDelegate != null) {
                clazz = typeMappingDelegate.getClassForQName(qName);
            } else if (object != null) {
                clazz = ((Pair)object).javaType;
            }
        }
        if (clazz == null && this.shouldDoAutoTypes() && (object = Namespaces.getPackage(qName.getNamespaceURI())) != null) {
            String string = qName.getLocalPart();
            if (((String)object).length() > 0) {
                string = (String)object + "." + string;
            }
            try {
                clazz = ClassUtils.forName(string);
                this.internalRegister(clazz, qName, new BeanSerializerFactory(clazz, qName), new BeanDeserializerFactory(clazz, qName));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public void setDoAutoTypes(boolean bl) {
        this.doAutoTypes = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldDoAutoTypes() {
        if (this.doAutoTypes != null) {
            return this.doAutoTypes;
        }
        MessageContext messageContext = MessageContext.getCurrentContext();
        if (messageContext != null && (messageContext.isPropertyTrue("axis.doAutoTypes") || messageContext.getAxisEngine() != null && JavaUtils.isTrue(messageContext.getAxisEngine().getOption("axis.doAutoTypes")))) {
            this.doAutoTypes = Boolean.TRUE;
        }
        if (this.doAutoTypes == null) {
            this.doAutoTypes = AxisProperties.getProperty("axis.doAutoTypes", "false").equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.doAutoTypes;
    }

    public Class[] getAllClasses(TypeMappingDelegate typeMappingDelegate) {
        HashSet<Class<Object>> hashSet = new HashSet<Class<Object>>();
        if (typeMappingDelegate != null) {
            hashSet.addAll(Arrays.asList(typeMappingDelegate.getAllClasses()));
        }
        hashSet.addAll(this.class2Pair.keySet());
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    public static class Pair
    implements Serializable {
        public Class javaType;
        public QName xmlType;

        public Pair(Class clazz, QName qName) {
            this.javaType = clazz;
            this.xmlType = qName;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            Pair pair = (Pair)object;
            if (pair.xmlType == this.xmlType && pair.javaType == this.javaType) {
                return true;
            }
            return pair.xmlType.equals(this.xmlType) && pair.javaType.equals(this.javaType);
        }

        public int hashCode() {
            int n = 0;
            if (this.javaType != null) {
                n ^= this.javaType.hashCode();
            }
            if (this.xmlType != null) {
                n ^= this.xmlType.hashCode();
            }
            return n;
        }
    }
}

