/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Use;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class ArraySerializer
implements Serializer {
    QName xmlType = null;
    Class javaType = null;
    QName componentType = null;
    QName componentQName = null;
    protected static Log log = LogFactory.getLog(ArraySerializer.class.getName());

    public ArraySerializer(Class clazz, QName qName) {
        this.javaType = clazz;
        this.xmlType = qName;
    }

    public ArraySerializer(Class clazz, QName qName, QName qName2) {
        this(clazz, qName);
        this.componentType = qName2;
    }

    public ArraySerializer(Class clazz, QName qName, QName qName2, QName qName3) {
        this(clazz, qName, qName2);
        this.componentQName = qName3;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        Object object22;
        Object object3;
        boolean bl;
        Object object4;
        Class clazz;
        if (object == null) {
            throw new IOException(Messages.getMessage("cantDoNullArray00"));
        }
        MessageContext messageContext = serializationContext.getMessageContext();
        SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
        SOAPConstants sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        boolean bl2 = serializationContext.isEncoded();
        if (messageContext != null) {
            schemaVersion = messageContext.getSchemaVersion();
            sOAPConstants = messageContext.getSOAPConstants();
        }
        Class<?> clazz2 = object.getClass();
        Collection collection = null;
        if (!clazz2.isArray()) {
            if (!(object instanceof Collection)) {
                throw new IOException(Messages.getMessage("cantSerialize00", clazz2.getName()));
            }
            collection = (Collection)object;
        }
        Class<Object> clazz3 = collection == null ? clazz2.getComponentType() : Object.class;
        QName qName2 = this.componentType;
        String string = "";
        if (qName2 != null) {
            clazz = serializationContext.getTypeMapping();
            object4 = (SerializerFactory)clazz.getSerializer(clazz3, qName2);
            while (clazz3.isArray() && object4 instanceof ArraySerializerFactory) {
                ArraySerializerFactory arraySerializerFactory = (ArraySerializerFactory)object4;
                clazz3 = clazz3.getComponentType();
                QName qName3 = null;
                if (arraySerializerFactory.getComponentType() != null) {
                    qName3 = arraySerializerFactory.getComponentType();
                    if (bl2) {
                        qName2 = qName3;
                    }
                }
                object4 = (SerializerFactory)clazz.getSerializer(clazz3, qName3);
                if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    string = string + "* ";
                    continue;
                }
                string = string + "[]";
            }
        } else {
            while (clazz3.isArray()) {
                clazz3 = clazz3.getComponentType();
                if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    string = string + "* ";
                    continue;
                }
                string = string + "[]";
            }
        }
        if (qName2 == null && (qName2 = serializationContext.getCurrentXMLType()) != null && (qName2.equals(this.xmlType) || qName2.equals(Constants.XSD_ANYTYPE) || qName2.equals(sOAPConstants.getArrayType()))) {
            qName2 = null;
        }
        if (qName2 == null) {
            qName2 = serializationContext.getItemType();
        }
        if (qName2 == null) {
            qName2 = serializationContext.getQNameForClass(clazz3);
        }
        if (qName2 == null) {
            for (clazz = clazz3; clazz != null && qName2 == null; clazz = clazz.getSuperclass()) {
                qName2 = serializationContext.getQNameForClass(clazz);
            }
            if (qName2 != null) {
                clazz3 = clazz;
            }
        }
        if (qName2 == null) {
            throw new IOException(Messages.getMessage("noType00", clazz3.getName()));
        }
        int n = collection == null ? Array.getLength(object) : collection.size();
        object4 = "";
        int n2 = -1;
        if (bl2) {
            object4 = sOAPConstants == SOAPConstants.SOAP12_CONSTANTS ? string + n : string + "[" + n + "]";
            boolean bl3 = false;
            if (messageContext != null) {
                bl3 = JavaUtils.isTrueExplicitly(messageContext.getProperty("enable2DArrayEncoding"));
            }
            if (bl3 && !string.equals("") && clazz2.isArray() && n > 0) {
                bl = true;
                for (int i = 0; i < n && bl; ++i) {
                    object3 = Array.get(object, i);
                    if (object3 == null) {
                        bl = false;
                        continue;
                    }
                    if (n2 < 0) {
                        n2 = Array.getLength(object3);
                        if (n2 > 0) continue;
                        bl = false;
                        continue;
                    }
                    if (n2 == Array.getLength(object3)) continue;
                    bl = false;
                }
                if (bl) {
                    string = string.substring(0, string.length() - 2);
                    object4 = sOAPConstants == SOAPConstants.SOAP12_CONSTANTS ? string + n + " " + n2 : string + "[" + n + "," + n2 + "]";
                } else {
                    n2 = -1;
                }
            }
        }
        QName qName4 = serializationContext.getItemQName();
        boolean bl4 = bl = !bl2 && qName4 == null && qName2.equals(serializationContext.getCurrentXMLType());
        if (bl2) {
            Object object5;
            AttributesImpl attributesImpl = attributes == null ? new AttributesImpl() : (attributes instanceof AttributesImpl ? (AttributesImpl)attributes : new AttributesImpl(attributes));
            object3 = serializationContext.attributeQName2String(qName2);
            if (attributesImpl.getIndex(sOAPConstants.getEncodingURI(), sOAPConstants.getAttrItemType()) == -1) {
                object5 = serializationContext.getPrefixForURI(sOAPConstants.getEncodingURI());
                if (sOAPConstants != SOAPConstants.SOAP12_CONSTANTS) {
                    object3 = (String)object3 + (String)object4;
                    attributesImpl.addAttribute(sOAPConstants.getEncodingURI(), sOAPConstants.getAttrItemType(), (String)object5 + ":arrayType", "CDATA", (String)object3);
                } else {
                    attributesImpl.addAttribute(sOAPConstants.getEncodingURI(), sOAPConstants.getAttrItemType(), (String)object5 + ":itemType", "CDATA", (String)object3);
                    attributesImpl.addAttribute(sOAPConstants.getEncodingURI(), "arraySize", (String)object5 + ":arraySize", "CDATA", (String)object4);
                }
            }
            object5 = serializationContext.getPrefixForURI(schemaVersion.getXsiURI(), "xsi") + ":type";
            object22 = sOAPConstants == SOAPConstants.SOAP12_CONSTANTS ? Constants.SOAP_ARRAY12 : Constants.SOAP_ARRAY;
            int n3 = attributesImpl.getIndex(schemaVersion.getXsiURI(), "type");
            if (n3 != -1) {
                attributesImpl.setAttribute(n3, schemaVersion.getXsiURI(), "type", (String)object5, "CDATA", serializationContext.qName2String((QName)object22));
            } else {
                attributesImpl.addAttribute(schemaVersion.getXsiURI(), "type", (String)object5, "CDATA", serializationContext.qName2String((QName)object22));
            }
            attributes = attributesImpl;
        }
        QName qName5 = qName;
        object3 = attributes;
        if (!bl) {
            object3 = null;
            serializationContext.startElement(qName, attributes);
            if (qName4 != null) {
                qName5 = qName4;
            } else if (this.componentQName != null) {
                qName5 = this.componentQName;
            }
        }
        if (n2 < 0) {
            if (collection == null) {
                for (int i = 0; i < n; ++i) {
                    object22 = Array.get(object, i);
                    serializationContext.serialize(qName5, (Attributes)(object3 == null ? object3 : new AttributesImpl((Attributes)object3)), object22, qName2);
                }
            } else {
                for (Object object22 : collection) {
                    serializationContext.serialize(qName5, (Attributes)(object3 == null ? object3 : new AttributesImpl((Attributes)object3)), object22, qName2);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Object object6 = Array.get(Array.get(object, i), j);
                    serializationContext.serialize(qName5, null, object6, qName2);
                }
            }
        }
        if (!bl) {
            serializationContext.endElement();
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    private static boolean isArray(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    private static Class getComponentType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        boolean bl = true;
        MessageContext messageContext = MessageContext.getCurrentContext();
        if (messageContext != null) {
            bl = messageContext.isEncoded();
        } else {
            boolean bl2 = bl = types.getServiceDesc().getUse() == Use.ENCODED;
        }
        if (!bl) {
            Class clazz2 = Object.class;
            if (clazz.isArray()) {
                clazz2 = clazz.getComponentType();
            }
            String string = types.writeType(clazz2);
            return types.createLiteralArrayElement(string, null);
        }
        String string = null;
        Class clazz3 = null;
        if (ArraySerializer.isArray(clazz)) {
            String string2 = "[]";
            clazz3 = ArraySerializer.getComponentType(clazz);
            while (ArraySerializer.isArray(clazz3)) {
                string2 = string2 + "[]";
                clazz3 = ArraySerializer.getComponentType(clazz3);
            }
            types.writeType(clazz3, null);
            string = types.getQNameString(types.getTypeQName(clazz3)) + string2;
        }
        return types.createArrayElement(string);
    }
}

