/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.utils.Messages;

public class DateDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
    private static Calendar calendar = Calendar.getInstance();

    public DateDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeValue(String string) {
        Comparable<Date> comparable;
        boolean bl = false;
        if (string != null) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '-') {
                string = string.substring(1);
                bl = true;
            }
            if (string.length() < 10) {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
        }
        Calendar calendar = DateDeserializer.calendar;
        synchronized (calendar) {
            try {
                comparable = zulu.parse(string == null ? null : string.substring(0, 10));
            }
            catch (Exception exception) {
                throw new NumberFormatException(exception.toString());
            }
            if (bl) {
                DateDeserializer.calendar.setTime((Date)comparable);
                DateDeserializer.calendar.set(0, 0);
                comparable = DateDeserializer.calendar.getTime();
            }
            if (this.javaType == Date.class) {
                return comparable;
            }
            if (this.javaType == java.sql.Date.class) {
                comparable = new java.sql.Date(comparable.getTime());
            } else {
                DateDeserializer.calendar.setTime((Date)comparable);
                comparable = DateDeserializer.calendar;
            }
        }
        return comparable;
    }
}

