/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.CharArrayWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.types.URI;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.BeanUtils;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleDeserializer
extends DeserializerImpl {
    private static final Class[] STRING_STRING_CLASS = new Class[]{String.class, String.class};
    public static final Class[] STRING_CLASS = new Class[]{String.class};
    private final CharArrayWriter val = new CharArrayWriter();
    private Constructor constructor = null;
    private Map propertyMap = null;
    private HashMap attributeMap = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    protected DeserializationContext context = null;
    protected SimpleDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public SimpleDeserializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.init();
    }

    public SimpleDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
        this.init();
    }

    private void init() {
        if (SimpleType.class.isAssignableFrom(this.javaType) && this.typeDesc == null) {
            this.typeDesc = TypeDesc.getTypeDescForClass(this.javaType);
        }
        if (this.typeDesc != null) {
            this.propertyMap = this.typeDesc.getPropertyDescriptorMap();
        } else {
            BeanPropertyDescriptor[] beanPropertyDescriptorArray = BeanUtils.getPd(this.javaType, null);
            this.propertyMap = new HashMap();
            for (int i = 0; i < beanPropertyDescriptorArray.length; ++i) {
                BeanPropertyDescriptor beanPropertyDescriptor = beanPropertyDescriptorArray[i];
                this.propertyMap.put(beanPropertyDescriptor.getName(), beanPropertyDescriptor);
            }
        }
    }

    public void reset() {
        this.val.reset();
        this.attributeMap = null;
        this.isNil = false;
        this.isEnded = false;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.val.write(cArray, n, n2);
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.isNil) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw new SAXException(invocationTargetException.getMessage());
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String string) throws Exception {
        Object[] objectArray;
        if (this.javaType == String.class) {
            return string;
        }
        if ((string = string.trim()).length() == 0 && this.typeDesc == null) {
            return null;
        }
        if (this.constructor == null && (objectArray = this.makeBasicValue(string)) != null) {
            return objectArray;
        }
        objectArray = null;
        boolean bl = QName.class.isAssignableFrom(this.javaType);
        if (bl) {
            int n = string.lastIndexOf(":");
            String string2 = n < 0 ? "" : this.context.getNamespaceURI(string.substring(0, n));
            String string3 = n < 0 ? string : string.substring(n + 1);
            objectArray = new Object[]{string2, string3};
        }
        if (this.constructor == null) {
            try {
                this.constructor = bl ? this.javaType.getDeclaredConstructor(STRING_STRING_CLASS) : this.javaType.getDeclaredConstructor(STRING_CLASS);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.constructor.getParameterTypes().length == 0) {
            try {
                Object t = this.constructor.newInstance(new Object[0]);
                t.getClass().getMethod("set_value", String.class).invoke(t, string);
                return t;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objectArray == null) {
            objectArray = new Object[]{string};
        }
        return this.constructor.newInstance(objectArray);
    }

    private Object makeBasicValue(String string) throws Exception {
        if (this.javaType == Boolean.TYPE || this.javaType == Boolean.class) {
            switch (string.charAt(0)) {
                case '0': 
                case 'F': 
                case 'f': {
                    return Boolean.FALSE;
                }
                case '1': 
                case 'T': 
                case 't': {
                    return Boolean.TRUE;
                }
            }
            throw new NumberFormatException(Messages.getMessage("badBool00"));
        }
        if (this.javaType == Float.TYPE || this.javaType == Float.class) {
            if (string.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (string.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            return new Float(string);
        }
        if (this.javaType == Double.TYPE || this.javaType == Double.class) {
            if (string.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (string.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            return new Double(string);
        }
        if (this.javaType == Integer.TYPE || this.javaType == Integer.class) {
            return new Integer(string);
        }
        if (this.javaType == Short.TYPE || this.javaType == Short.class) {
            return new Short(string);
        }
        if (this.javaType == Long.TYPE || this.javaType == Long.class) {
            return new Long(string);
        }
        if (this.javaType == Byte.TYPE || this.javaType == Byte.class) {
            return new Byte(string);
        }
        if (this.javaType == URI.class) {
            return new URI(string);
        }
        return null;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        this.context = deserializationContext;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Class clazz;
            BeanPropertyDescriptor beanPropertyDescriptor;
            QName qName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String string4 = attributes.getLocalName(i);
            if (this.typeDesc != null && (string4 = this.typeDesc.getFieldNameForAttribute(qName)) == null || this.propertyMap == null || (beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string4)) == null || !beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            TypeMapping typeMapping = deserializationContext.getTypeMapping();
            QName qName2 = typeMapping.getTypeQName(clazz = beanPropertyDescriptor.getType());
            if (qName2 == null) {
                throw new SAXException(Messages.getMessage("unregistered00", clazz.toString()));
            }
            Deserializer deserializer = deserializationContext.getDeserializerForType(qName2);
            if (deserializer == null) {
                throw new SAXException(Messages.getMessage("noDeser00", clazz.toString()));
            }
            if (!(deserializer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", beanPropertyDescriptor.getName(), clazz.toString()));
            }
            if (this.attributeMap == null) {
                this.attributeMap = new HashMap();
            }
            try {
                Object object = ((SimpleDeserializer)deserializer).makeValue(attributes.getValue(i));
                this.attributeMap.put(string4, object);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        if (this.attributeMap == null) {
            return;
        }
        Set set = this.attributeMap.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            BeanPropertyDescriptor beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string);
            if (!beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            try {
                beanPropertyDescriptor.set(this.value, v);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }
}

