/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleListDeserializer
extends SimpleDeserializer {
    StringBuffer val = new StringBuffer();
    private Constructor constructor = null;
    private Map propertyMap = null;
    private HashMap attributeMap = null;
    private DeserializationContext context = null;
    public QName xmlType;
    public Class javaType;
    private TypeDesc typeDesc = null;
    protected SimpleListDeserializer cacheStringDSer = null;
    protected QName cacheXMLType = null;

    public SimpleListDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public SimpleListDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        super(clazz, qName, typeDesc);
        this.xmlType = qName;
        this.javaType = clazz;
        this.typeDesc = typeDesc;
    }

    public void reset() {
        this.val.setLength(0);
        this.attributeMap = null;
        this.isNil = false;
        this.isEnded = false;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        throw new SAXException(Messages.getMessage("cantHandle00", "SimpleDeserializer"));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.val.append(cArray, n, n2);
    }

    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.isNil || this.val == null) {
            this.value = null;
            return;
        }
        try {
            this.value = this.makeValue(this.val.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw new SAXException((Exception)throwable);
            }
            throw new SAXException(invocationTargetException.getMessage());
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        this.setSimpleTypeAttributes();
    }

    public Object makeValue(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim());
        int n = stringTokenizer.countTokens();
        Object object = Array.newInstance(this.javaType, n);
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            Array.set(object, i, this.makeUnitValue(string2));
        }
        return object;
    }

    private Object makeUnitValue(String string) throws Exception {
        if (this.javaType == Boolean.TYPE || this.javaType == Boolean.class) {
            switch (string.charAt(0)) {
                case '0': 
                case 'F': 
                case 'f': {
                    return Boolean.FALSE;
                }
                case '1': 
                case 'T': 
                case 't': {
                    return Boolean.TRUE;
                }
            }
            throw new NumberFormatException(Messages.getMessage("badBool00"));
        }
        if (this.javaType == Float.TYPE || this.javaType == Float.class) {
            if (string.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (string.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
        }
        if (this.javaType == Double.TYPE || this.javaType == Double.class) {
            if (string.equals("NaN")) {
                return new Double(Double.NaN);
            }
            if (string.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        if (this.javaType == QName.class) {
            int n = string.lastIndexOf(":");
            String string2 = n < 0 ? "" : this.context.getNamespaceURI(string.substring(0, n));
            String string3 = n < 0 ? string : string.substring(n + 1);
            return new QName(string2, string3);
        }
        return this.constructor.newInstance(string);
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        this.context = deserializationContext;
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Class clazz;
            BeanPropertyDescriptor beanPropertyDescriptor;
            QName qName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String string4 = this.typeDesc.getFieldNameForAttribute(qName);
            if (string4 == null || (beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string4)) == null || !beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            TypeMapping typeMapping = deserializationContext.getTypeMapping();
            QName qName2 = typeMapping.getTypeQName(clazz = beanPropertyDescriptor.getType());
            if (qName2 == null) {
                throw new SAXException(Messages.getMessage("unregistered00", clazz.toString()));
            }
            Deserializer deserializer = deserializationContext.getDeserializerForType(qName2);
            if (deserializer == null) {
                throw new SAXException(Messages.getMessage("noDeser00", clazz.toString()));
            }
            if (!(deserializer instanceof SimpleListDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", beanPropertyDescriptor.getName(), clazz.toString()));
            }
            if (this.attributeMap == null) {
                this.attributeMap = new HashMap();
            }
            try {
                Object object = ((SimpleListDeserializer)deserializer).makeValue(attributes.getValue(i));
                this.attributeMap.put(string4, object);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    private void setSimpleTypeAttributes() throws SAXException {
        if (!SimpleType.class.isAssignableFrom(this.javaType) || this.attributeMap == null) {
            return;
        }
        Set set = this.attributeMap.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            BeanPropertyDescriptor beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string);
            if (!beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            try {
                beanPropertyDescriptor.set(this.value, v);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }
}

