/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleListDeserializer;
import org.apache.axis.utils.JavaUtils;

public class SimpleListDeserializerFactory
extends BaseDeserializerFactory {
    private static final Class[] STRING_CLASS = new Class[]{String.class};
    private final Class clazzType;
    private transient Constructor constructor = null;

    public SimpleListDeserializerFactory(Class clazz, QName qName) {
        super(SimpleListDeserializer.class, qName, clazz.getComponentType());
        this.clazzType = clazz;
        Class<?> clazz2 = clazz.getComponentType();
        try {
            if (!clazz2.isPrimitive()) {
                this.constructor = clazz2.getDeclaredConstructor(STRING_CLASS);
            } else {
                Class clazz3 = JavaUtils.getWrapperClass(clazz2);
                if (clazz3 != null) {
                    this.constructor = clazz3.getDeclaredConstructor(STRING_CLASS);
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.toString());
        }
    }

    public Deserializer getDeserializerAs(String string) throws JAXRPCException {
        if (this.javaType == Object.class) {
            return null;
        }
        SimpleListDeserializer simpleListDeserializer = (SimpleListDeserializer)super.getDeserializerAs(string);
        if (simpleListDeserializer != null) {
            simpleListDeserializer.setConstructor(this.constructor);
        }
        return simpleListDeserializer;
    }

    private Object readResolve() throws ObjectStreamException {
        return new SimpleListDeserializerFactory(this.clazzType, this.xmlType);
    }
}

