/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.IOException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.utils.IdentityHashMap;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class VectorSerializer
implements Serializer {
    protected static Log log = LogFactory.getLog(VectorSerializer.class.getName());

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        if (!(object instanceof Vector)) {
            throw new IOException(Messages.getMessage("noVector00", "VectorSerializer", object.getClass().getName()));
        }
        Vector vector = (Vector)object;
        if (this.isRecursive(new IdentityHashMap(), vector)) {
            throw new IOException(Messages.getMessage("badVector00"));
        }
        serializationContext.startElement(qName, attributes);
        for (Object e : vector) {
            serializationContext.serialize(Constants.QNAME_LITERAL_ITEM, null, e);
        }
        serializationContext.endElement();
    }

    public boolean isRecursive(IdentityHashMap identityHashMap, Vector vector) {
        identityHashMap.add(vector);
        boolean bl = false;
        for (int i = 0; i < vector.size() && !bl; ++i) {
            Object e = vector.get(i);
            if (!(e instanceof Vector)) continue;
            if (identityHashMap.containsKey(e)) {
                return true;
            }
            bl = this.isRecursive(identityHashMap, (Vector)e);
        }
        return bl;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class clazz, Types types) throws Exception {
        Element element = types.createElement("complexType");
        element.setAttribute("name", "Vector");
        types.writeSchemaTypeDecl(Constants.SOAP_VECTOR, element);
        Element element2 = types.createElement("sequence");
        element.appendChild(element2);
        Element element3 = types.createElement("element");
        element3.setAttribute("name", "item");
        element3.setAttribute("minOccurs", "0");
        element3.setAttribute("maxOccurs", "unbounded");
        element3.setAttribute("type", "xsd:anyType");
        element2.appendChild(element3);
        return element;
    }
}

