/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.security.AuthenticatedUser;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.security.simple.SimpleSecurityProvider;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SimpleAuthenticationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthenticationHandler.class.getName());

    public void invoke(MessageContext messageContext) throws AxisFault {
        SecurityProvider securityProvider;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthenticationHandler::invoke");
        }
        if ((securityProvider = (SecurityProvider)messageContext.getProperty("securityProvider")) == null) {
            securityProvider = new SimpleSecurityProvider();
            messageContext.setProperty("securityProvider", securityProvider);
        }
        if (securityProvider != null) {
            AuthenticatedUser authenticatedUser;
            String string = messageContext.getUsername();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("user00", string));
            }
            if (string == null || string.equals("")) {
                throw new AxisFault("Server.Unauthenticated", Messages.getMessage("cantAuth00", string), null, null);
            }
            String string2 = messageContext.getPassword();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("password00", string2));
            }
            if ((authenticatedUser = securityProvider.authenticate(messageContext)) == null) {
                throw new AxisFault("Server.Unauthenticated", Messages.getMessage("cantAuth01", string), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth00", string));
            }
            messageContext.setProperty("authenticatedUser", authenticatedUser);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SimpleAuthenticationHandler::invoke");
        }
    }
}

