/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.util.StringTokenizer;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.AuthenticatedUser;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SimpleAuthorizationHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog(SimpleAuthorizationHandler.class.getName());

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthorizationHandler::invoke");
        }
        boolean bl = JavaUtils.isTrueExplicitly(this.getOption("allowByDefault"));
        AuthenticatedUser authenticatedUser = (AuthenticatedUser)messageContext.getProperty("authenticatedUser");
        if (authenticatedUser == null) {
            throw new AxisFault("Server.NoUser", Messages.getMessage("needUser00"), null, null);
        }
        String string = authenticatedUser.getName();
        SOAPService sOAPService = messageContext.getService();
        if (sOAPService == null) {
            throw new AxisFault(Messages.getMessage("needService00"));
        }
        String string2 = sOAPService.getName();
        String string3 = (String)sOAPService.getOption("allowedRoles");
        if (string3 == null) {
            if (bl) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles00"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("noRoles01"));
                }
                throw new AxisFault("Server.Unauthorized", Messages.getMessage("notAuth00", string, string2), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        SecurityProvider securityProvider = (SecurityProvider)messageContext.getProperty("securityProvider");
        if (securityProvider == null) {
            throw new AxisFault(Messages.getMessage("noSecurity00"));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!securityProvider.userMatches(authenticatedUser, string4)) continue;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("auth01", string, string2));
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: SimpleAuthorizationHandler::invoke");
            }
            return;
        }
        throw new AxisFault("Server.Unauthorized", Messages.getMessage("cantAuth02", string, string2), null, null);
    }

    public void onFault(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SimpleAuthorizationHandler::onFault");
            log.debug("Exit: SimpleAuthorizationHandler::onFault");
        }
    }
}

