/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.i18n.Messages;
import org.apache.axis.message.NamedNodeMapImpl;
import org.apache.axis.message.NodeListImpl;
import org.apache.axis.message.NullAttributes;
import org.apache.axis.message.Text;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class NodeImpl
implements org.w3c.dom.Node,
Node,
Serializable,
Cloneable {
    protected static Log log = LogFactory.getLog(NodeImpl.class.getName());
    protected String name;
    protected String prefix;
    protected String namespaceURI;
    protected transient Attributes attributes = NullAttributes.singleton;
    protected Document document = null;
    protected NodeImpl parent = null;
    protected ArrayList children = null;
    protected CharacterData textRep = null;
    protected boolean _isDirty = false;
    private static final String NULL_URI_NAME = "intentionalNullURI";

    public NodeImpl() {
    }

    public NodeImpl(CharacterData characterData) {
        this.textRep = characterData;
        this.namespaceURI = characterData.getNamespaceURI();
        this.name = characterData.getLocalName();
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(org.w3c.dom.Node node) {
        return 0;
    }

    public String getTextContent() {
        return null;
    }

    public void setTextContent(String string) {
    }

    public boolean isSameNode(org.w3c.dom.Node node) {
        return false;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return true;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public boolean isEqualNode(org.w3c.dom.Node node) {
        return false;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public short getNodeType() {
        if (this.textRep != null) {
            if (this.textRep instanceof Comment) {
                return 8;
            }
            if (this.textRep instanceof CDATASection) {
                return 4;
            }
            return 3;
        }
        return 1;
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    public boolean hasChildNodes() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getNodeName() {
        return this.prefix != null && this.prefix.length() > 0 ? this.prefix + ":" + this.name : this.name;
    }

    public String getNodeValue() throws DOMException {
        if (this.textRep == null) {
            return null;
        }
        return this.textRep.getData();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(6, "Cannot use TextNode.set in " + this);
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setOwnerDocument(Document document) {
        this.document = document;
    }

    public Document getOwnerDocument() {
        NodeImpl nodeImpl;
        if (this.document == null && (nodeImpl = this.getParent()) != null) {
            return nodeImpl.getOwnerDocument();
        }
        return this.document;
    }

    public NamedNodeMap getAttributes() {
        this.makeAttributesEditable();
        return this.convertAttrSAXtoDOM(this.attributes);
    }

    public org.w3c.dom.Node getFirstChild() {
        if (this.children != null && !this.children.isEmpty()) {
            return (org.w3c.dom.Node)this.children.get(0);
        }
        return null;
    }

    public org.w3c.dom.Node getLastChild() {
        if (this.children != null && !this.children.isEmpty()) {
            return (org.w3c.dom.Node)this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public org.w3c.dom.Node getNextSibling() {
        SOAPElement sOAPElement = this.getParentElement();
        if (sOAPElement == null) {
            return null;
        }
        Iterator iterator = sOAPElement.getChildElements();
        org.w3c.dom.Node node = null;
        while (iterator.hasNext()) {
            if (iterator.next() != this) continue;
            if (iterator.hasNext()) {
                return (org.w3c.dom.Node)iterator.next();
            }
            return null;
        }
        return node;
    }

    public org.w3c.dom.Node getParentNode() {
        return this.getParent();
    }

    public org.w3c.dom.Node getPreviousSibling() {
        SOAPElement sOAPElement = this.getParentElement();
        if (sOAPElement == null) {
            return null;
        }
        NodeList nodeList = sOAPElement.getChildNodes();
        int n = nodeList.getLength();
        org.w3c.dom.Node node = null;
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i) == this) {
                return node;
            }
            node = nodeList.item(i);
        }
        return node;
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        return new NodeImpl(this.textRep);
    }

    public NodeList getChildNodes() {
        if (this.children == null) {
            return NodeListImpl.EMPTY_NODELIST;
        }
        return new NodeListImpl(this.children);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        if (node == null) {
            throw new DOMException(3, "Can't append a null node.");
        }
        this.initializeChildren();
        ((NodeImpl)node).detachNode();
        this.children.add(node);
        ((NodeImpl)node).parent = this;
        this.setDirty(true);
        return node;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node node) throws DOMException {
        if (this.removeNodeFromChildList((NodeImpl)node)) {
            this.setDirty(true);
            return node;
        }
        throw new DOMException(8, "NodeImpl Not found");
    }

    private boolean removeNodeFromChildList(NodeImpl nodeImpl) {
        boolean bl = false;
        this.initializeChildren();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            NodeImpl nodeImpl2 = (NodeImpl)iterator.next();
            if (nodeImpl2 != nodeImpl) continue;
            bl = true;
            iterator.remove();
        }
        return bl;
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        this.initializeChildren();
        int n = this.children.indexOf(node2);
        if (n < 0) {
            n = 0;
        }
        this.children.add(n, node);
        this.setDirty(true);
        return node;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        this.initializeChildren();
        int n = this.children.indexOf(node2);
        if (n < 0) {
            throw new DOMException(8, "NodeImpl Not found");
        }
        this.children.remove(n);
        this.children.add(n, node);
        this.setDirty(true);
        return node2;
    }

    public String getValue() {
        return this.textRep.getNodeValue();
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            this.setParent((NodeImpl)((Object)sOAPElement));
        }
        catch (Throwable throwable) {
            throw new SOAPException(throwable);
        }
    }

    public SOAPElement getParentElement() {
        return (SOAPElement)((Object)this.getParent());
    }

    public void detachNode() {
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public void recycleNode() {
    }

    public void setValue(String string) {
        if (this instanceof Text) {
            this.setNodeValue(string);
        } else if (this.children != null) {
            if (this.children.size() != 1) {
                throw new IllegalStateException("setValue() may not be called on a non-Text node with more than one child.");
            }
            Node node = (Node)this.children.get(0);
            if (!(node instanceof Text)) {
                throw new IllegalStateException("setValue() may not be called on a non-Text node with a non-Text child.");
            }
            ((javax.xml.soap.Text)node).setNodeValue(string);
        } else {
            this.appendChild(new Text(string));
        }
    }

    protected AttributesImpl makeAttributesEditable() {
        if (this.attributes == null || this.attributes instanceof NullAttributes) {
            this.attributes = new AttributesImpl();
        } else if (!(this.attributes instanceof AttributesImpl)) {
            this.attributes = new AttributesImpl(this.attributes);
        }
        return (AttributesImpl)this.attributes;
    }

    protected NamedNodeMap convertAttrSAXtoDOM(Attributes attributes) {
        try {
            Document document = XMLUtils.newDocument();
            AttributesImpl attributesImpl = (AttributesImpl)attributes;
            NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl();
            for (int i = 0; i < attributesImpl.getLength(); ++i) {
                Attr attr;
                String string = attributesImpl.getURI(i);
                String string2 = attributesImpl.getQName(i);
                String string3 = attributesImpl.getValue(i);
                if (string != null && string.trim().length() > 0) {
                    if (NULL_URI_NAME.equals(string)) {
                        string = null;
                    }
                    attr = document.createAttributeNS(string, string2);
                    attr.setValue(string3);
                    namedNodeMapImpl.setNamedItemNS(attr);
                    continue;
                }
                attr = document.createAttribute(string2);
                attr.setValue(string3);
                namedNodeMapImpl.setNamedItem(attr);
            }
            return namedNodeMapImpl;
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("saxToDomFailed00"), exception);
            return null;
        }
    }

    protected void initializeChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
    }

    protected NodeImpl getParent() {
        return this.parent;
    }

    protected void setParent(NodeImpl nodeImpl) throws SOAPException {
        if (this.parent == nodeImpl) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (nodeImpl != null) {
            nodeImpl.appendChild(this);
        }
        this.parent = nodeImpl;
    }

    public void output(SerializationContext serializationContext) throws Exception {
        if (this.textRep == null) {
            return;
        }
        boolean bl = serializationContext.getPretty();
        serializationContext.setPretty(false);
        if (this.textRep instanceof CDATASection) {
            serializationContext.writeString("<![CDATA[");
            serializationContext.writeString(((org.w3c.dom.Text)this.textRep).getData());
            serializationContext.writeString("]]>");
        } else if (this.textRep instanceof Comment) {
            serializationContext.writeString("<!--");
            serializationContext.writeString(this.textRep.getData());
            serializationContext.writeString("-->");
        } else if (this.textRep instanceof org.w3c.dom.Text) {
            serializationContext.writeSafeString(((org.w3c.dom.Text)this.textRep).getData());
        }
        serializationContext.setPretty(bl);
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void setDirty(boolean bl) {
        this._isDirty = bl;
        if (this._isDirty && this.parent != null) {
            this.parent.setDirty(true);
        }
    }
}

